/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.USignature;
import com.uopen.cryptionkit.utils.UUtils;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.util.encoders.Base64;

public class Md5Signature
implements USignature {
    private static final String Algorithm = "MD5";
    private ReturnType returnType = ReturnType.TYPE_HEX;

    @Override
    public void setReturnDataType(ReturnType mReturnType) {
        this.returnType = mReturnType;
    }

    @Override
    public byte[] sign(byte[] content) {
        if (content == null) {
            return null;
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance(Algorithm);
            byte[] bytes = md5.digest(content);
            return bytes;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String signToBase64(String content) {
        byte[] values = content.getBytes(Charset.forName("UTF-8"));
        return new String(Base64.encode((byte[])this.sign(values)));
    }

    @Override
    public String signToHexString(String content, boolean isUpper) {
        byte[] values = content.getBytes(Charset.forName("UTF-8"));
        String after = UUtils.byteArrayToHexString(this.sign(values));
        if (isUpper) {
            after = after.toUpperCase();
        }
        return after;
    }

    @Override
    public String signToString(String content) {
        switch (this.returnType) {
            case TYPE_STRING: {
                byte[] values = content.getBytes(Charset.forName("UTF-8"));
                return new String(values);
            }
            case TYPE_BASE64: {
                return this.signToBase64(content);
            }
            case TYPE_HEX: {
                return this.signToHexString(content, false);
            }
        }
        return null;
    }

    @Override
    public byte[] signByKey(byte[] privateKey, byte[] content) {
        return new byte[0];
    }

    @Override
    public String signByKey(String privateKey, String content) {
        return null;
    }

    @Override
    public boolean verify(String publicKey, String data, String sign) {
        return false;
    }
}

