/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.USignature;
import com.uopen.cryptionkit.utils.UUtils;
import java.nio.charset.Charset;
import org.bouncycastle.util.encoders.Base64;

public class Sm3Signature
implements USignature {
    private int cntBlock = 0;
    public static final byte[] iv;
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 64;
    private byte[] xBuf = new byte[64];
    private int xBufOff;
    private byte[] V = (byte[])iv.clone();
    public static int[] Tj;
    private ReturnType returnType = ReturnType.TYPE_HEX;

    public Sm3Signature() {
        System.arraycopy(this.xBuf, 0, this.xBuf, 0, this.xBuf.length);
        this.xBufOff = this.xBufOff;
        System.arraycopy(this.V, 0, this.V, 0, this.V.length);
    }

    public Sm3Signature(Sm3Signature t) {
        System.arraycopy(t.xBuf, 0, this.xBuf, 0, t.xBuf.length);
        this.xBufOff = t.xBufOff;
        System.arraycopy(t.V, 0, this.V, 0, t.V.length);
    }

    @Override
    public void setReturnDataType(ReturnType returnType) {
        this.returnType = returnType;
    }

    @Override
    public byte[] sign(byte[] content) {
        if (content != null) {
            byte[] md = new byte[32];
            byte[] msg1 = content;
            this.update(msg1, 0, msg1.length);
            this.doFinal(md, 0);
            return md;
        }
        return null;
    }

    @Override
    public byte[] signByKey(byte[] privateKey, byte[] content) {
        return null;
    }

    @Override
    public String signByKey(String privateKey, String content) {
        return null;
    }

    @Override
    public boolean verify(String publicKey, String data, String sign) {
        return false;
    }

    @Override
    public String signToString(String content) {
        switch (this.returnType) {
            case TYPE_STRING: {
                byte[] values = content.getBytes(Charset.forName("UTF-8"));
                return new String(values);
            }
            case TYPE_BASE64: {
                return this.signToBase64(content);
            }
            case TYPE_HEX: {
                return this.signToHexString(content, false);
            }
        }
        return null;
    }

    @Override
    public String signToBase64(String content) {
        byte[] values = content.getBytes(Charset.forName("UTF-8"));
        return new String(Base64.encode((byte[])this.sign(values)));
    }

    @Override
    public String signToHexString(String content, boolean isUpper) {
        byte[] values = content.getBytes(Charset.forName("UTF-8"));
        String after = UUtils.byteArrayToHexString(this.sign(values));
        if (isUpper) {
            after = after.toUpperCase();
        }
        return after;
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = this.doFinal();
        System.arraycopy(tmp, 0, out, 0, tmp.length);
        return 32;
    }

    public void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = (byte[])iv.clone();
    }

    public void update(byte[] in, int inOff, int len) {
        int partLen = 64 - this.xBufOff;
        int inputLen = len;
        int dPos = inOff;
        if (partLen < inputLen) {
            System.arraycopy(in, dPos, this.xBuf, this.xBufOff, partLen);
            inputLen -= partLen;
            dPos += partLen;
            this.doUpdate();
            while (inputLen > 64) {
                System.arraycopy(in, dPos, this.xBuf, 0, 64);
                inputLen -= 64;
                dPos += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(in, dPos, this.xBuf, this.xBufOff, inputLen);
        this.xBufOff += inputLen;
    }

    private void doUpdate() {
        byte[] B = new byte[64];
        for (int i = 0; i < 64; i += 64) {
            System.arraycopy(this.xBuf, i, B, 0, B.length);
            this.doHash(B);
        }
        this.xBufOff = 0;
    }

    private void doHash(byte[] B) {
        byte[] tmp = this.CF(this.V, B);
        System.arraycopy(tmp, 0, this.V, 0, this.V.length);
        ++this.cntBlock;
    }

    private byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = this.padding(buffer, this.cntBlock);
        for (int i = 0; i < tmp.length; i += 64) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.doHash(B);
        }
        return this.V;
    }

    public void update(byte in) {
        byte[] buffer = new byte[]{in};
        this.update(buffer, 0, 1);
    }

    public int getDigestSize() {
        return 32;
    }

    public byte[] CF(byte[] V, byte[] B) {
        int[] v = this.convert(V);
        int[] b = this.convert(B);
        return this.convert(this.CF(v, b));
    }

    private int[] convert(byte[] arr) {
        int[] out = new int[arr.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < arr.length; i += 4) {
            System.arraycopy(arr, i, tmp, 0, 4);
            out[i / 4] = this.bigEndianByteToInt(tmp);
        }
        return out;
    }

    private byte[] convert(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        for (int i = 0; i < arr.length; ++i) {
            tmp = this.bigEndianIntToByte(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
        }
        return out;
    }

    public int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = this.expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        for (int j = 0; j < 64; ++j) {
            int ss1 = this.bitCycleLeft(a, 12) + e + this.bitCycleLeft(Tj[j], j);
            ss1 = this.bitCycleLeft(ss1, 7);
            int ss2 = ss1 ^ this.bitCycleLeft(a, 12);
            int tt1 = this.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = this.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = this.bitCycleLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = this.bitCycleLeft(f, 19);
            f = e;
            e = this.P0(tt2);
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private int[][] expand(int[] B) {
        int i;
        int[] W = new int[68];
        int[] W1 = new int[64];
        for (i = 0; i < B.length; ++i) {
            W[i] = B[i];
        }
        for (i = 16; i < 68; ++i) {
            W[i] = this.P1(W[i - 16] ^ W[i - 9] ^ this.bitCycleLeft(W[i - 3], 15)) ^ this.bitCycleLeft(W[i - 13], 7) ^ W[i - 6];
        }
        for (i = 0; i < 64; ++i) {
            W1[i] = W[i] ^ W[i + 4];
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    private byte[] bigEndianIntToByte(int num) {
        return this.back(UUtils.intToBytes(num));
    }

    private int bigEndianByteToInt(byte[] bytes) {
        return UUtils.byteToInt(this.back(bytes));
    }

    private int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return this.FF1j(X, Y, Z);
        }
        return this.FF2j(X, Y, Z);
    }

    private int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return this.GG1j(X, Y, Z);
        }
        return this.GG2j(X, Y, Z);
    }

    private int FF1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private int FF2j(int X, int Y, int Z) {
        int tmp = X & Y | X & Z | Y & Z;
        return tmp;
    }

    private int GG1j(int X, int Y, int Z) {
        int tmp = X ^ Y ^ Z;
        return tmp;
    }

    private int GG2j(int X, int Y, int Z) {
        int tmp = X & Y | ~X & Z;
        return tmp;
    }

    private int P0(int X) {
        int y = this.rotateLeft(X, 9);
        y = this.bitCycleLeft(X, 9);
        int z = this.rotateLeft(X, 17);
        z = this.bitCycleLeft(X, 17);
        int t = X ^ y ^ z;
        return t;
    }

    private int P1(int X) {
        int t = X ^ this.bitCycleLeft(X, 15) ^ this.bitCycleLeft(X, 23);
        return t;
    }

    public byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = this.back(UUtils.longToBytes(n));
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private byte[] back(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[out.length - i - 1];
        }
        return out;
    }

    public int rotateLeft(int x, int n) {
        return x << n | x >> 32 - n;
    }

    private int bitCycleLeft(int n, int bitLen) {
        byte[] tmp = this.bigEndianIntToByte(n);
        int byteLen = (bitLen %= 32) / 8;
        int len = bitLen % 8;
        if (byteLen > 0) {
            tmp = this.byteCycleLeft(tmp, byteLen);
        }
        if (len > 0) {
            tmp = this.bitSmall8CycleLeft(tmp, len);
        }
        return this.bigEndianByteToInt(tmp);
    }

    private byte[] bitSmall8CycleLeft(byte[] in, int len) {
        byte[] tmp = new byte[in.length];
        for (int i = 0; i < tmp.length; ++i) {
            byte t1 = (byte)((in[i] & 0xFF) << len);
            byte t2 = (byte)((in[(i + 1) % tmp.length] & 0xFF) >> 8 - len);
            byte t3 = (byte)(t1 | t2);
            tmp[i] = t3;
        }
        return tmp;
    }

    private byte[] byteCycleLeft(byte[] in, int byteLen) {
        byte[] tmp = new byte[in.length];
        System.arraycopy(in, byteLen, tmp, 0, in.length - byteLen);
        System.arraycopy(in, 0, tmp, in.length - byteLen, byteLen);
        return tmp;
    }

    static {
        int i;
        iv = new byte[]{115, -128, 22, 111, 73, 20, -78, -71, 23, 36, 66, -41, -38, -118, 6, 0, -87, 111, 48, -68, 22, 49, 56, -86, -29, -115, -18, 77, -80, -5, 14, 78};
        Tj = new int[64];
        for (i = 0; i < 16; ++i) {
            Sm3Signature.Tj[i] = 2043430169;
        }
        for (i = 16; i < 64; ++i) {
            Sm3Signature.Tj[i] = 2055708042;
        }
    }
}

