/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.utils.UUtils;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.util.encoders.Base64;

public class DesCipher
implements UCipher {
    private static final String ALGORITHM_DES = "DES/CBC/PKCS5Padding";
    private static final String Algorithm = "DES";
    private static final String IV = "12345678";
    private ReturnType returnType = ReturnType.TYPE_HEX;

    @Override
    public void setReturnDataType(ReturnType returnType) {
        this.returnType = returnType;
    }

    @Override
    public void setExtendParams(HashMap<String, String> extendParams) {
    }

    @Override
    public byte[] encode(String key, byte[] content) throws Exception {
        if (content == null || key == null) {
            return null;
        }
        try {
            IvParameterSpec iv;
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(Algorithm);
            DESKeySpec dks = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKey secretKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance(ALGORITHM_DES);
            IvParameterSpec paramSpec = iv = new IvParameterSpec(IV.getBytes());
            cipher.init(1, (Key)secretKey, paramSpec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String encode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.encodeToHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.encodeToBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String encodeToBase64(String key, String content) throws Exception {
        byte[] contents = content.getBytes(Charset.forName("UTF-8"));
        contents = this.encode(key, contents);
        return new String(Base64.encode((byte[])contents));
    }

    @Override
    public String encodeToHexString(String key, String content) throws Exception {
        byte[] contents = content.getBytes(Charset.forName("UTF-8"));
        contents = this.encode(key, contents);
        return UUtils.byteArrayToHexString(contents);
    }

    @Override
    public byte[] decode(String key, byte[] content) throws Exception {
        if (content == null || key == null) {
            return null;
        }
        try {
            IvParameterSpec iv;
            DESKeySpec dks = new DESKeySpec(key.getBytes("UTF-8"));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(Algorithm);
            SecretKey secretKey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance(ALGORITHM_DES);
            IvParameterSpec paramSpec = iv = new IvParameterSpec(IV.getBytes());
            cipher.init(2, (Key)secretKey, paramSpec);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String decode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.decodeByHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.decodeByBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.decode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String decodeByBase64(String key, String contentBase64) throws Exception {
        byte[] contents = this.decode(key, Base64.decode((String)contentBase64));
        if (contents != null) {
            return new String(contents);
        }
        return null;
    }

    @Override
    public String decodeByHexString(String key, String contentHex) throws Exception {
        byte[] contents = this.decode(key, UUtils.hexStringToByteArray(contentHex));
        return new String(contents);
    }
}

