/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.core;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.UCipher;
import com.uopen.cryptionkit.utils.StringUtils;
import com.uopen.cryptionkit.utils.UUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Certificate;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import org.bouncycastle.util.encoders.Base64;

public class RsaPrivateCipher
implements UCipher {
    private static final String ALGORITHM = "RSA";
    private ReturnType returnType = ReturnType.TYPE_HEX;

    @Override
    public void setReturnDataType(ReturnType mReturnType) {
        this.returnType = mReturnType;
    }

    @Override
    public void setExtendParams(HashMap<String, String> extendParams) {
    }

    @Override
    public String encode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.encodeToHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.encodeToBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.encode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public String decode(String key, String content) throws Exception {
        switch (this.returnType) {
            case TYPE_HEX: {
                return this.decodeByHexString(key, content);
            }
            case TYPE_BASE64: {
                return this.decodeByBase64(key, content);
            }
            case TYPE_STRING: {
                byte[] values = this.decode(key, content.getBytes(Charset.forName("UTF-8")));
                return new String(values);
            }
        }
        return null;
    }

    @Override
    public byte[] encode(String base64Key, byte[] content) throws Exception {
        if (StringUtils.isNull(base64Key) || content == null) {
            return null;
        }
        RSAPrivateKey rsaPrivateKey = KeyPairHelper.getPrivateKey(base64Key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, rsaPrivateKey);
        int splitLength = rsaPrivateKey.getModulus().bitLength() / 8 - 11;
        byte[][] arrays = UUtils.splitBytes(content, splitLength);
        StringBuffer stringBuffer = new StringBuffer();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (byte[] array : arrays) {
            outputStream.write(cipher.doFinal(array));
        }
        return outputStream.toByteArray();
    }

    @Override
    public String encodeToBase64(String base64Key, String content) throws Exception {
        byte[] values = this.encode(base64Key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return new String(Base64.encode((byte[])values));
        }
        return null;
    }

    @Override
    public String encodeToHexString(String base64Key, String content) throws Exception {
        byte[] values = this.encode(base64Key, content.getBytes(Charset.forName("UTF-8")));
        if (values != null) {
            return UUtils.byteArrayToHexString(values);
        }
        return null;
    }

    @Override
    public byte[] decode(String base64Key, byte[] content) throws Exception {
        RSAPrivateKey rsaPrivateKey = KeyPairHelper.getPrivateKey(base64Key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, rsaPrivateKey);
        int splitLength = rsaPrivateKey.getModulus().bitLength() / 8;
        byte[][] arrays = UUtils.splitBytes(content, splitLength);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (byte[] array : arrays) {
            outputStream.write(cipher.doFinal(array));
        }
        return outputStream.toByteArray();
    }

    @Override
    public String decodeByBase64(String base64Key, String contentBase64) throws Exception {
        byte[] values = this.decode(base64Key, Base64.decode((String)contentBase64));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }

    @Override
    public String decodeByHexString(String base64Key, String contentHex) throws Exception {
        byte[] values = this.decode(base64Key, UUtils.hexStringToByteArray(contentHex));
        if (values != null) {
            return new String(values, Charset.forName("UTF-8"));
        }
        return null;
    }

    public static class KeyPairHelper {
        private static Map<String, Object> certMap = new ConcurrentHashMap<String, Object>();
        private static final String PUBLIC_KEY_NAME = "publicKey";
        private static final String PRIVATE_KEY_NAME = "privateKey";
        private static final String PUBLIC_FILENAME = "publicKey.properties";
        private static final String PRIVATE_FILENAME = "privateKey.properties";
        private static final int KEY_SIZE = 2048;
        private static KeyPairGenerator keyPairGenerator = null;
        private static KeyFactory keyFactory = null;
        private static KeyPair keyPair = null;

        public static synchronized void generateKeyPair() {
            try {
                keyPairGenerator.initialize(2048, new SecureRandom(UUID.randomUUID().toString().getBytes()));
                keyPair = keyPairGenerator.generateKeyPair();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
            String publicKeyString = new String(Base64.encode((byte[])rsaPublicKey.getEncoded()), Charset.forName("UTF-8"));
            String privateKeyString = new String(Base64.encode((byte[])rsaPrivateKey.getEncoded()), Charset.forName("UTF-8"));
            KeyPairHelper.storeKey(publicKeyString, PUBLIC_KEY_NAME, PUBLIC_FILENAME);
            KeyPairHelper.storeKey(privateKeyString, PRIVATE_KEY_NAME, PRIVATE_FILENAME);
        }

        private static void storeKey(String keyString, String keyName, String fileName) {
            Properties properties = new Properties();
            String path = null;
            try {
                path = RsaPrivateCipher.class.getClassLoader().getResource(fileName).toString();
                path = path.substring(path.indexOf(":") + 1);
            }
            catch (NullPointerException e) {
                String classPath = RsaPrivateCipher.class.getClassLoader().getResource("").toString();
                String prefix = classPath.substring(classPath.indexOf(":") + 1);
                String suffix = fileName;
                File file = new File(prefix + suffix);
                try {
                    file.createNewFile();
                    path = file.getAbsolutePath();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                FileOutputStream out = new FileOutputStream(path);
                properties.setProperty(keyName, keyString);
                properties.store(out, "There is " + keyName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private static String getKeyString(String keyName, String fileName) throws Exception {
            if (RsaPrivateCipher.class.getClassLoader().getResource(fileName) == null) {
                KeyPairHelper.generateKeyPair();
            }
            InputStream in = RsaPrivateCipher.class.getClassLoader().getResource(fileName).openStream();
            Properties properties = new Properties();
            properties.load(in);
            return properties.getProperty(keyName);
        }

        public static RSAPublicKey getPublicKey() throws Exception {
            String base64KeyPass = KeyPairHelper.getKeyString(PUBLIC_KEY_NAME, PUBLIC_FILENAME);
            RSAPublicKey rsaPublicKey = (RSAPublicKey)certMap.get("PublicKey" + base64KeyPass.hashCode());
            if (rsaPublicKey != null) {
                return rsaPublicKey;
            }
            byte[] keyBytes = Base64.decode((String)base64KeyPass);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            certMap.put("PublicKey" + base64KeyPass.hashCode(), rsaPublicKey);
            return rsaPublicKey;
        }

        public static RSAPublicKey getPublicKey(String base64KeyPass) throws Exception {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)certMap.get("PublicKey" + base64KeyPass.hashCode());
            if (rsaPublicKey != null) {
                return rsaPublicKey;
            }
            byte[] keyBytes = Base64.decode((String)base64KeyPass);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
            rsaPublicKey = (RSAPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            certMap.put("PublicKey" + base64KeyPass.hashCode(), rsaPublicKey);
            return rsaPublicKey;
        }

        public static RSAPrivateKey getPrivateKey() throws Exception {
            String base64PrivateKey = KeyPairHelper.getKeyString(PRIVATE_KEY_NAME, PRIVATE_FILENAME);
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)certMap.get("PrivateKey" + base64PrivateKey.hashCode());
            if (rsaPrivateKey != null) {
                return rsaPrivateKey;
            }
            byte[] keyBytes = Base64.decode((String)base64PrivateKey);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
            rsaPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            certMap.put("PrivateKey" + base64PrivateKey.hashCode(), rsaPrivateKey);
            return rsaPrivateKey;
        }

        public static RSAPrivateKey getPrivateKey(String base64KeyPass) throws Exception {
            RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)certMap.get("PrivateKey" + base64KeyPass.hashCode());
            if (rsaPrivateKey != null) {
                return rsaPrivateKey;
            }
            byte[] keyBytes = Base64.decode((String)base64KeyPass);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
            rsaPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            certMap.put("PrivateKey" + base64KeyPass.hashCode(), rsaPrivateKey);
            return rsaPrivateKey;
        }

        public static PublicKey getPublicKeyFromCert(InputStream ins) throws Exception {
            PublicKey pubKey = (PublicKey)certMap.get("PublicKey");
            if (pubKey != null) {
                return pubKey;
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate cac = (Certificate)((Object)cf.generateCertificate(ins));
                pubKey = cac.getPublicKey();
                certMap.put("PublicKey", pubKey);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (ins != null) {
                    ins.close();
                }
            }
            return pubKey;
        }

        public static PrivateKey getPrivateKeyFromPKCS12(String pfxFilePath, String password) throws Exception {
            PrivateKey priKey;
            block8: {
                priKey = (PrivateKey)certMap.get("PrivateKey");
                if (priKey != null) {
                    return priKey;
                }
                KeyStore keystoreCA = KeyStore.getInstance("PKCS12");
                try (FileInputStream inputStream = new FileInputStream(pfxFilePath);){
                    keystoreCA.load(inputStream, password.toCharArray());
                    Enumeration<String> aliases = keystoreCA.aliases();
                    String keyAlias = null;
                    if (aliases == null) break block8;
                    while (aliases.hasMoreElements()) {
                        keyAlias = aliases.nextElement();
                        priKey = (PrivateKey)keystoreCA.getKey(keyAlias, password.toCharArray());
                        if (priKey == null) continue;
                        certMap.put("PrivateKey", priKey);
                        break;
                    }
                }
            }
            return priKey;
        }

        static {
            try {
                keyPairGenerator = KeyPairGenerator.getInstance(RsaPrivateCipher.ALGORITHM);
                keyFactory = KeyFactory.getInstance(RsaPrivateCipher.ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }
}

