/*
 * Decompiled with CFR 0.152.
 */
package com.uopen.cryptionkit.utils;

import com.uopen.cryptionkit.ReturnType;
import com.uopen.cryptionkit.core.Sm2Cipher;
import com.uopen.cryptionkit.utils.UUtils;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class SM2KeyHelper {
    public static KeyPair generateKeyPair(Sm2Cipher sm2Kit) {
        if (sm2Kit == null) {
            return null;
        }
        AsymmetricCipherKeyPair key = sm2Kit.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        KeyPair keyPair = new KeyPair();
        if (sm2Kit.getReturnType().equals((Object)ReturnType.TYPE_BASE64)) {
            keyPair.setPublicKey(UUtils.convertToBase64(publicKey.getEncoded()));
            keyPair.setPrivateKey(UUtils.convertToBase64(privateKey.toByteArray()));
        } else {
            keyPair.setPublicKey(UUtils.byteArrayToHexString(publicKey.getEncoded()));
            keyPair.setPrivateKey(UUtils.byteArrayToHexString(privateKey.toByteArray()));
        }
        return keyPair;
    }

    public static void main(String[] args) {
        try {
            Sm2Cipher sm2Cipher = new Sm2Cipher();
            sm2Cipher.setReturnDataType(ReturnType.TYPE_HEX);
            KeyPair keyPair = SM2KeyHelper.generateKeyPair(sm2Cipher);
            System.out.println("pri:" + keyPair.getPrivateKey());
            System.out.println("pub:" + keyPair.getPublicKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class KeyPair {
        private String publicKey;
        private String privateKey;

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }
    }
}

