/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.javamysqlutils;

import ch.framedev.javamysqlutils.JsonConnection;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MySQL {
    public static String host;
    public static String user;
    public static String password;
    public static String database;
    public static String port;
    private static JsonConnection jsonConnection;
    public static Connection connection;
    private static boolean allowPublicKey;
    private static HikariDataSource ds;
    private static final ExecutorService executor;

    public static void setJsonConnection(JsonConnection jsonConnection) {
        MySQL.jsonConnection = jsonConnection;
    }

    public JsonConnection getJsonConnection() {
        return jsonConnection;
    }

    public MySQL(JsonConnection jsonConnection) {
        MySQL.jsonConnection = jsonConnection;
        host = jsonConnection.getHost();
        user = jsonConnection.getUser();
        password = jsonConnection.getPassword();
        database = jsonConnection.getDatabase();
        port = String.valueOf(jsonConnection.getPort());
    }

    public MySQL(String host, String user, String password, int port, String database) {
        MySQL.host = host;
        MySQL.user = user;
        MySQL.password = password;
        MySQL.port = String.valueOf(port);
        MySQL.database = database;
    }

    public static void setAllowPublicKey(boolean allowPublicKey) {
        MySQL.allowPublicKey = allowPublicKey;
    }

    public static boolean isAllowPublicKey() {
        return allowPublicKey;
    }

    public static String getHost() {
        return host;
    }

    public static void setHost(String host) {
        MySQL.host = host;
    }

    public static String getUser() {
        return user;
    }

    public static void setUser(String user) {
        MySQL.user = user;
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String password) {
        MySQL.password = password;
    }

    public static String getDatabase() {
        return database;
    }

    public static void setDatabase(String database) {
        MySQL.database = database;
    }

    public static String getPort() {
        return port;
    }

    public static void setPort(String port) {
        MySQL.port = port;
    }

    public static void connect() {
        if (ds == null) {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
                System.out.println("Driver loaded manually.");
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("com.mysql.jdbc.Driver");
                    System.out.println("Driver loaded manually.");
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database);
            config.setUsername(user);
            config.setPassword(password);
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("useServerPrepStmts", "true");
            config.addDataSourceProperty("useSSL", "false");
            config.addDataSourceProperty("serverTimezone", "UTC");
            config.addDataSourceProperty("allowPublicKeyRetrieval", "true");
            ds = new HikariDataSource(config);
        }
    }

    public static Connection getConnection() throws SQLException {
        if (ds == null) {
            MySQL.connect();
        }
        return ds.getConnection();
    }

    public static void close() {
        if (ds != null && !ds.isClosed()) {
            ds.close();
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isTableExists(String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void isTableExistsAsync(String table, Callback<Boolean> callback) {
        executor.execute(() -> {
            String sql = "SHOW TABLES LIKE ?";
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, table);
                try (ResultSet rs = stmt.executeQuery();){
                    callback.onResult(rs.next());
                }
            }
            catch (SQLException ex) {
                callback.onError(ex);
            }
        });
    }

    public static boolean createTable(String tableName, String ... columns) {
        boolean bl;
        block8: {
            MySQL.throwErrorOnLength(columns == null || columns.length == 0, "At least one column must be specified.");
            String columnDefinitions = MySQL.getColumnDefinitions(columns);
            String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (ID INT PRIMARY KEY AUTO_INCREMENT, " + columnDefinitions + ", created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);";
            PreparedStatement stmt = MySQL.getConnection().prepareStatement(sql);
            try {
                boolean bl2 = bl = stmt.executeUpdate() > 0;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            stmt.close();
        }
        return bl;
    }

    public static void createTableAsync(String tableName, final Callback<Boolean> callback, String ... columns) {
        MySQL.throwErrorOnLength(columns == null || columns.length == 0, "At least one column must be specified.");
        String columnDefinitions = MySQL.getColumnDefinitions(columns);
        final String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (ID INT PRIMARY KEY AUTO_INCREMENT, " + columnDefinitions + ", created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);";
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try (PreparedStatement stmt = MySQL.getConnection().prepareStatement(sql);){
                    stmt.execute();
                    callback.onResult(true);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }
        });
    }

    private static String getColumnDefinitions(String[] columns) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            stringBuilder.append(columns[i]);
            if (i >= columns.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean insertData(String table, Object[] data, String[] columns) {
        MySQL.throwErrorOnLength(columns == null || columns.length == 0 || data == null || data.length == 0, "Columns and data must be provided.");
        MySQL.throwErrorOnLength(columns.length != data.length, "Number of columns and data values must match.");
        String sql = MySQL.createInsertSQL(table, columns);
        try (Connection conn = MySQL.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    for (int i = 0; i < data.length; ++i) {
                        stmt.setObject(i + 1, data[i]);
                    }
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void insertDataAsync(String table, Object[] data, String[] columns, Callback<Boolean> callback) {
        MySQL.throwErrorOnLength(columns == null || columns.length == 0 || data == null || data.length == 0, "Columns and data must be provided.");
        MySQL.throwErrorOnLength(columns.length != data.length, "Number of columns and data values must match.");
        String sql = MySQL.createInsertSQL(table, columns);
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                for (int i = 0; i < data.length; ++i) {
                    stmt.setObject(i + 1, data[i]);
                }
                callback.onResult(stmt.executeUpdate() > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    private static String createInsertSQL(String table, String[] columns) {
        StringBuilder columnsBuilder = new StringBuilder();
        StringBuilder placeholdersBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            columnsBuilder.append(columns[i]);
            placeholdersBuilder.append("?");
            if (i >= columns.length - 1) continue;
            columnsBuilder.append(", ");
            placeholdersBuilder.append(", ");
        }
        return "INSERT INTO " + table + " (" + columnsBuilder + ") VALUES (" + placeholdersBuilder + ")";
    }

    private static void throwErrorOnLength(boolean length, String s) {
        if (length) {
            throw new IllegalArgumentException(s);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean updateData(String table, String column, Object value, String whereClause) {
        String sql = "UPDATE " + table + " SET " + column + " = ? WHERE " + whereClause;
        try (Connection conn = MySQL.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setObject(1, value);
                    int result = stmt.executeUpdate();
                    boolean bl2 = bl = result > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void updateDataAsync(String table, String column, Object value, String whereClause, Callback<Boolean> callback) {
        String sql = "UPDATE " + table + " SET " + column + " = ? WHERE " + whereClause;
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setObject(1, value);
                int result = stmt.executeUpdate();
                callback.onResult(result > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean updateData(String table, String[] columns, Object[] values, String where) {
        if (columns.length == 0 || values.length == 0 || columns.length != values.length) {
            throw new IllegalArgumentException("Columns and values arrays must not be empty and must have the same length.");
        }
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            setClause.append(columns[i]).append(" = ?");
            if (i >= columns.length - 1) continue;
            setClause.append(", ");
        }
        String sql = "UPDATE " + table + " SET " + setClause.toString() + " WHERE " + where;
        try (Connection conn = MySQL.getConnection();){
            boolean bl;
            block17: {
                PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);
                try {
                    for (int i = 0; i < values.length; ++i) {
                        pstmt.setObject(i + 1, values[i]);
                    }
                    boolean bl2 = bl = pstmt.executeUpdate() > 0;
                    if (pstmt == null) break block17;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void updateDataAsync(String table, String[] columns, Object[] values, String where, Callback<Boolean> callback) {
        if (columns.length == 0 || values.length == 0 || columns.length != values.length) {
            throw new IllegalArgumentException("Columns and values arrays must not be empty and must have the same length.");
        }
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            setClause.append(columns[i]).append(" = ?");
            if (i >= columns.length - 1) continue;
            setClause.append(", ");
        }
        String sql = "UPDATE " + table + " SET " + setClause.toString() + " WHERE " + where;
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                for (int i = 0; i < values.length; ++i) {
                    pstmt.setObject(i + 1, values[i]);
                }
                callback.onResult(pstmt.executeUpdate() > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteDataInTable(String table, String whereClause) {
        String sql = "DELETE FROM " + table + " WHERE " + whereClause;
        try (Connection conn = MySQL.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    int result = stmt.executeUpdate();
                    boolean bl2 = bl = result > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void deleteDataInTableAsync(String table, String whereClause, Callback<Boolean> callback) {
        String sql = "DELETE FROM " + table + " WHERE " + whereClause;
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                int result = stmt.executeUpdate();
                callback.onResult(result > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteDataInTable(String table, String whereColumn, String whereValue, String andColumn, String andValue) {
        String sql = "DELETE FROM " + table + " WHERE " + whereColumn + " = ? AND " + andColumn + " = ?";
        try (Connection conn = MySQL.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, whereValue);
                    stmt.setString(2, andValue);
                    int result = stmt.executeUpdate();
                    boolean bl2 = bl = result > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void deleteDataInTableAsync(String table, String whereColumn, String whereValue, String andColumn, String andValue, Callback<Boolean> callback) {
        String sql = "DELETE FROM " + table + " WHERE " + whereColumn + " = ? AND " + andColumn + " = ?";
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, whereValue);
                stmt.setString(2, andValue);
                int result = stmt.executeUpdate();
                callback.onResult(result > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public static boolean exists(String table, String column, String data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void existsAsync(String table, String column, String data, Callback<Boolean> callback) {
        String sql = "SELECT * FROM " + table + " WHERE " + column + " = ?";
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, data);
                try (ResultSet res = stmt.executeQuery();){
                    callback.onResult(res.next());
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public static boolean exists(String table, String column, String data, String andCondition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void existsAsync(String table, String column, String data, String andCondition, Callback<Boolean> callback) {
        String sql = "SELECT * FROM " + table + " WHERE " + column + " = ? AND " + andCondition;
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, data);
                try (ResultSet res = stmt.executeQuery();){
                    callback.onResult(res.next());
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    public static void getAsync(String table, String selected, String column, String data, Callback<Object> callback) {
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, data);
                try (ResultSet res = stmt.executeQuery();){
                    if (res.next()) {
                        callback.onResult(res.getObject(selected));
                    }
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object get(String table, String selected, String column, String data) {
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        try (Connection conn = MySQL.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, data);
            try (ResultSet res = stmt.executeQuery();){
                if (!res.next()) return null;
                Object object = res.getObject(selected);
                return object;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<Object> get(String table, String[] selectedColumns, String column, Object data, String andColumn, Object andValue) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ? AND " + andColumn + " = ?";
        ArrayList<Object> results = new ArrayList<Object>();
        try (Connection conn = MySQL.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            pstmt.setObject(2, andValue);
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    Object row = null;
                    for (String selectedColumn : selectedColumns) {
                        row = res.getObject(selectedColumn);
                        results.add(row);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return results;
    }

    public static void getAsync(String table, String[] selectedColumns, String column, Object data, String andColumn, Object andValue, Callback<List<Object>> callback) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ? AND " + andColumn + " = ?";
        ArrayList results = new ArrayList();
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setObject(1, data);
                pstmt.setObject(2, andValue);
                try (ResultSet res = pstmt.executeQuery();){
                    while (res.next()) {
                        Object row = null;
                        for (String selectedColumn : selectedColumns) {
                            row = res.getObject(selectedColumn);
                            results.add(row);
                        }
                    }
                    callback.onResult(results);
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    public static List<Object> get(String table, String[] selectedColumns, String column, Object data) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ?";
        ArrayList<Object> results = new ArrayList<Object>();
        try (Connection conn = MySQL.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    Object row = null;
                    for (String selectedColumn : selectedColumns) {
                        row = res.getObject(selectedColumn);
                        results.add(row);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return results;
    }

    public static void getAsync(String table, String[] selectedColumns, String column, Object data, Callback<List<Object>> callback) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ?";
        ArrayList results = new ArrayList();
        executor.execute(() -> {
            try (Connection conn = MySQL.getConnection();
                 PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setObject(1, data);
                try (ResultSet res = pstmt.executeQuery();){
                    while (res.next()) {
                        Object row = null;
                        for (String selectedColumn : selectedColumns) {
                            row = res.getObject(selectedColumn);
                            results.add(row);
                        }
                    }
                    callback.onResult(results);
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    public static void addColumn(final String table, final String column, final Callback<Boolean> callback) {
        MySQL.isTableExistsAsync(table, new Callback<Boolean>(){

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    String sql = "ALTER TABLE " + table + " ADD COLUMN " + column;
                    try (Connection conn = MySQL.getConnection();
                         Statement stmt = conn.createStatement();){
                        stmt.executeUpdate(sql);
                        callback.onResult(true);
                    }
                    catch (SQLException ex) {
                        callback.onError(ex);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public static void removeColumn(final String table, final String column, final Callback<Boolean> callback) {
        MySQL.isTableExistsAsync(table, new Callback<Boolean>(){

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    String sql = "ALTER TABLE " + table + " DROP COLUMN " + column;
                    try (Connection conn = MySQL.getConnection();
                         Statement stmt = conn.createStatement();){
                        stmt.executeUpdate(sql);
                        callback.onResult(true);
                    }
                    catch (SQLException ex) {
                        callback.onError(ex);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public static void showColumns(final String table, final Callback<List<String>> callback) {
        final ArrayList columns = new ArrayList();
        MySQL.isTableExistsAsync(table, new Callback<Boolean>(){

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    String sql = "SHOW COLUMNS FROM " + table;
                    try (Connection conn = MySQL.getConnection();
                         Statement stmt = conn.createStatement();
                         ResultSet resultSet = stmt.executeQuery(sql);){
                        while (resultSet.next()) {
                            columns.add(resultSet.getString("Field"));
                        }
                        callback.onResult(columns);
                    }
                    catch (SQLException ex) {
                        callback.onError(ex);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    static {
        executor = Executors.newFixedThreadPool(10);
    }

    public static interface Callback<T> {
        public void onResult(T var1);

        public void onError(Throwable var1);
    }

    public static class Builder {
        private String host;
        private String user;
        private String password;
        private int port;
        private String database;
        private boolean allowPublicKey = false;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder allowPublicKey(boolean allowPublicKey) {
            this.allowPublicKey = allowPublicKey;
            return this;
        }

        public MySQL build() {
            MySQL.setHost(this.host);
            MySQL.setUser(this.user);
            MySQL.setPassword(this.password);
            MySQL.setPort(String.valueOf(this.port));
            MySQL.setDatabase(this.database);
            MySQL.setAllowPublicKey(this.allowPublicKey);
            return new MySQL(this.host, this.user, this.password, this.port, this.database);
        }
    }
}

