/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

public enum Length {
    MILLIMETER(0.001),
    CENTIMETER(0.01),
    METER(1.0),
    KILOMETER(1000.0),
    INCH(0.0254),
    FOOT(0.3048),
    YARD(0.9144),
    MILE(1609.344),
    LIGHT_YEAR(9.461E15);

    private final double toMeters;

    private Length(double toMeters) {
        this.toMeters = toMeters;
    }

    public double getValue() {
        return this.toMeters;
    }

    public double convertTo(double value, Length to) {
        return value * this.toMeters / to.toMeters;
    }

    public String toString() {
        return this.name() + " (" + this.toMeters + " meters)";
    }
}

