/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.Main;
import ch.framedev.simplejavautils.SimpleJavaUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;

public class TokenHandler {
    private Properties properties;
    private final File file;
    private final SimpleJavaUtils utils = new SimpleJavaUtils();
    private final String fileName;

    public TokenHandler(String fileName) {
        this.fileName = fileName;
        this.file = this.utils.getFromResourceFile(fileName, Main.class);
        this.file.deleteOnExit();
        try {
            this.loadProperties();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadProperties() throws IOException {
        Properties resourceProperties = new Properties();
        resourceProperties.load(new FileReader(this.utils.getFromResourceFile(this.fileName, Main.class)));
        this.properties = new Properties();
        this.properties.load(new FileReader(this.file));
        resourceProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!this.properties.containsKey(key)) {
                this.properties.put(key, value);
            }
        }));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean contains(String key) {
        return this.properties.containsKey(key);
    }
}

