/*
 * Decompiled with CFR 0.152.
 */
package funstack.client.node;

import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime$;
import cats.implicits$;
import cats.syntax.EitherObjectOps$;
import colibri.Connectable;
import colibri.Connectable$;
import colibri.Observable;
import colibri.Observable$;
import colibri.Observer;
import colibri.Observer$;
import colibri.PublishSubject;
import colibri.Subject$;
import colibri.effect.RunEffect$;
import facade.amazonaws.AWSConfig$;
import facade.amazonaws.services.cognitoidentityprovider.AuthFlowType;
import facade.amazonaws.services.cognitoidentityprovider.AuthFlowType$;
import facade.amazonaws.services.cognitoidentityprovider.CognitoIdentityProvider;
import facade.amazonaws.services.cognitoidentityprovider.InitiateAuthRequest$;
import facade.amazonaws.services.cognitoidentityprovider.InitiateAuthResponse;
import facade.amazonaws.services.cognitoidentityprovider.package;
import funstack.client.core.AuthAppConfig;
import funstack.client.core.auth.AuthRequests;
import funstack.client.core.auth.TokenResponse;
import funstack.client.core.auth.TokenResponse$;
import funstack.client.core.auth.User;
import funstack.client.core.auth.UserInfoResponse;
import funstack.client.core.helper.facades.JwtDecode$;
import funstack.client.node.Auth$paths$;
import funstack.client.node.AuthMethod;
import funstack.client.node.AuthMethod$Empty$;
import funstack.client.node.AuthMethod$Web$;
import funstack.client.node.TokenCredentials;
import funstack.client.node.helper.CallbackHttpServer$;
import funstack.client.node.helper.facades.FS$;
import funstack.client.node.helper.facades.Open$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.scalajs.js.;
import scala.scalajs.js.$bar$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Date$;
import scala.scalajs.js.Dictionary$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.JSON$;
import scala.scalajs.js.UndefOrOps$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005-f\u0001\u0002\u0013&\u00011B\u0001B\u000e\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0005\"B)\u0001\t\u0003\u0011\u0006bB-\u0001\u0005\u0004%IA\u0017\u0005\u0007E\u0002\u0001\u000b\u0011B.\b\u000b\r\u0004\u0001\u0012\u00023\u0007\u000b\u0019\u0004\u0001\u0012B4\t\u000bESA\u0011\u00015\t\u000f%T!\u0019!C\u0001U\"11N\u0003Q\u0001\n\u0005Cq\u0001\u001c\u0006C\u0002\u0013\u0005!\u000e\u0003\u0004n\u0015\u0001\u0006I!\u0011\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019a\b\u0001)A\u0005a\"9Q\u0010\u0001b\u0001\n\u0013q\bbBA\u0003\u0001\u0001\u0006Ia \u0005\n\u0003\u000f\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"!\u000b\u0001A\u0003%\u00111\u0002\u0005\n\u0003W\u0001!\u0019!C\u0005\u0003[A\u0001\"a\u000f\u0001A\u0003%\u0011q\u0006\u0005\u0007\u0003{\u0001A\u0011\u00016\t\r\u0005}\u0002\u0001\"\u0001k\u0011\u0019\t\t\u0005\u0001C\u0001U\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003S\u0002A\u0011AA#\u0011%\tY\u0007\u0001b\u0001\n\u0003\ti\u0007\u0003\u0005\u0002\u0002\u0002\u0001\u000b\u0011BA8\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!a%\u0001\t\u0013\t)\nC\u0004\u0002 \u0002!I!!)\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\n!\u0011)\u001e;i\u0015\t1s%\u0001\u0003o_\u0012,'B\u0001\u0015*\u0003\u0019\u0019G.[3oi*\t!&\u0001\u0005gk:\u001cH/Y2l\u0007\u0001\u00192\u0001A\u00174!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fMB\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0005CV$\bN\u0003\u00029O\u0005!1m\u001c:f\u0013\t!S'F\u0001<!\taT(D\u00018\u0013\tqtGA\u0007BkRD\u0017\t\u001d9D_:4\u0017nZ\u0001\u0006CV$\b\u000eI\u0001\bCB\u0004h*Y7f!\t\u0011\u0015J\u0004\u0002D\u000fB\u0011AiL\u0007\u0002\u000b*\u0011aiK\u0001\u0007yI|w\u000e\u001e \n\u0005!{\u0013A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001S\u0018\u0002\u0019I,G-\u001b:fGR\u0004vN\u001d;\u0011\u00059r\u0015BA(0\u0005\rIe\u000e^\u0001\nC^\u001c(+Z4j_:\fa\u0001P5oSRtD#B*V-^C\u0006C\u0001+\u0001\u001b\u0005)\u0003\"\u0002\u001c\u0007\u0001\u0004Y\u0004\"\u0002!\u0007\u0001\u0004\t\u0005\"\u0002'\u0007\u0001\u0004i\u0005\"\u0002)\u0007\u0001\u0004\t\u0015a\u0003:fI&\u0014Xm\u0019;Ve2,\u0012a\u0017\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000bA\u0001\\1oO*\t\u0001-\u0001\u0003kCZ\f\u0017B\u0001&^\u00031\u0011X\rZ5sK\u000e$XK\u001d7!\u0003\u0015\u0001\u0018\r\u001e5t!\t)'\"D\u0001\u0001\u0005\u0015\u0001\u0018\r\u001e5t'\tQQ\u0006F\u0001e\u0003%\u0019wN\u001c4jO\u0012K'/F\u0001B\u0003)\u0019wN\u001c4jO\u0012K'\u000fI\u0001\u0010GJ,G-\u001a8uS\u0006d7OR5mK\u0006\u00012M]3eK:$\u0018.\u00197t\r&dW\rI\u0001\u001fG><g.\u001b;p\u0013\u0012,g\u000e^5usN+'O^5dKB\u0013xN^5eKJ,\u0012\u0001\u001d\t\u0003cjl\u0011A\u001d\u0006\u0003gR\fqcY8h]&$x.\u001b3f]RLG/\u001f9s_ZLG-\u001a:\u000b\u0005U4\u0018\u0001C:feZL7-Z:\u000b\u0005]D\u0018!C1nCj|g.Y<t\u0015\u0005I\u0018A\u00024bG\u0006$W-\u0003\u0002|e\n92i\\4oSR|\u0017\nZ3oi&$\u0018\u0010\u0015:pm&$WM]\u0001 G><g.\u001b;p\u0013\u0012,g\u000e^5usN+'O^5dKB\u0013xN^5eKJ\u0004\u0013\u0001D1vi\"\u0014V-];fgR\u001cX#A@\u0011\u0007Q\n\t!C\u0002\u0002\u0004U\u0012A\"Q;uQJ+\u0017/^3tiN\fQ\"Y;uQJ+\u0017/^3tiN\u0004\u0013aC5oSRL\u0017\r\\!vi\",\"!a\u0003\u0013\u0011\u00055\u0011\u0011CA\f\u0003;1a!a\u0004\u0001\u0001\u0005-!\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001\u0018\u0002\u0014%\u0019\u0011QC\u0018\u0003\u000fA\u0013x\u000eZ;diB\u0019A+!\u0007\n\u0007\u0005mQE\u0001\u0006BkRDW*\u001a;i_\u0012\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003Gy\u0016AA5p\u0013\u0011\t9#!\t\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0019%t\u0017\u000e^5bY\u0006+H\u000f\u001b\u0011\u0002\u0017\u0005,H\u000f[*vE*,7\r^\u000b\u0003\u0003_\u0001b!!\r\u00028\u0005]QBAA\u001a\u0015\t\t)$A\u0004d_2L'M]5\n\t\u0005e\u00121\u0007\u0002\u000f!V\u0014G.[:i'V\u0014'.Z2u\u00031\tW\u000f\u001e5Tk\nTWm\u0019;!\u0003!awnZ5o+Jd\u0017!C:jO:,\b/\u0016:m\u0003%awnZ8viV\u0013H.\u0001\u0005m_\u001eLgnV3c+\t\t9\u0005\u0005\u0004\u0002J\u0005M\u0013qK\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u00051QM\u001a4fGRT!!!\u0015\u0002\t\r\fGo]\u0005\u0005\u0003+\nYE\u0001\u0002J\u001fB\u0019a&!\u0017\n\u0007\u0005msF\u0001\u0003V]&$\u0018\u0001\u00057pO&t7I]3eK:$\u0018.\u00197t)\u0019\t9%!\u0019\u0002f!1\u00111\r\u000fA\u0002\u0005\u000b\u0001\"^:fe:\fW.\u001a\u0005\u0007\u0003Ob\u0002\u0019A!\u0002\u0011A\f7o]<pe\u0012\fa\u0001\\8h_V$\u0018aC2veJ,g\u000e^+tKJ,\"!a\u001c\u0011\r\u0005E\u0012\u0011OA;\u0013\u0011\t\u0019(a\r\u0003\u0015=\u00137/\u001a:wC\ndW\rE\u0003/\u0003o\nY(C\u0002\u0002z=\u0012aa\u00149uS>t\u0007c\u0001\u001b\u0002~%\u0019\u0011qP\u001b\u0003\tU\u001bXM]\u0001\rGV\u0014(/\u001a8u+N,'\u000fI\u0001\u000fY><\u0017N\u001c+p\u0007><g.\u001b;p)\u0019\t9)a$\u0002\u0012B1\u0011\u0011JA*\u0003\u0013\u00032!]AF\u0013\r\tiI\u001d\u0002\u0015\u0013:LG/[1uK\u0006+H\u000f\u001b*fgB|gn]3\t\r\u0005\r\u0004\u00051\u0001B\u0011\u0019\t9\u0007\ta\u0001\u0003\u00069\"/Z1e\rJ|Wn\u0011:fI\u0016tG/[1mg\u001aKG.\u001a\u000b\u0003\u0003/\u0003RALA<\u00033\u00032\u0001VAN\u0013\r\ti*\n\u0002\u0011)>\\WM\\\"sK\u0012,g\u000e^5bYN\fac\u001e:ji\u0016$vn\u0011:fI\u0016tG/[1mg\u001aKG.\u001a\u000b\u0005\u0003/\n\u0019\u000bC\u0004\u0002&\n\u0002\r!!'\u0002!Q|7.\u001a8De\u0016$WM\u001c;jC2\u001c\u0018!\u00063fY\u0016$Xm\u0011:fI\u0016tG/[1mg\u001aKG.\u001a\u000b\u0003\u0003/\u0002")
public class Auth
implements funstack.client.core.auth.Auth {
    private volatile Auth$paths$ paths$module;
    private final AuthAppConfig auth;
    public final String funstack$client$node$Auth$$appName;
    private final int redirectPort;
    private final String redirectUrl;
    private final CognitoIdentityProvider cognitoIdentityServiceProvider;
    private final AuthRequests authRequests;
    private final Product initialAuth;
    private final PublishSubject<AuthMethod> authSubject;
    private final Observable<Option<User>> currentUser;

    private Auth$paths$ paths() {
        if (this.paths$module == null) {
            this.paths$lzycompute$1();
        }
        return this.paths$module;
    }

    public AuthAppConfig auth() {
        return this.auth;
    }

    private String redirectUrl() {
        return this.redirectUrl;
    }

    private CognitoIdentityProvider cognitoIdentityServiceProvider() {
        return this.cognitoIdentityServiceProvider;
    }

    private AuthRequests authRequests() {
        return this.authRequests;
    }

    private Product initialAuth() {
        return this.initialAuth;
    }

    private PublishSubject<AuthMethod> authSubject() {
        return this.authSubject;
    }

    public String loginUrl() {
        return this.authRequests().loginUrl();
    }

    public String signupUrl() {
        return this.authRequests().signupUrl();
    }

    public String logoutUrl() {
        return this.authRequests().logoutUrl();
    }

    public IO<BoxedUnit> loginWeb() {
        return Observer.Operations$.MODULE$.onNextIO$extension(Observer$.MODULE$.Operations(this.authSubject()), (Object)AuthMethod$Web$.MODULE$);
    }

    public IO<BoxedUnit> loginCredentials(String username, String password) {
        return Observer.Operations$.MODULE$.onNextIO$extension(Observer$.MODULE$.Operations(this.authSubject()), (Object)new AuthMethod.Credentials(username, password));
    }

    public IO<BoxedUnit> logout() {
        return Observer.Operations$.MODULE$.onNextIO$extension(Observer$.MODULE$.Operations(this.authSubject()), (Object)AuthMethod$Empty$.MODULE$);
    }

    public Observable<Option<User>> currentUser() {
        return this.currentUser;
    }

    private IO<InitiateAuthResponse> loginToCognito(String username, String password) {
        return IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            AuthFlowType x$1 = AuthFlowType$.MODULE$.USER_PASSWORD_AUTH();
            String x$2 = this.auth().clientId();
            .bar x$3 = $bar$.MODULE$.from((Object)Dictionary$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"USERNAME", (Object)username), new Tuple2((Object)"PASSWORD", (Object)password)})), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
            .bar x$4 = InitiateAuthRequest$.MODULE$.apply$default$3();
            .bar x$5 = InitiateAuthRequest$.MODULE$.apply$default$5();
            .bar x$6 = InitiateAuthRequest$.MODULE$.apply$default$6();
            return package.CognitoIdentityProviderOps$.MODULE$.initiateAuthFuture$extension(facade.amazonaws.services.cognitoidentityprovider.package$.MODULE$.CognitoIdentityProviderOps(this.cognitoIdentityServiceProvider()), InitiateAuthRequest$.MODULE$.apply(x$1, x$2, x$4, x$3, x$5, x$6));
        }));
    }

    private Option<TokenCredentials> readFromCredentialsFile() {
        if (FS$.MODULE$.existsSync(this.paths().credentialsFile())) {
            Either result = EitherObjectOps$.MODULE$.catchNonFatal$extension(implicits$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), (Function0 & Serializable)() -> FS$.MODULE$.readFileSync(this.paths().credentialsFile())).flatMap((Function1 & Serializable)buffer -> {
                String json = buffer.toString("utf-8");
                return EitherObjectOps$.MODULE$.catchNonFatal$extension(implicits$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), (Function0 & Serializable)() -> JSON$.MODULE$.parse(json, JSON$.MODULE$.parse$default$2()));
            });
            Either either = result;
            if (either instanceof Right) {
                Right right = (Right)either;
                Dynamic value = (Dynamic)right.value();
                return new Some((Object)new TokenCredentials(BoxesRunTime.unboxToDouble((Object)value.selectDynamic("time")), (TokenResponse)value.selectDynamic("token")));
            }
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable err = (Throwable)left.value();
                Predef$.MODULE$.println((Object)new StringBuilder(43).append("Unexpected error reading credentials file: ").append(err).toString());
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }
        return None$.MODULE$;
    }

    private void writeToCredentialsFile(TokenCredentials tokenCredentials) {
        if (!FS$.MODULE$.existsSync(this.paths().configDir())) {
            FS$.MODULE$.mkdirSync(this.paths().configDir());
        }
        FS$.MODULE$.writeFileSync(this.paths().credentialsFile(), JSON$.MODULE$.stringify((Any)Dynamic.literal$.MODULE$.applyDynamicNamed("apply", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"time", (Object)Any$.MODULE$.fromDouble(tokenCredentials.time())), new Tuple2((Object)"token", (Object)tokenCredentials.token())})), JSON$.MODULE$.stringify$default$2(), JSON$.MODULE$.stringify$default$3()));
    }

    private void deleteCredentialsFile() {
        if (FS$.MODULE$.existsSync(this.paths().credentialsFile())) {
            FS$.MODULE$.rmSync(this.paths().credentialsFile());
            return;
        }
    }

    private final void paths$lzycompute$1() {
        Auth auth = this;
        synchronized (auth) {
            if (this.paths$module == null) {
                this.paths$module = new Auth$paths$(this);
            }
        }
    }

    public Auth(AuthAppConfig auth, String appName, int redirectPort, String awsRegion) {
        Product product;
        this.auth = auth;
        this.funstack$client$node$Auth$$appName = appName;
        this.redirectPort = redirectPort;
        this.redirectUrl = new StringBuilder(17).append("http://localhost:").append(redirectPort).toString();
        .bar x$1 = $bar$.MODULE$.from((Object)awsRegion, .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        .bar x$2 = AWSConfig$.MODULE$.apply$default$1();
        .bar x$3 = AWSConfig$.MODULE$.apply$default$2();
        .bar x$4 = AWSConfig$.MODULE$.apply$default$3();
        .bar x$5 = AWSConfig$.MODULE$.apply$default$4();
        .bar x$6 = AWSConfig$.MODULE$.apply$default$5();
        .bar x$7 = AWSConfig$.MODULE$.apply$default$6();
        .bar x$8 = AWSConfig$.MODULE$.apply$default$7();
        .bar x$9 = AWSConfig$.MODULE$.apply$default$8();
        .bar x$10 = AWSConfig$.MODULE$.apply$default$9();
        .bar x$11 = AWSConfig$.MODULE$.apply$default$10();
        .bar x$12 = AWSConfig$.MODULE$.apply$default$11();
        .bar x$13 = AWSConfig$.MODULE$.apply$default$12();
        .bar x$14 = AWSConfig$.MODULE$.apply$default$13();
        .bar x$15 = AWSConfig$.MODULE$.apply$default$14();
        .bar x$16 = AWSConfig$.MODULE$.apply$default$16();
        .bar x$17 = AWSConfig$.MODULE$.apply$default$17();
        .bar x$18 = AWSConfig$.MODULE$.apply$default$18();
        .bar x$19 = AWSConfig$.MODULE$.apply$default$19();
        .bar x$20 = AWSConfig$.MODULE$.apply$default$20();
        .bar x$21 = AWSConfig$.MODULE$.apply$default$21();
        .bar x$22 = AWSConfig$.MODULE$.apply$default$22();
        .bar x$23 = AWSConfig$.MODULE$.apply$default$23();
        .bar x$24 = AWSConfig$.MODULE$.apply$default$24();
        .bar x$25 = AWSConfig$.MODULE$.apply$default$25();
        .bar x$26 = AWSConfig$.MODULE$.apply$default$26();
        .bar x$27 = AWSConfig$.MODULE$.apply$default$27();
        .bar x$28 = AWSConfig$.MODULE$.apply$default$28();
        .bar x$29 = AWSConfig$.MODULE$.apply$default$29();
        .bar x$30 = AWSConfig$.MODULE$.apply$default$30();
        .bar x$31 = AWSConfig$.MODULE$.apply$default$31();
        .bar x$32 = AWSConfig$.MODULE$.apply$default$32();
        this.cognitoIdentityServiceProvider = new CognitoIdentityProvider(AWSConfig$.MODULE$.apply(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$1, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32));
        this.authRequests = new AuthRequests(auth, this.redirectUrl());
        Option<TokenCredentials> option = this.readFromCredentialsFile();
        if (option instanceof Some) {
            Some some = (Some)option;
            TokenCredentials tokenCredentials = (TokenCredentials)some.value();
            product = new AuthMethod.Token(tokenCredentials);
        } else if (None$.MODULE$.equals(option)) {
            product = AuthMethod$Empty$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        this.initialAuth = product;
        this.authSubject = Subject$.MODULE$.publish();
        this.currentUser = Observable.Operations$.MODULE$.recover$extension(Observable$.MODULE$.Operations((Observable)Connectable.ConnectableObservableMaybeValueOperations$.MODULE$.hot$extension(Connectable$.MODULE$.ConnectableObservableMaybeValueOperations(Observable.Operations$.MODULE$.replayLatest$extension(Observable$.MODULE$.Operations((Observable)implicits$.MODULE$.toFunctorOps((Object)Observable.Operations$.MODULE$.switchMap$extension(Observable$.MODULE$.Operations(Observable.Operations$.MODULE$.prepend$extension(Observable$.MODULE$.Operations(this.authSubject()), (Object)this.initialAuth())), (Function1 & Serializable)x0$1 -> {
            AuthMethod authMethod = x0$1;
            if (AuthMethod$Empty$.MODULE$.equals(authMethod)) {
                return Observable$.MODULE$.pure((Object)None$.MODULE$);
            }
            if (authMethod instanceof AuthMethod.Token) {
                AuthMethod.Token token = (AuthMethod.Token)authMethod;
                TokenCredentials tokenCredentials = token.tokenCredentials();
                return Observable$.MODULE$.pure((Object)new Some((Object)tokenCredentials));
            }
            if (AuthMethod$Web$.MODULE$.equals(authMethod)) {
                return (Observable)implicits$.MODULE$.toFunctorOps((Object)Observable$.MODULE$.fromEffect((Object)IO$.MODULE$.println((Object)this.loginUrl(), implicits$.MODULE$.catsStdShowForString()).$times$greater(IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Open$.MODULE$.apply(this.loginUrl()))).$times$greater(CallbackHttpServer$.MODULE$.authCode($this.redirectPort).flatMap((Function1 & Serializable)authCode -> this.authRequests().getTokenFromAuthCode(authCode))), RunEffect$.MODULE$.IORunEffect()), (Functor)Observable.catsInstances$.MODULE$).map((Function1 & Serializable)result -> new Some((Object)new TokenCredentials(Date$.MODULE$.now(), (TokenResponse)result)));
            }
            if (authMethod instanceof AuthMethod.Credentials) {
                AuthMethod.Credentials credentials = (AuthMethod.Credentials)authMethod;
                String username = credentials.username();
                String password = credentials.password();
                return (Observable)implicits$.MODULE$.toFunctorOps((Object)Observable$.MODULE$.fromEffect(this.loginToCognito(username, password), RunEffect$.MODULE$.IORunEffect()), (Functor)Observable.catsInstances$.MODULE$).map((Function1 & Serializable)x$1 -> UndefOrOps$.MODULE$.toOption$extension($bar$.MODULE$.undefOr2ops(x$1.AuthenticationResult())).map((Function1 & Serializable)result -> new TokenCredentials(Date$.MODULE$.now(), TokenResponse$.MODULE$.apply((String)UndefOrOps$.MODULE$.get$extension($bar$.MODULE$.undefOr2ops(result.IdToken())), (String)UndefOrOps$.MODULE$.get$extension($bar$.MODULE$.undefOr2ops(result.RefreshToken())), (String)UndefOrOps$.MODULE$.get$extension($bar$.MODULE$.undefOr2ops(result.AccessToken())), (double)BoxesRunTime.unboxToInt((Object)UndefOrOps$.MODULE$.get$extension($bar$.MODULE$.undefOr2ops(result.ExpiresIn()))), (String)UndefOrOps$.MODULE$.get$extension($bar$.MODULE$.undefOr2ops(result.TokenType()))))));
            }
            throw new MatchError((Object)authMethod);
        }), (Functor)Observable.catsInstances$.MODULE$).map((Function1 & Serializable)x0$2 -> {
            Option option = x0$2;
            if (None$.MODULE$.equals(option)) {
                this.deleteCredentialsFile();
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                TokenCredentials initialToken = (TokenCredentials)some.value();
                UserInfoResponse userInfo = (UserInfoResponse)JwtDecode$.MODULE$.apply(initialToken.token().id_token());
                this.writeToCredentialsFile(initialToken);
                ObjectRef currentToken = ObjectRef.create((Object)Future$.MODULE$.successful((Object)initialToken));
                IO tokenGetter = IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    currentToken$1.elem = ((Future)currentToken$1.elem).flatMap((Function1 & Serializable)current -> {
                        boolean canUse;
                        double timeDiffSecs = (Date$.MODULE$.now() - current.time()) / (double)1000;
                        boolean bl = canUse = timeDiffSecs < current.token().expires_in() * 0.8;
                        if (canUse) {
                            return Future$.MODULE$.successful(current);
                        }
                        return this.authRequests().getTokenFromRefreshToken(current.token().refresh_token()).map((Function1 & Serializable)response -> {
                            TokenCredentials tokenCredentials = new TokenCredentials(Date$.MODULE$.now(), (TokenResponse)response);
                            this.writeToCredentialsFile(tokenCredentials);
                            return tokenCredentials;
                        }).unsafeToFuture(IORuntime$.MODULE$.global());
                    }, IORuntime$.MODULE$.global().compute());
                    return (Future)currentToken$1.elem;
                })).map((Function1 & Serializable)x$2 -> x$2.token());
                return new Some((Object)new User(userInfo, tokenGetter));
            }
            throw new MatchError((Object)option);
        })))))), (PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Predef$.MODULE$.println((Object)new StringBuilder(24).append("Error in user handling: ").append(A1).toString());
                return (B1)None$.MODULE$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        });
    }
}

