/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.bean.factories.definition.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.brijframework.bean.definition.BeanDefinationConstructor;
import org.brijframework.bean.definition.BeanDefinition;
import org.brijframework.bean.definition.impl.BeanDefinationConstructorImpl;
import org.brijframework.bean.definition.impl.BeanDefinitionImpl;
import org.brijframework.bean.factories.definition.BeanDefinitionFactory;
import org.brijframework.bean.factories.resource.impl.BeanResourceFactoryImpl;
import org.brijframework.bean.resource.BeanResource;
import org.brijframework.bean.resource.BeanResourceConstructor;
import org.brijframework.bean.resource.BeanResourceParam;
import org.brijframework.factories.impl.AbstractFactory;
import org.brijframework.group.Group;
import org.brijframework.model.diffination.ModelParameterDiffination;
import org.brijframework.model.diffination.ModelTypeDeffination;
import org.brijframework.model.factories.deffination.impl.DefaultTypeModelDeffinationFactory;
import org.brijframework.support.enums.Scope;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.printer.LoggerConsole;

public abstract class AbstractBeanDefinitionFactory
extends AbstractFactory<String, BeanDefinition>
implements BeanDefinitionFactory<String, BeanDefinition> {
    public boolean contains(String id) {
        return BeanResourceFactoryImpl.getFactory().find(id) != null;
    }

    public void register(String id, BeanResource beanResource) {
        ModelTypeDeffination owner = null;
        if (beanResource.getModel() != null && !beanResource.getModel().isEmpty()) {
            owner = DefaultTypeModelDeffinationFactory.getFactory().findById((Object)beanResource.getModel());
            if (owner == null) {
                owner = DefaultTypeModelDeffinationFactory.getFactory().findOrCreate((Object)beanResource.getModel());
            }
        } else {
            owner = DefaultTypeModelDeffinationFactory.getFactory().register(beanResource.getType());
        }
        Assertion.notNull((Object)owner, (String)("Model not found for " + beanResource.getModel() + " of bean  : " + id));
        id = "DEFAULT".equals(beanResource.getId()) ? owner.getType().getSimpleName() : beanResource.getId();
        BeanDefinitionImpl beanDefinition = new BeanDefinitionImpl(owner);
        beanDefinition.setId(id);
        beanDefinition.setName(beanResource.getName());
        beanDefinition.setScope(Scope.valueFor((String)beanResource.getScope(), (Scope)Scope.SINGLETON));
        beanDefinition.setFactoryClass("DEFAULT".equals(beanResource.getFactoryClass()) ? null : beanResource.getFactoryClass());
        beanDefinition.setFactoryMethod("DEFAULT".equals(beanResource.getFactoryMethod()) ? null : beanResource.getFactoryMethod());
        beanDefinition.setConstructor(this.buildConstructor(owner, beanResource.getConstructor()));
        beanDefinition.setProperties(beanResource.getProperties());
        this.register(id, beanDefinition);
    }

    private BeanDefinationConstructor buildConstructor(ModelTypeDeffination owner, BeanResourceConstructor resourceConstructor) {
        BeanDefinationConstructorImpl definationConstructor = new BeanDefinationConstructorImpl();
        if (resourceConstructor != null) {
            definationConstructor.setId(resourceConstructor.getId());
            definationConstructor.setModel(resourceConstructor.getModel());
            definationConstructor.setName(resourceConstructor.getName());
            Object[] values = new Object[resourceConstructor.getParameters().size()];
            for (BeanResourceParam beanResourceParam : resourceConstructor.getParameters()) {
                values[beanResourceParam.getIndex()] = beanResourceParam.getValue();
            }
            definationConstructor.setValues(values);
        } else {
            definationConstructor.setId(owner.getConstructor().getId());
            definationConstructor.setModel(owner.getId());
            definationConstructor.setName(owner.getConstructor().getName());
            Object[] values = new Object[owner.getConstructor().getParameters().size()];
            for (ModelParameterDiffination beanResourceParam : owner.getConstructor().getParameters()) {
                values[beanResourceParam.getIndex()] = null;
            }
            definationConstructor.setValues(values);
        }
        return definationConstructor;
    }

    public void register(Class<?> target, BeanResource beanResource) {
        String id = "DEFAULT".equals(beanResource.getId()) ? target.getSimpleName() : beanResource.getId();
        ModelTypeDeffination owner = DefaultTypeModelDeffinationFactory.getFactory().findById((Object)beanResource.getModel());
        Assertion.notNull((Object)owner, (String)("Model not found for " + beanResource.getModel() + " of bean  : " + id));
        BeanDefinitionImpl dataSetup = new BeanDefinitionImpl(owner);
        dataSetup.setId(id);
        dataSetup.setName(beanResource.getName());
        dataSetup.setScope(Scope.valueFor((String)beanResource.getScope()));
        dataSetup.setProperties(beanResource.getProperties());
        this.register(id, dataSetup);
    }

    public List<String> getBeanNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : this.getCache().entrySet()) {
            list.add((String)entry.getKey());
        }
        return list;
    }

    public List<String> getBeanNames(Class<?> beanClass) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : this.getCache().entrySet()) {
            if (!beanClass.isAssignableFrom(((BeanDefinition)entry.getValue()).getOwner().getType())) continue;
            list.add((String)entry.getKey());
        }
        return list;
    }

    public AbstractBeanDefinitionFactory clear() {
        this.getCache().clear();
        return this;
    }

    @Override
    public List<BeanDefinition> findAll(Class<?> cls) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        for (BeanDefinition definition : this.getCache().values()) {
            if (!cls.isAssignableFrom(definition.getOwner().getType())) continue;
            list.add(definition);
        }
        return list;
    }

    public BeanDefinition register(String key, BeanDefinition value) {
        this.preregister(key, value);
        this.loadContainer(key, value);
        this.getCache().put(key, value);
        this.postregister(key, value);
        return value;
    }

    public void loadContainer(String key, BeanDefinition value) {
        if (this.getContainer() == null) {
            return;
        }
        Group group = this.getContainer().load((Object)value.getOwner().getName());
        if (!group.containsKey((Object)key)) {
            group.add((Object)key, (Object)value);
        } else {
            group.update((Object)key, (Object)value);
        }
    }

    @Override
    public List<BeanDefinition> findAllByModel(String model) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        for (BeanDefinition setup : this.getCache().values()) {
            if (!setup.getOwner().getId().equals(model)) continue;
            list.add(setup);
        }
        return list;
    }

    public BeanDefinition find(String modelKey) {
        BeanDefinition beanMetaData = (BeanDefinition)this.getCache().get(modelKey);
        if (beanMetaData != null) {
            return beanMetaData;
        }
        return this.getContainer(modelKey);
    }

    public BeanDefinition getContainer(String modelKey) {
        if (this.getContainer() == null) {
            return null;
        }
        return (BeanDefinition)this.getContainer().find((Object)modelKey);
    }

    protected void preregister(String key, BeanDefinition value) {
        LoggerConsole.screen((String)"BeanDefinition", (String)("Registering for bean data with id :" + value.getId()));
    }

    protected void postregister(String key, BeanDefinition value) {
        LoggerConsole.screen((String)"BeanDefinition", (String)("Registered for bean data with id :" + value.getId()));
    }
}

