/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.resources.container.impl;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.brijframework.container.impl.module.AbstractModuleContainer;
import org.brijframework.group.Group;
import org.brijframework.resources.container.ResourceContainer;
import org.brijframework.resources.factory.file.FileResourceFactory;
import org.brijframework.resources.group.FileResourceGroup;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.factories.ReflectionFactory;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.resouces.ResourcesUtil;
import org.brijframework.util.text.StringUtil;

public class FileResourceContainer
extends AbstractModuleContainer
implements ResourceContainer {
    public static final String MANIFEST_MF = "MANIFEST.MF";
    public static final String POM_PROPERTIES = "pom.properties";
    public static final String POM_XML = "pom.xml";
    public static final String META_INF = "META-INF";
    public static final String All_INF = "";
    public static final String COM_INF = "comman";
    private static FileResourceContainer container;

    @SingletonFactory
    public static FileResourceContainer getContainer() {
        if (container == null) {
            container = (FileResourceContainer)InstanceUtil.getSingletonInstance(FileResourceContainer.class, (Object[])new Object[0]);
        }
        return container;
    }

    public void init() {
        try {
            ReflectionFactory.getFactory().getExternalClassList().forEach(cls -> {
                if (FileResourceFactory.class.isAssignableFrom((Class<?>)cls) && InstanceUtil.isAssignable((Class)cls)) {
                    this.register((Class)cls);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ReflectionFactory.getFactory().getInternalClassList().forEach(cls -> {
                if (FileResourceFactory.class.isAssignableFrom((Class<?>)cls) && InstanceUtil.isAssignable((Class)cls)) {
                    this.register((Class)cls);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, File> fileMapping(File file) throws URISyntaxException {
        LinkedHashMap<String, File> mapping = new LinkedHashMap<String, File>();
        String pathKey = All_INF;
        String[] pathList = StringUtil.getOfter((String)file.getAbsolutePath(), (String)META_INF).split("/");
        for (int i = 0; i < pathList.length; ++i) {
            if (!pathKey.isEmpty()) {
                pathKey = pathKey + "/";
            }
            pathKey = pathKey + pathList[i];
            URL url = ResourcesUtil.getResource((String)(META_INF + pathKey));
            Assertion.notNull((Object)url, (String)"this is required . it must not be null or empty");
            mapping.put(pathKey, new File(url.toURI()));
        }
        return mapping;
    }

    public boolean isIgnoreFile(File file) {
        return MANIFEST_MF.equalsIgnoreCase(file.getName()) || POM_PROPERTIES.equalsIgnoreCase(file.getName()) || POM_XML.equalsIgnoreCase(file.getName());
    }

    public Group load(Object groupKey) {
        Object group = (Group)this.getCache().get(groupKey);
        if (group == null) {
            group = new FileResourceGroup((String)groupKey);
        }
        return group;
    }
}

