/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.objects;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.casting.CastingUtil;
import org.brijframework.util.reflect.ClassUtil;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.reflect.LogicUnit;
import org.brijframework.util.resouces.FileUtil;
import org.brijframework.util.text.StringUtil;

public abstract class ObjectUtil {
    private static final Object[] emptyArray = new Object[0];
    private static final List<?> emptyList = new ArrayList();

    public static void swapArray(Object[] array, int index1, int index2) {
        Object temp = array[index1];
        array[index1] = array[index2];
        array[index2] = temp;
    }

    public static void reverseArray(Object[] array) {
        int i = array.length - 1;
        int j = 0;
        while (i > array.length / 2) {
            ObjectUtil.swapArray(array, i, j);
            --i;
            ++j;
        }
    }

    public static void sortArray(Object[] array, boolean isDesc) {
        for (int i = 0; i < array.length; ++i) {
            for (int j = 1; j < array.length; ++j) {
                ObjectUtil.swapArray(array, i, j);
            }
        }
    }

    public static Object[] removeElement(Object[] array, String property, String val) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (length >= array.length) continue;
            Object[] array1 = new Object[length];
            System.arraycopy(array, 0, array1, 0, length);
            return array1;
        }
        return array;
    }

    public static Object[] removeElement(Object[] array, Object element) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (element != array[i]) continue;
            for (int j = i; j < length - 1; ++j) {
                array[j] = array[j + 1];
            }
            --length;
        }
        if (length < array.length) {
            Object[] array1 = new Object[length];
            System.arraycopy(array, 0, array1, 0, length);
            return array1;
        }
        return array;
    }

    public static void swapIntArray(int[] array, int index1, int index2) {
        array[index1] = array[index1] ^ array[index2];
        array[index2] = array[index1] ^ array[index2];
        array[index1] = array[index2] ^ array[index1];
    }

    public static void reverseIntArray(int[] array) {
        int i = array.length - 1;
        int j = 0;
        while (i > array.length / 2) {
            ObjectUtil.swapIntArray(array, i, j);
            --i;
            ++j;
        }
    }

    public static Number max(Number[] array) {
        List<Number> list = Arrays.asList(array);
        Collections.sort(list);
        return (Integer)list.get(array.length - 1);
    }

    public static Number min(Number[] array) {
        List<Number> list = Arrays.asList(array);
        Collections.sort(list);
        return (Integer)list.get(0);
    }

    public static Number[] removeElement(Number[] array, Number element) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (element != array[i]) continue;
            for (int j = i; j < length - 1; ++j) {
                array[j] = array[j + 1];
            }
            --length;
        }
        if (length < array.length) {
            Number[] array1 = new Number[length];
            System.arraycopy(array, 0, array1, 0, length);
            return array1;
        }
        return array;
    }

    public static void sortIntegerArray(int[] array) {
        for (int i = array.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (array[j] <= array[j + 1]) continue;
                ObjectUtil.swapIntArray(array, j, j + 1);
            }
        }
    }

    public static String[] dynArray(int size, String[] array) {
        int counter = 0;
        String temp = "";
        if (size == array.length) {
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].matches("[a-zA-z\\s]")) continue;
                --size;
                temp = array[i];
                if (array[counter].equalsIgnoreCase(array[i])) continue;
                array[i] = array[counter];
                array[counter] = temp;
                ++counter;
            }
            String[] tmpArray = new String[size];
            System.arraycopy(array, counter, tmpArray, 0, size);
            return tmpArray;
        }
        return null;
    }

    public static boolean contains(Object[] _array, Object _object) {
        if (_array == null || _array.length == 0) {
            return false;
        }
        for (int i = 0; i < _array.length; ++i) {
            if (_object == _array[i]) {
                return true;
            }
            if (_object == null || !_object.equals(_array[i])) continue;
            return true;
        }
        return false;
    }

    public static int lastIndexOfObjectIdenticalTo(Object[] _array, Object _object) {
        if (_array == null || _array.length == 0) {
            return -1;
        }
        for (int i = _array.length - 1; i >= 0; --i) {
            if (_array[i] != _object) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfObjectEqualTo(Object[] _array, Object _object) {
        if (_array == null || _array.length == 0) {
            return -1;
        }
        for (int i = _array.length - 1; i >= 0; --i) {
            if (_array[i] == _object) {
                return i;
            }
            if (_object == null || _array[i] == null || !_array[i].equals(_object)) continue;
            return i;
        }
        return -1;
    }

    public static List<?> batchToList(List<?> _list, int _batchSize) {
        if (_list == null) {
            return emptyList;
        }
        int len = _list.size();
        if (_batchSize >= len || _batchSize < 1) {
            ArrayList batches = new ArrayList(1);
            batches.add(new ArrayList(_list));
            return batches;
        }
        int batchCount = len / _batchSize;
        if (len % _batchSize != 0) {
            ++batchCount;
        }
        ArrayList batches = new ArrayList(batchCount);
        ArrayList batch = new ArrayList(_batchSize);
        batches.add(batch);
        int fillSize = 0;
        for (int i = 0; i < len; ++i) {
            if (fillSize == _batchSize) {
                batch = new ArrayList(_batchSize);
                batches.add(batch);
                fillSize = 0;
            }
            batch.add(_list.get(i));
            ++fillSize;
        }
        return batches;
    }

    public static List batchToList(Object[] _array, int _batchSize) {
        if (_array == null) {
            return emptyList;
        }
        int len = _array.length;
        if (_batchSize >= len || _batchSize < 1) {
            ArrayList batches = new ArrayList(1);
            batches.add(ObjectUtil.asList(_array));
            return batches;
        }
        int batchCount = len / _batchSize;
        if (len % _batchSize != 0) {
            ++batchCount;
        }
        ArrayList batches = new ArrayList(batchCount);
        ArrayList<Object> batch = new ArrayList<Object>(_batchSize);
        batches.add(batch);
        int fillSize = 0;
        for (int i = 0; i < len; ++i) {
            if (fillSize == _batchSize) {
                batch = new ArrayList(_batchSize);
                batches.add(batch);
                fillSize = 0;
            }
            batch.add(_array[i]);
            ++fillSize;
        }
        return batches;
    }

    public static <T> List<T> getPropertyValue(Collection<?> _objects, String _key) {
        if (_objects == null) {
            return emptyList;
        }
        int len = _objects.size();
        if (len == 0) {
            return emptyList;
        }
        ArrayList values = new ArrayList(len);
        for (Object o : _objects) {
            if (o != null) {
                o = o instanceof Map ? ((Map)o).get(_key) : LogicUnit.getField(o, _key);
            }
            if (values.contains(o)) continue;
            values.add(o);
        }
        return values;
    }

    public static <T> List<T> getPropertyValue(List<Object> _objects, String _path) {
        if (_objects == null) {
            return emptyList;
        }
        int len = _objects.size();
        if (len == 0) {
            return emptyList;
        }
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            Object o = _objects.get(i);
            if (o != null) {
                o = LogicUnit.getField(o, _path);
            }
            if (values.contains(o)) continue;
            values.add(o);
        }
        return values;
    }

    public static Object[] valuesForKey(Object[] _objects, String _key) {
        if (_objects == null) {
            return emptyArray;
        }
        int len = _objects.length;
        if (len == 0) {
            return emptyArray;
        }
        Object[] values = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object o = _objects[i];
            if (o != null) {
                o = o instanceof Map ? ((Map)o).get(_key) : LogicUnit.getField(o, _key);
            }
            values[i] = o;
        }
        return values;
    }

    public static Object[] getPropertyValue(Object[] _objects, String _path) {
        if (_objects == null) {
            return emptyArray;
        }
        int len = _objects.length;
        if (len == 0) {
            return emptyArray;
        }
        Object[] values = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object o = _objects[i];
            if (o != null) {
                o = LogicUnit.getField(o, _path);
            }
            values[i] = o;
        }
        return values;
    }

    public static HashMap<Object, List<Object>> groupByKeyPath(Collection<?> _objects, String _keyPath) {
        if (_objects == null) {
            return null;
        }
        HashMap<Object, List<Object>> resultMap = new HashMap<Object, List<Object>>(16);
        for (Object object : _objects) {
            Object group = LogicUnit.getField(object, _keyPath);
            List<Object> groupValues = resultMap.get(group);
            if (groupValues == null) {
                groupValues = new ArrayList<Object>(4);
                resultMap.put(group, groupValues);
            }
            groupValues.add(object);
        }
        return resultMap;
    }

    public static HashMap<Object, List<Object>> groupByKey(Collection<?> _objects, String _key) {
        return ObjectUtil.groupByKeyPath(_objects, _key);
    }

    public static Map groupByKeyPathes(Collection _objects, String[] _keyPathes) {
        int keyPathCount;
        int n = keyPathCount = _keyPathes != null ? _keyPathes.length : 0;
        if (_objects == null || keyPathCount == 0) {
            return null;
        }
        if (keyPathCount == 1) {
            return ObjectUtil.groupByKeyPath(_objects, _keyPathes[0]);
        }
        HashMap resultMap = new HashMap(16);
        for (Object object : _objects) {
            Object group;
            HashMap groupCursor = resultMap;
            for (int i = 1; i < keyPathCount; ++i) {
                group = LogicUnit.getField(object, _keyPathes[i - 1]);
                HashMap groupContent = (HashMap)groupCursor.get(group);
                if (groupContent == null) {
                    groupContent = new HashMap(16);
                    groupCursor.put(group, groupContent);
                }
                groupCursor = groupContent;
            }
            group = LogicUnit.getField(object, _keyPathes[keyPathCount - 1]);
            ArrayList groupValues = (ArrayList)groupCursor.get(group);
            if (groupValues == null) {
                groupValues = new ArrayList(4);
                groupCursor.put(group, groupValues);
            }
            groupValues.add(object);
        }
        return resultMap;
    }

    public static HashMap extractRecordFromArray(Object[] _array, Object[] _keys, int[] _keyIndices, Format[] _keyFormats, boolean _excludeNulls) {
        if (_array == null) {
            return null;
        }
        if (_keys == null) {
            _keys = ObjectUtil.listForCount(_array.length).toArray();
        }
        int count = _keys.length;
        HashMap<Object, Object> map = new HashMap<Object, Object>(count);
        for (int i = 0; i < count; ++i) {
            Object value;
            Object key = _keys[i];
            if (_keyIndices != null) {
                int idx = i < _keyIndices.length ? _keyIndices[i] : -1;
                value = i >= 0 && i < _array.length ? _array[idx] : null;
            } else {
                Object object = value = i < _array.length ? (value = _array[i]) : null;
            }
            if (_keyFormats != null && _keyFormats.length > i) {
                try {
                    value = _keyFormats[i].parseObject(value.toString());
                }
                catch (ParseException e) {
                    value = e;
                }
            }
            if (value == null && _excludeNulls) continue;
            map.put(key, value);
        }
        return map;
    }

    public static List<Map> extractRecordsFromArrays(Object[][] _array, Object[] _keys, int[] _keyIndices, Format[] _keyFormats, boolean _excludeNulls) {
        if (_array == null) {
            return null;
        }
        ArrayList<Map> list = new ArrayList<Map>(_array.length);
        for (Object[] recordArray : _array) {
            list.add(ObjectUtil.extractRecordFromArray(recordArray, _keys, _keyIndices, _keyFormats, _excludeNulls));
        }
        return list;
    }

    public static List<?> asList(Object _array) {
        if (_array == null) {
            return null;
        }
        if (_array instanceof List) {
            return (List)_array;
        }
        if (_array instanceof Collection) {
            return new ArrayList((Collection)_array);
        }
        Class<?> itemClazz = _array.getClass().getComponentType();
        if (itemClazz == null) {
            ArrayList<Object> al = new ArrayList<Object>(1);
            al.add(_array);
            return al;
        }
        if (itemClazz == Integer.TYPE) {
            int[] nums = (int[])_array;
            ArrayList<Integer> al = new ArrayList<Integer>(nums.length);
            for (int i = 0; i < nums.length; ++i) {
                al.add(nums[i]);
            }
            return al;
        }
        if (itemClazz == Long.TYPE) {
            long[] nums = (long[])_array;
            ArrayList<Long> al = new ArrayList<Long>(nums.length);
            for (int i = 0; i < nums.length; ++i) {
                al.add(nums[i]);
            }
            return al;
        }
        return ObjectUtil.asList(_array);
    }

    public static <T> T[] arrayByAppending(T[] _array, T _element) {
        return ObjectUtil.arrayByAppending(_array, _element, false);
    }

    public static <T> T[] arrayByAppending(T[] _array, T _element, boolean createGenericArray) {
        Object[] extendedArray;
        if (_array == null) {
            if (_element == null) {
                return null;
            }
            extendedArray = (Object[])Array.newInstance(createGenericArray ? Object.class : _element.getClass(), 1);
        } else {
            Class<?> componentType = _array.getClass().getComponentType();
            extendedArray = (Object[])Array.newInstance(componentType, _array.length + 1);
            System.arraycopy(_array, 0, extendedArray, 0, _array.length);
        }
        extendedArray[extendedArray.length - 1] = _element;
        return extendedArray;
    }

    public static <T> T[] arrayByRemovingFirst(T[] _array) {
        if (_array == null) {
            return null;
        }
        Class<?> componentType = _array.getClass().getComponentType();
        Object[] extendedArray = (Object[])Array.newInstance(componentType, _array.length - 1);
        System.arraycopy(_array, 1, extendedArray, 0, extendedArray.length);
        return extendedArray;
    }

    public static int[] intValuesForObjects(Object[] _values) {
        if (_values == null) {
            return null;
        }
        int count = _values.length;
        int[] nums = new int[count];
        for (int i = 0; i < count; ++i) {
            Object v = _values[i];
            if (v instanceof Number) {
                nums[i] = ((Number)v).intValue();
                continue;
            }
            if (v instanceof String) {
                if (((String)v).length() == 0) {
                    nums[i] = 0;
                    continue;
                }
                try {
                    nums[i] = Integer.parseInt((String)v);
                }
                catch (NumberFormatException e) {
                    nums[i] = 0;
                }
                continue;
            }
            nums[i] = CastingUtil.intValue(v.toString());
        }
        return nums;
    }

    public static List<Number> listForCount(int _count) {
        if (_count < 0) {
            return null;
        }
        if (_count == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Number> l = new ArrayList<Number>(_count);
        for (int i = 0; i < _count; ++i) {
            l.add(new Integer(i));
        }
        return l;
    }

    public int count(Collection<?> collectionObj) {
        return collectionObj.size();
    }

    public static boolean compareCollectionSize(Collection<?> coll1, Collection<?> coll2) {
        if (coll1 == null && coll2 == null) {
            return true;
        }
        if (coll1 == null) {
            return false;
        }
        if (coll2 == null) {
            return false;
        }
        return coll1.size() == coll2.size();
    }

    public static Map<Object, Object> mapForKey(List<?> list, String key) {
        HashMap<Object, Object> hash = new HashMap<Object, Object>();
        for (Object object : list) {
            hash.put(LogicUnit.getField(object, key), object);
        }
        return hash;
    }

    public static <T> List<T> listDifference(Class<T> objectClass, List<?> list1, List<?> list2) {
        ArrayList resultantArrayList = new ArrayList();
        ArrayList tempList1 = new ArrayList(list1);
        list1.removeAll(list2);
        list2.removeAll(tempList1);
        resultantArrayList.addAll(list1);
        resultantArrayList.addAll(list2);
        return resultantArrayList;
    }

    public static Collection getValuesFormCollection(Collection<?> list, String property) {
        if (property == null) {
            return null;
        }
        Collection values = (Collection)InstanceUtil.getInstance(list.getClass(), new Object[0]);
        for (Object obj : list) {
            if (!LogicUnit.getAllField(obj, new String[0]).containsKey(property)) continue;
            values.add(LogicUnit.getField(obj, property));
        }
        return values;
    }

    public Map<?, ?> getMultiValuesFormCollection(Collection<?> list, String property) {
        if (property == null) {
            return null;
        }
        HashMap objMap = new HashMap();
        ArrayList values = new ArrayList();
        for (Object obj : list) {
            if (!LogicUnit.getAllField(obj, new String[0]).containsKey(property)) continue;
            values.add(LogicUnit.getField(obj, property));
        }
        objMap.put(property, values);
        return objMap;
    }

    public static void setPropertiesFromCollection(Collection<?> list, Map<String, Object> map) {
    }

    public static Map<String, Object> getPropertiesFromCollection(Collection<?> list, String[] properties) {
        return null;
    }

    public static Collection<?> textToCollection(String buffer, String text) {
        if (buffer == null) {
            return new ArrayList();
        }
        StringTokenizer token = new StringTokenizer(buffer, text, false);
        ArrayList<Object> returnVector = new ArrayList<Object>();
        while (token.hasMoreTokens()) {
            returnVector.add(token.nextElement());
        }
        return returnVector;
    }

    public static Collection<?> textToCollectionNoWhiteSpace(String buffer, String delim) {
        if (buffer == null) {
            return new ArrayList();
        }
        StringTokenizer token = new StringTokenizer(buffer, delim);
        ArrayList<String> returnVector = new ArrayList<String>();
        while (token.hasMoreTokens()) {
            String str = token.nextElement().toString();
            if (str.equals("") || str == null) continue;
            returnVector.add(str);
        }
        return returnVector;
    }

    public static Collection<?> textToCollection(String buffer) {
        if (buffer == null) {
            return new ArrayList();
        }
        StringTokenizer token = new StringTokenizer(buffer, ",", true);
        String prev = " ";
        ArrayList<String> returnVector = new ArrayList<String>();
        while (token.hasMoreTokens()) {
            String o = (String)token.nextElement();
            if (o.equals(",")) {
                if (prev.equals(o)) {
                    returnVector.add(" ");
                }
                prev = o;
                continue;
            }
            returnVector.add(o);
            prev = o;
        }
        return returnVector;
    }

    public static Collection<?> mapToCollection(Map<?, ?> map) {
        ArrayList returnVector = new ArrayList();
        for (Object key : map.keySet()) {
            returnVector.add(map.get(key));
        }
        return returnVector;
    }

    public static Map<String, Object> getPropertiesFromMap(Map<?, ?> map, Object[] properties) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        for (int i = 0; i < properties.length; ++i) {
            returnMap.put((String)properties[i], map.get(properties[i]));
        }
        return returnMap;
    }

    public static void setPropertiesFromMap(Map<String, Object> origMap, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            origMap.put(entry.getKey(), entry.getValue());
        }
    }

    public static Hashtable convertCollectionToMap(Collection<?> vt, String keys) {
        Hashtable<String, Hashtable> returnHash = new Hashtable<String, Hashtable>();
        Vector<Object> keyVt = ObjectUtil.convertStringtoArray(keys);
        Iterator<?> i = vt.iterator();
        while (i.hasNext()) {
            Hashtable row = (Hashtable)i.next();
            Hashtable<String, Hashtable> hashTable = returnHash;
            Iterator e1 = keyVt.iterator();
            while (i.hasNext()) {
                String key = e1.next().toString();
                Object xxx = row.get(key);
                String hashKey = xxx != null && xxx instanceof Number ? key + "_" + ((Number)row.get(key)).intValue() : key + "_" + StringUtil.cleanText(xxx.toString());
                if (e1.hasNext()) {
                    Hashtable loopHash = (Hashtable)hashTable.get(hashKey);
                    if (loopHash == null) {
                        loopHash = new Hashtable();
                    }
                    hashTable.put(hashKey, loopHash);
                    hashTable = loopHash;
                    continue;
                }
                hashTable.put(hashKey, row);
            }
        }
        return returnHash;
    }

    public void updateObjectFromMap(Object aObject, Map<String, Object> map) {
        this.updateObjectFromMap(aObject, map, true);
    }

    public void updateObjectFromMap(Object object, Map<String, Object> map, boolean skipNullValues) {
        if (map == null) {
            return;
        }
        for (String key : map.keySet()) {
            if (map.get(key) == null && skipNullValues) continue;
            LogicUnit.setField(object, map.get(key).toString(), (Object)key);
        }
    }

    public void updateObjectGraphFromMap(Object object, Map<?, ?> _map) {
        for (Map.Entry<?, ?> entry : _map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            LogicUnit.setField(object, key, value);
        }
    }

    public Map<String, Object> getFieldsMapFromObject(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String key = fields[i].getName();
            Object value = LogicUnit.getField(obj, key);
            map.put(key, value);
        }
        return map;
    }

    public Object[] arrayByAddingObjAtZeroIndex(Object object, Object ... paramObjects) {
        Object[] objArray = new Object[paramObjects.length + 1];
        objArray[0] = object;
        for (int i = 1; i <= paramObjects.length; ++i) {
            objArray[i] = paramObjects[i - 1];
        }
        return objArray;
    }

    public Object castObject(Object object, String type) {
        if (type == null || type.trim().equals("")) {
            return object;
        }
        return CastingUtil.castObject(object, ClassUtil.getClass(type));
    }

    public static Vector<Object> getLinesForFile(File file) throws IOException {
        return ObjectUtil.getLinesForString(new String(FileUtil.loadByteFile(file)));
    }

    public static Vector<Object> getLinesForString(String value) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(value));
            Vector<Object> x = new Vector<Object>();
            while ((line = reader.readLine()) != null) {
                x.addElement(line);
            }
            return x;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Vector<Object> getPartVectorForString(String str, int parts) {
        Vector<Object> vt = new Vector<Object>();
        if (str.length() == 0) {
            vt.addElement(str);
            return vt;
        }
        int seg = (int)Math.ceil((double)str.length() / (double)parts);
        for (int i = 0; i < seg - 1; ++i) {
            vt.addElement(str.substring(parts * i, parts * (i + 1)));
        }
        vt.addElement(str.substring(parts * (seg - 1), str.length()));
        return vt;
    }

    public static byte[] hashToBytes(Hashtable<?, ?> hash) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream p = new ObjectOutputStream(byteStream);
            p.writeObject(hash);
            p.flush();
            byte[] array = byteStream.toByteArray();
            p.close();
            byteStream.close();
            return array;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Hashtable<String, Object> readHashTable(File file) {
        try {
            ObjectInputStream p = new ObjectInputStream(new FileInputStream(file));
            Hashtable hash = (Hashtable)p.readObject();
            p.close();
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean getBoolean(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value != null && value instanceof Number && ((Number)value).intValue() != 0) {
            return true;
        }
        return value != null && value instanceof String && ((String)value).compareTo("1") == 0;
    }

    public static Vector<Object> convertStringtoArray(String buffer, String token1) {
        if (buffer == null) {
            return new Vector<Object>();
        }
        StringTokenizer token = new StringTokenizer(buffer, token1, false);
        Vector<Object> vt = new Vector<Object>();
        while (token.hasMoreTokens()) {
            vt.addElement(token.nextElement());
        }
        return vt;
    }

    public static Vector<Object> convertStringtoArray(String buffer) {
        if (buffer == null) {
            return new Vector<Object>();
        }
        StringTokenizer token = new StringTokenizer(buffer, ",", false);
        Vector<Object> vt = new Vector<Object>();
        while (token.hasMoreTokens()) {
            vt.addElement(token.nextElement());
        }
        return vt;
    }

    public static Vector<Object> convertStringtoArray1(String buffer) {
        if (buffer == null) {
            return new Vector<Object>();
        }
        StringTokenizer token = new StringTokenizer(buffer, ",", true);
        String prev = " ";
        Vector<Object> vt = new Vector<Object>();
        while (token.hasMoreTokens()) {
            String o = (String)token.nextElement();
            if (o.equals(",")) {
                if (prev.equals(o)) {
                    vt.addElement(" ");
                }
                prev = o;
                continue;
            }
            vt.addElement(o);
            prev = o;
        }
        return vt;
    }

    public boolean isEquivalent(Object object1, Object object2, Map<String, String> keyMap, boolean isDebug) {
        for (Map.Entry<String, String> entry : keyMap.entrySet()) {
            Object value1 = LogicUnit.getField(object2, entry.getKey());
            Object value2 = LogicUnit.getField(object1, entry.getValue());
            if (value1 != null) {
                if (value1.equals(value2)) continue;
                if (isDebug) {
                    System.out.println(entry.getKey() + " = " + value1 + " ; " + entry.getValue() + " = " + value2);
                }
                return false;
            }
            if (value2 == null) continue;
            if (isDebug) {
                System.out.println(entry.getKey() + " = " + value1 + " ; " + entry.getValue() + " = " + value2);
            }
            return false;
        }
        return true;
    }

    public static Vector<Object> convertStringToVectorNoWhiteSpace(String buffer, String delim) {
        if (buffer == null) {
            return new Vector<Object>();
        }
        StringTokenizer token = new StringTokenizer(buffer, delim);
        Vector<Object> vt = new Vector<Object>();
        while (token.hasMoreTokens()) {
            String str = token.nextElement().toString();
            if (str.equals("") || str == null) continue;
            vt.addElement(str);
        }
        return vt;
    }

    public static Vector convertHashtoVector(Hashtable h) {
        Vector returnVector = new Vector();
        Enumeration enumer = h.elements();
        while (enumer.hasMoreElements()) {
            Object item = enumer.nextElement();
            returnVector.add(item);
        }
        return returnVector;
    }

    public static void writeHashTable(File file, Hashtable<String, Object> hash) {
        try {
            ObjectOutputStream p = new ObjectOutputStream(new FileOutputStream(file));
            p.writeObject(hash);
            p.flush();
            p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Hashtable convertVectorToHash(Vector vt, String keys) {
        Hashtable<String, Hashtable> returnHash = new Hashtable<String, Hashtable>();
        Vector<Object> keyVt = ObjectUtil.convertStringtoArray(keys);
        Enumeration e = vt.elements();
        while (e.hasMoreElements()) {
            Hashtable row = (Hashtable)e.nextElement();
            Hashtable<String, Hashtable> hashTable = returnHash;
            Enumeration<Object> e1 = keyVt.elements();
            while (e1.hasMoreElements()) {
                String key = e1.nextElement().toString();
                Object xxx = row.get(key);
                String hashKey = xxx != null && xxx instanceof Number ? key + "_" + ((Number)row.get(key)).intValue() : key + "_" + StringUtil.cleanText(xxx.toString());
                if (e1.hasMoreElements()) {
                    Hashtable loopHash = (Hashtable)hashTable.get(hashKey);
                    if (loopHash == null) {
                        loopHash = new Hashtable();
                    }
                    hashTable.put(hashKey, loopHash);
                    hashTable = loopHash;
                    continue;
                }
                hashTable.put(hashKey, row);
            }
        }
        return returnHash;
    }

    public static String[] ConvertVectorToStringArray(Vector lines) {
        String[] returnArray = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            returnArray[i] = (String)lines.elementAt(i);
        }
        return returnArray;
    }

    public static Vector ConvertStringArrayToVector(String[] lines) {
        Vector<String> returnVector = new Vector<String>();
        for (int i = 0; i < lines.length; ++i) {
            returnVector.addElement(lines[i]);
        }
        return returnVector;
    }

    public static int getIntFromHash(Map hash, String key, boolean isMandatory, int min, int max, int defaultValue) {
        Object object = hash.get(key);
        if (object != null && (object instanceof Integer || object instanceof String || object instanceof String[])) {
            int i;
            if (object instanceof String) {
                object = Integer.valueOf(ObjectUtil.getUncommentedValue(object.toString()));
            }
            if (object instanceof String[] && ((String[])object).length > 0) {
                object = Integer.valueOf(((String[])object)[0]);
            }
            if ((i = ((Integer)object).intValue()) < min) {
                System.out.println("Minimum permissible value of " + key + " is " + min + " so taking " + min + " as its value");
                return min;
            }
            if (i > max) {
                System.out.println("Maximum permissible value of " + key + " is " + max + " so taking " + max + " as its value");
                return max;
            }
            return i;
        }
        if (isMandatory) {
            throw new RuntimeException(key + " is missing in " + hash);
        }
        return defaultValue;
    }

    public static double getDoubleFromHash(Map hash, String key, boolean isMandatory, double min, double max, double defaultValue) {
        Object object = hash.get(key);
        if (object != null && (object instanceof Double || object instanceof String)) {
            double d;
            if (object instanceof String) {
                object = Double.valueOf(ObjectUtil.getUncommentedValue(object.toString()));
            }
            if ((d = ((Double)object).doubleValue()) < min) {
                System.out.println("Minimum permissible value of " + key + " is " + min + " so taking " + min + " as its value");
                return min;
            }
            if (d > max) {
                System.out.println("Maximum permissible value of " + key + " is " + max + " so taking " + max + " as its value");
                return max;
            }
            return d;
        }
        if (isMandatory) {
            throw new RuntimeException(key + " is missing in " + hash);
        }
        return defaultValue;
    }

    public static boolean getBooleanFromHash(Map hash, String key, boolean isMandatory, boolean defaultValue) {
        Object object = hash.get(key);
        if (object != null && (object instanceof Integer || object instanceof String)) {
            if (object instanceof String) {
                object = Integer.valueOf(ObjectUtil.getUncommentedValue(object.toString()));
            }
            return (Integer)object != 0;
        }
        if (isMandatory) {
            throw new RuntimeException(key + " is missing in " + hash);
        }
        return defaultValue;
    }

    public static String getUncommentedValue(String str) {
        if (str.contains("#")) {
            str = str.substring(0, str.indexOf("#"));
        }
        return str.trim();
    }

    public static Vector getVectorFromHash(Map hash, String key, boolean isMandatory, Vector defaultValue) {
        Object object = hash.get(key);
        if (object != null && object instanceof Vector) {
            return (Vector)object;
        }
        if (isMandatory) {
            throw new RuntimeException(key + " is missing in " + hash);
        }
        return defaultValue;
    }

    public static Hashtable getHashFromHash(Map hash, String key, boolean isMandatory, Hashtable defaultValue) {
        Object object = hash.get(key);
        if (object != null && object instanceof Hashtable) {
            return (Hashtable)object;
        }
        if (isMandatory) {
            throw new RuntimeException(key + " is missing in " + hash);
        }
        return defaultValue;
    }

    public static ArrayList<Object> getArrayFromHash(Map hash, String key, boolean isMandatory, ArrayList defaultValue) {
        Object object = hash.get(key);
        if (object != null && object instanceof ArrayList) {
            return (ArrayList)object;
        }
        if (isMandatory) {
            throw new RuntimeException(key + " is missing in " + hash);
        }
        return defaultValue;
    }

    public static ArrayList getFilteredList(Collection _beanList, String keyPath, Object filterValue) {
        ArrayList filterList = new ArrayList();
        if (filterValue == null) {
            for (Object object : _beanList) {
                Object value = LogicUnit.getField(object, keyPath);
                if (value != null) continue;
                filterList.add(value);
            }
        } else {
            for (Object object : _beanList) {
                Object value = LogicUnit.getField(object, keyPath);
                if (!filterValue.equals(value)) continue;
                filterList.add(value);
            }
        }
        return filterList;
    }

    public static void sort(List _beanObjects, String key, boolean isReverse) {
        if (isReverse) {
            Collections.reverse(_beanObjects);
        }
    }

    public static ArrayList<String> listForArray(String[] stringArray) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (stringArray != null) {
            for (String string : stringArray) {
                stringList.add(string);
            }
        }
        return stringList;
    }

    public static List<String> listForArray(List<String[]> listOfStringArray) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (listOfStringArray != null) {
            for (String[] stringArray : listOfStringArray) {
                stringList.addAll(ObjectUtil.listForArray(stringArray));
            }
        }
        return stringList;
    }

    public static String getCharSeparatedText(Iterable iterable, String c) {
        StringBuffer strBuf = new StringBuffer();
        Iterator itr = iterable.iterator();
        while (itr.hasNext()) {
            strBuf.append(itr.next());
            if (!itr.hasNext()) continue;
            strBuf.append(c);
        }
        return strBuf.toString();
    }

    public static boolean isEmpty(Object[] _array) {
        if (_array == null) {
            return true;
        }
        return _array.length == 0;
    }

    public static boolean isEmpty(Collection<?> _collection) {
        if (_collection == null) {
            return true;
        }
        return _collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> _map) {
        if (_map == null) {
            return true;
        }
        return _map.isEmpty();
    }

    public static Map<Object, Object> mapForKey(String key, Collection<?> objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object object : objects) {
            try {
                Object data = FieldUtil.getField(object.getClass(), key).get(object);
                map.put(data, object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static Map<String, Object> mapForKeyValues(String keys, Object ... values) {
        String[] keySet = keys.split("~");
        Assertion.isTrue(keySet.length == values.length, "Values for Keys is not valid");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int index = 0; index < keySet.length; ++index) {
            map.put(keySet[index], values[index]);
        }
        return map;
    }

    public static void main(String[] args) {
        Object[] array = new Integer[]{0, 1, 3};
        ObjectUtil.reverseArray(array);
        Object[] objectArray = array;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = (Integer)objectArray[i];
            System.out.println(i2);
        }
    }
}

