/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.objects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    public static Properties getProperties(File file) {
        try {
            return PropertiesUtil.getProperties(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Properties getProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static Properties getProperties(Map<String, Object> map) {
        Properties properties = new Properties();
        if (map == null) {
            return properties;
        }
        String parentKey = "";
        PropertiesUtil.fillMap(properties, parentKey, map);
        return properties;
    }

    public static void fillMap(Properties properties, String parentKey, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                PropertiesUtil.fillMap(properties, parentKey.isEmpty() ? entry.getKey() : parentKey + "." + entry.getKey(), (Map)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof List) {
                PropertiesUtil.fillList(properties, parentKey.isEmpty() ? entry.getKey() : parentKey + "." + entry.getKey(), (List)entry.getValue());
                continue;
            }
            properties.put(parentKey.isEmpty() ? entry.getKey() : parentKey + "." + entry.getKey(), entry.getValue());
        }
        if (!parentKey.isEmpty()) {
            properties.put(parentKey, map);
        }
    }

    public static void fillList(Properties properties, String parentKey, List<Object> list) {
        int index = 0;
        for (Object object : list) {
            if (object instanceof Map) {
                PropertiesUtil.fillMap(properties, parentKey + "[" + index + "]", (Map)object);
            } else if (object instanceof List) {
                PropertiesUtil.fillList(properties, parentKey + "[" + index + "]", (List)object);
            } else {
                properties.put(parentKey + "[" + index + "]", object);
            }
            ++index;
        }
        if (!parentKey.isEmpty()) {
            properties.put(parentKey, list);
        }
    }
}

