/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.printer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.brijframework.util.accessor.PropertyAccessorUtil;
import org.brijframework.util.reflect.InstanceUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.validator.ValidationUtil;

public class GraphPrinter {
    private StringBuffer stringToCopy = new StringBuffer("");
    static GraphPrinter printer = null;
    Object object;

    public static GraphPrinter getPrinter(Object object) {
        printer = (GraphPrinter)InstanceUtil.getSingletonInstance(GraphPrinter.class, new Object[0]);
        GraphPrinter.printer.object = object;
        return printer;
    }

    public String printToScreen() {
        this.printObject(this.object, 0);
        System.out.println(this.stringToCopy.toString());
        return this.stringToCopy.toString();
    }

    public String printObject() {
        this.printObject(this.object, 0);
        return this.stringToCopy.toString();
    }

    public String printObject(Object a) {
        this.printObject(a, 0);
        return this.stringToCopy.toString();
    }

    private void printObject(Object object, int tab) {
        if (object == null) {
            return;
        }
        Map<String, Object> t = object;
        if (ValidationUtil.isBrijClass(object)) {
            t = PropertyAccessorUtil.getProperties(object, ReflectionAccess.PRIVATE_NO_STATIC_FINAL);
        }
        if (t instanceof Map && tab == 0) {
            tab = 1;
        }
        if (t instanceof Map) {
            this.debugln("{");
            this.printObject(t, ++tab);
            this.printTab(tab - 1);
            this.debug("}");
        } else if (t instanceof Collection) {
            this.debugln("[");
            this.printObject((Collection)((Object)t), ++tab);
            this.debugln("");
            this.printTab(tab - 1);
            this.debug("]");
        } else if (t instanceof Character) {
            this.debug("'" + t + "'");
        } else if (t instanceof String) {
            this.debug("\"" + t + "\"");
        } else if (t instanceof java.util.Date || t instanceof Date || t instanceof Time || t instanceof Timestamp) {
            this.debug(this.formatDate(t));
        } else if (t instanceof Double || t instanceof Float) {
            String value = t.toString();
            this.debug("" + value + "");
        } else if (t instanceof Long) {
            Long value = (Long)((Object)t);
            this.debug("" + value + "");
        } else if (t instanceof Integer) {
            Integer value = (Integer)((Object)t);
            this.debug("" + value + "");
        } else if (t instanceof Boolean) {
            Boolean value = (Boolean)((Object)t);
            this.debug("" + (value != false) + "");
        } else {
            this.debug("\"" + t.toString() + "\"");
        }
    }

    public String formatDate(Object date) {
        return date.toString();
    }

    private void printObject(Collection<?> t, int tab) {
        Iterator<?> e = t.iterator();
        while (e.hasNext()) {
            this.printTab(tab + 1);
            this.printObject(e.next(), tab + 1);
            if (!e.hasNext()) continue;
            this.debugln(",");
        }
    }

    private void printObject(Map t, int tab) {
        Set entries = t.entrySet();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            this.printTab(tab);
            this.debug(key.toString() + " = ");
            this.printObject(t.get(key), tab);
            this.debugln(";");
        }
    }

    private void debugln(String t) {
        this.debug(t + "\r\n");
    }

    private void debug(String t) {
        this.stringToCopy.append(t);
    }

    private void printTab(int no) {
        for (int i = 0; i < no - 1; ++i) {
            this.debug("   ");
        }
    }

    public boolean validateString(String aString) {
        for (int i = 0; i < aString.length(); ++i) {
            char c = aString.toUpperCase().charAt(i);
            if (c >= 'A' && c <= 'Z' || c == ' ' || c == '(' || c == ')') continue;
            return false;
        }
        return true;
    }

    public Object printToFile(File file) {
        if (!file.exists()) {
            return null;
        }
        this.printObject();
        try {
            FileWriter fileToWrite = new FileWriter(file);
            fileToWrite.write(this.stringToCopy.toString());
            fileToWrite.flush();
            fileToWrite.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.stringToCopy.toString();
    }

    public Object printToFile(String filePath) {
        File file = new File(filePath);
        this.printToFile(file);
        return this.stringToCopy.toString();
    }
}

