/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.resouces;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.brijframework.util.location.DirUtil;
import org.brijframework.util.location.PathUtil;
import org.brijframework.util.location.StreamUtil;
import org.brijframework.util.resouces.FileUtil;
import org.brijframework.util.resouces.JSONUtil;
import org.brijframework.util.resouces.XMLUtil;
import org.brijframework.util.validator.ValidationUtil;

public class ResourcesUtil {
    private static final String META_INF = "META-INF";

    public static Collection<? extends File> getCurrentResources(String path, String extesions) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ResourcesUtil.getCurrentResources(classLoader, path, extesions);
    }

    public static Collection<? extends File> getCurrentResources(ClassLoader classLoader, String path, String extesions) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<? extends File> files = new ArrayList<File>();
        for (File directory : dirs) {
            files.addAll(ResourcesUtil.findCurrentFiles(directory, extesions));
        }
        return files;
    }

    public static Collection<? extends File> findCurrentFiles(File directory, String ... extesions) {
        ArrayList<File> files = new ArrayList<File>();
        if (!directory.exists()) {
            return files;
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                files.add(file);
                continue;
            }
            if (!ResourcesUtil.isValid(file, extesions)) continue;
            files.add(file);
        }
        return files;
    }

    public static List<File> getResources(ClassLoader classLoader, String path, String ... extesions) throws IOException {
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File file : dirs) {
            if (file.isDirectory()) {
                files.addAll(ResourcesUtil.findFiles(file, extesions));
                continue;
            }
            files.add(file);
        }
        return files;
    }

    public static List<File> getResources(String path, String ... extesions) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ResourcesUtil.getResources(classLoader, path, extesions);
    }

    public static URL getResource(String path) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResource(path);
    }

    public static URL getResourceJar(String path) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        System.out.println(classLoader);
        System.out.println(classLoader.getParent());
        try {
            Enumeration<URL> enu = classLoader.getParent().getResources("");
            while (enu.hasMoreElements()) {
                System.out.println(enu.nextElement());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classLoader.getParent().getResource(path);
    }

    public static Collection<? extends File> findFiles(File directory, String ... extesions) {
        ArrayList<? extends File> files = new ArrayList<File>();
        if (!directory.exists()) {
            return files;
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(ResourcesUtil.findFiles(file, extesions));
                continue;
            }
            if (!ResourcesUtil.isValid(file, extesions)) continue;
            files.add(file);
        }
        return files;
    }

    private static boolean isValid(File file, String ... extesions) {
        if (extesions == null || extesions.length == 0) {
            return true;
        }
        for (String extesion : extesions) {
            if (extesion == null || !file.getName().endsWith(extesion)) continue;
            return true;
        }
        return false;
    }

    public static Class<?>[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(ResourcesUtil.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(ResourcesUtil.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String cls = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            Class<?> _cls = null;
            try {
                _cls = Class.forName(cls);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError throwable) {
                // empty catch block
            }
            if (_cls == null) continue;
            classes.add(_cls);
        }
        return classes;
    }

    public static Class<?>[] getClasses(ClassLoader classLoader) {
        assert (classLoader != null);
        ArrayList classes = new ArrayList();
        for (String path : System.getProperty("java.class.path").split(":")) {
            File rootPath = new File(path);
            if (rootPath == null || rootPath.listFiles() == null) continue;
            for (File directory : rootPath.listFiles()) {
                String packageName;
                if (!directory.isDirectory() || META_INF.equals(packageName = directory.getName())) continue;
                try {
                    classes.addAll(ResourcesUtil.findClasses(directory, packageName));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class<?>[] getClasses() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ResourcesUtil.getClasses(classLoader);
    }

    public static ArrayList loadFilesFromJarOrDirectly(String dirPath, URL dirUrl) {
        ArrayList<InputStream> inputStreamArray = new ArrayList<InputStream>();
        try {
            URLConnection urlConnection = dirUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                JarURLConnection jarURLConnection = (JarURLConnection)urlConnection;
                JarFile jarFile = jarURLConnection.getJarFile();
                String alternateDirPath = dirPath;
                if (dirPath.length() > 1 && dirPath.startsWith("/")) {
                    alternateDirPath = dirPath.substring(1);
                }
                Enumeration<JarEntry> enm = jarFile.entries();
                while (enm.hasMoreElements()) {
                    JarEntry jarEntry = enm.nextElement();
                    if (jarEntry.isDirectory() || !jarEntry.getName().startsWith(dirPath) && !jarEntry.getName().startsWith(alternateDirPath)) continue;
                    inputStreamArray.add(jarFile.getInputStream(jarEntry));
                }
            } else {
                File dirOrFile = new File(dirUrl.getPath());
                if (dirOrFile.isDirectory()) {
                    File[] files = dirOrFile.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        FileInputStream fileInputStream = new FileInputStream(files[i]);
                        inputStreamArray.add(fileInputStream);
                    }
                } else {
                    FileInputStream fileInputStream = new FileInputStream(dirOrFile);
                    inputStreamArray.add(fileInputStream);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could Not load directory from directory " + dirPath, e);
        }
        return inputStreamArray;
    }

    public static boolean dirCreate(String dir) {
        String[] dirs;
        for (String path : dirs = dir.split("~")) {
            File file = new File(PathUtil.locateURIConfig(path));
            if (DirUtil.createFolder(file)) continue;
        }
        return true;
    }

    public static List<Object> getLisFromJsonFile(String dir) {
        ArrayList<Object> loadtable = new ArrayList<Object>();
        File file = new File(PathUtil.locateURIConfig(dir));
        if (file != null) {
            if (file.isDirectory()) {
                File[] files;
                for (File filez : files = StreamUtil.getAllResurces(dir, ".json")) {
                    List<Object> list;
                    String json = "";
                    try {
                        json = new String(FileUtil.loadCharFile(filez));
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (json.isEmpty() || !ValidationUtil.isValidObject(list = JSONUtil.getListFromJSONArray(json))) continue;
                    loadtable.addAll(list);
                }
            } else if (file.isFile()) {
                List<Object> list;
                String json = "";
                try {
                    json = new String(FileUtil.loadCharFile(file));
                }
                catch (Exception e) {
                    return null;
                }
                if (!json.isEmpty() && !ValidationUtil.isEmptyObject(list = JSONUtil.getListFromJSONArray(json))) {
                    loadtable.addAll(list);
                }
            }
        }
        return loadtable;
    }

    public static Map<String, Object> getMapFromJsonFile(String filePath) {
        if (!ValidationUtil.isEmptyObject(filePath)) {
            return new HashMap<String, Object>();
        }
        File file = new File(PathUtil.locateURIConfig(filePath));
        String json = "";
        try {
            json = new String(FileUtil.loadCharFile(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!json.isEmpty()) {
            return JSONUtil.getMapFromJSONString(json);
        }
        return null;
    }

    public static List<Object> getListFromXMLFile(String dir) {
        ArrayList<Object> loadtable = new ArrayList<Object>();
        if (!ValidationUtil.isEmptyObject(dir)) {
            return loadtable;
        }
        File file = new File(PathUtil.locateURIConfig(dir));
        if (file != null) {
            if (file.isDirectory()) {
                File[] files;
                for (File filez : files = StreamUtil.getAllResurces(dir, ".xml")) {
                    Map<String, Object> map;
                    String xml = "";
                    try {
                        xml = new String(FileUtil.loadCharFile(filez));
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (xml.isEmpty() || (map = XMLUtil.rootMapFromXML(xml)) == null) continue;
                    loadtable.add(map);
                }
            } else if (file.isFile()) {
                String xml = "";
                try {
                    xml = new String(FileUtil.loadCharFile(file));
                }
                catch (Exception e) {
                    return null;
                }
                if (!ValidationUtil.isEmptyObject(xml)) {
                    return null;
                }
                Map<String, Object> map = XMLUtil.rootMapFromXML(xml);
                if (map != null) {
                    loadtable.add(map);
                }
            }
        }
        return loadtable;
    }

    public static Map<String, Object> getMapFromXMLFile(String filePath) {
        if (!ValidationUtil.isEmptyObject(filePath)) {
            return new HashMap<String, Object>();
        }
        File file = new File(PathUtil.locateURIConfig(filePath));
        String xml = "";
        try {
            xml = new String(FileUtil.loadCharFile(file));
        }
        catch (Exception e) {
            return null;
        }
        if (!ValidationUtil.isEmptyObject(xml)) {
            return null;
        }
        return XMLUtil.rootMapFromXML(xml);
    }

    public static List<Object> getListFromOBJFile(String beans) {
        return null;
    }

    public static List<Object> getMapFromOBJFile(String beans) {
        if (!ValidationUtil.isEmptyObject(beans)) {
            return new ArrayList<Object>();
        }
        File file = new File(PathUtil.locateURIConfig(beans));
        String json = "";
        try {
            json = new String(FileUtil.loadCharFile(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return JSONUtil.getListFromJSONArray(json);
    }

    public static Object getObjectFromPersistFile(String beans) {
        if (!ValidationUtil.isEmptyObject(beans)) {
            return new ArrayList();
        }
        File file = new File(PathUtil.locateURIConfig(beans));
        return FileUtil.readObject(file);
    }

    public static List<Object> getListFromPersistFile(String dir) {
        ArrayList<Object> loadtable = new ArrayList<Object>();
        if (!ValidationUtil.isEmptyObject(dir)) {
            return loadtable;
        }
        File file = new File(PathUtil.locateURIConfig(dir));
        if (file != null) {
            if (file.isDirectory()) {
                File[] files;
                for (File filez : files = StreamUtil.getAllResurces(dir, ".ser")) {
                    Object obj = FileUtil.readObject(filez);
                    loadtable.add(obj);
                }
            } else if (file.isFile()) {
                Object obj = FileUtil.readObject(file);
                loadtable.add(obj);
            }
        }
        return loadtable;
    }
}

