/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.accessor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.brijframework.util.accessor.EventValidateUtil;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.FieldUtil;
import org.brijframework.util.reflect.MethodUtil;
import org.brijframework.util.reflect.ParamUtil;
import org.brijframework.util.support.ReflectionAccess;
import org.brijframework.util.validator.ValidationUtil;

public class MetaAccessorUtil {
    public static AccessibleObject getPropertyMeta(Class<?> meta, String field) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        return MetaAccessorUtil.findGetterMeta(meta, field, ReflectionAccess.PUBLIC);
    }

    public static AccessibleObject findGetterMeta(Class<?> meta, String field, ReflectionAccess level) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        try {
            Method getter = MetaAccessorUtil.getterPropertyDescriptor(meta, field);
            return getter != null ? getter : MetaAccessorUtil.findFieldMeta(meta, field, level);
        }
        catch (IntrospectionException | IllegalArgumentException e) {
            return null;
        }
    }

    public static AccessibleObject setPropertyMeta(Class<?> meta, String field, Object value) {
        return MetaAccessorUtil.setPropertyMeta(meta, field, ReflectionAccess.PUBLIC, value);
    }

    public static AccessibleObject findSetterMeta(Class<?> meta, String field, ReflectionAccess level) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        try {
            Method setter = MetaAccessorUtil.setterPropertyDescriptor(meta, field);
            return setter != null ? setter : MetaAccessorUtil.findFieldMeta(meta, field, level);
        }
        catch (IntrospectionException | IllegalArgumentException e) {
            return null;
        }
    }

    public static AccessibleObject setPropertyMeta(Class<?> meta, String field, ReflectionAccess level, Object value) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        try {
            Method setter = MetaAccessorUtil.setterPropertyDescriptor(meta, field, value);
            return setter != null ? setter : MetaAccessorUtil.findFieldMeta(meta, field, level);
        }
        catch (IntrospectionException | IllegalArgumentException e) {
            return null;
        }
    }

    public static List<AccessibleObject> getPropertiesMeta(Class<?> meta) {
        return MetaAccessorUtil.getPropertiesMeta(meta, ReflectionAccess.PUBLIC);
    }

    public static List<AccessibleObject> getPropertiesMeta(Class<?> meta, ReflectionAccess level) {
        ArrayList<AccessibleObject> properties = new ArrayList<AccessibleObject>();
        BeanInfo beaninfo = null;
        try {
            beaninfo = Introspector.getBeanInfo(meta);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        for (PropertyDescriptor pd : beaninfo.getPropertyDescriptors()) {
            Method writer;
            Method reader = pd.getReadMethod();
            if (reader != null && !new Object().getClass().equals(reader.getDeclaringClass())) {
                properties.add(reader);
            }
            if ((writer = pd.getWriteMethod()) == null || new Object().getClass().equals(writer.getDeclaringClass())) continue;
            properties.add(writer);
        }
        for (Field field : FieldUtil.getAllField(meta, level)) {
            properties.add(field);
        }
        return properties;
    }

    public static Method getLogicMeta(Class<?> meta, String _method, Object ... params) {
        Assertion.notNull(_method, "this method name is required; it must not be null");
        return MetaAccessorUtil.getLogicMeta(meta, _method, ReflectionAccess.PUBLIC, params);
    }

    public static Method getLogicMeta(Class<?> meta, String _method, ReflectionAccess level, Object ... paramObjects) {
        Assertion.notNull(_method, "this method name is required; it must not be null");
        try {
            Method method = MetaAccessorUtil.getMethodDescriptor(meta, _method, paramObjects);
            return method != null ? method : MetaAccessorUtil.getMethodMeta(meta, level, _method, paramObjects);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public static Method getterPropertyMeta(Class<?> _meta, String _name) {
        try {
            return MetaAccessorUtil.getterPropertyDescriptor(_meta, _name);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public static Method getterPropertyDescriptor(Class<?> _meta, String _name) throws IntrospectionException {
        PropertyDescriptor[] pds;
        BeanInfo beaninfo = Introspector.getBeanInfo(_meta);
        for (PropertyDescriptor pd : pds = beaninfo.getPropertyDescriptors()) {
            Method getterMethod = pd.getReadMethod();
            if (getterMethod == null || !EventValidateUtil.validReader(getterMethod.getName(), _name)) continue;
            return getterMethod;
        }
        return MetaAccessorUtil.getMethodMeta(_meta, ReflectionAccess.PUBLIC, _name, 0);
    }

    public static Method setterPropertyMeta(Class<?> _meta, String _name, Object value) {
        try {
            return MetaAccessorUtil.setterPropertyDescriptor(_meta, _name, value);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method setterPropertyMeta(Class<?> _meta, String _name) {
        try {
            return MetaAccessorUtil.setterPropertyDescriptor(_meta, _name);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method setterPropertyDescriptor(Class<?> _meta, String _name) throws IntrospectionException {
        PropertyDescriptor[] pds;
        BeanInfo beaninfo = Introspector.getBeanInfo(_meta);
        for (PropertyDescriptor pd : pds = beaninfo.getPropertyDescriptors()) {
            Method setterMethod = pd.getWriteMethod();
            if (setterMethod == null || !EventValidateUtil.validWriter(setterMethod.getName(), _name)) continue;
            return setterMethod;
        }
        return MetaAccessorUtil.getMethodMeta(_meta, ReflectionAccess.PUBLIC, _name, 1);
    }

    public static Map<String, Method> setterPropertyDescriptorList(Class<?> _meta) {
        HashMap<String, Method> propertyDescriptorList = new HashMap<String, Method>();
        try {
            PropertyDescriptor[] pds;
            BeanInfo beaninfo = Introspector.getBeanInfo(_meta);
            for (PropertyDescriptor pd : pds = beaninfo.getPropertyDescriptors()) {
                Method setterMethod = pd.getWriteMethod();
                if (setterMethod == null) continue;
                propertyDescriptorList.put(pd.getName(), setterMethod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyDescriptorList;
    }

    public static Map<String, Method> getterPropertyDescriptorList(Class<?> _meta) {
        HashMap<String, Method> propertyDescriptorList = new HashMap<String, Method>();
        try {
            PropertyDescriptor[] pds;
            BeanInfo beaninfo = Introspector.getBeanInfo(_meta);
            for (PropertyDescriptor pd : pds = beaninfo.getPropertyDescriptors()) {
                Method getterMethod = pd.getReadMethod();
                if (getterMethod == null) continue;
                propertyDescriptorList.put(pd.getName(), getterMethod);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyDescriptorList;
    }

    public static Method setterPropertyDescriptor(Class<?> _meta, String _name, Object value) throws IntrospectionException {
        BeanInfo beaninfo = Introspector.getBeanInfo(_meta);
        PropertyDescriptor[] pds = beaninfo.getPropertyDescriptors();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (PropertyDescriptor pd : pds) {
            Method setterMethod = pd.getWriteMethod();
            if (setterMethod == null || !EventValidateUtil.validWriter(setterMethod.getName(), _name)) continue;
            methods.add(setterMethod);
        }
        for (Method method : methods) {
            if (value == null) {
                return method;
            }
            if (method.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                return method;
            }
            if (!ValidationUtil.isNumber(value.toString()) || !method.getParameterTypes()[0].isAssignableFrom(Number.class)) continue;
            return method;
        }
        return methods.size() > 0 ? (Method)methods.get(0) : MetaAccessorUtil.getMethodMeta(_meta, ReflectionAccess.PUBLIC, _name, 1);
    }

    public static Field findFieldMeta(Class<?> _meta, String _name, ReflectionAccess access) {
        try {
            return FieldUtil.getField(_meta, _name, access);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Method getMethodDescriptor(Class<?> _meta, String method, Object ... paramClasses) throws IntrospectionException {
        MethodDescriptor[] methods;
        BeanInfo beaninfo = Introspector.getBeanInfo(_meta);
        for (MethodDescriptor descriptor : methods = beaninfo.getMethodDescriptors()) {
            Method collMethod = descriptor.getMethod();
            if (collMethod == null || !collMethod.getName().equals(method) || !ParamUtil.isEqualParam((Type[])collMethod.getParameterTypes(), paramClasses)) continue;
            return collMethod;
        }
        return null;
    }

    public static Method getMethodMeta(Class<?> _meta, ReflectionAccess level, String _name, Object ... params) {
        try {
            return MethodUtil.getMethod(_meta, _name, level, params);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Method getMethodMeta(Class<?> _meta, ReflectionAccess level, String _name, int params) {
        try {
            return MethodUtil.getMethod(_meta, _name, params, level);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Set<String> getNamePropertiesMeta(Class<?> meta) {
        Assertion.notNull(meta, "meta clas not be null");
        return MetaAccessorUtil.getNamePropertiesMeta(meta, ReflectionAccess.PUBLIC);
    }

    public static Set<String> getNamePropertiesMeta(Class<?> meta, ReflectionAccess level) {
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Field field : FieldUtil.getAllField(meta, ReflectionAccess.PRIVATE)) {
            if (!level.isAccess(field.getModifiers())) continue;
            properties.add(field.getName());
        }
        return properties;
    }

    public static Set<String> getNameLogicsMeta(Class<?> meta) {
        return MetaAccessorUtil.getNamePropertiesMeta(meta, ReflectionAccess.PUBLIC);
    }

    public Set<String> getNameLogicsMeta(Class<?> meta, ReflectionAccess level) {
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Method field : MethodUtil.getAllMethod(meta, level)) {
            properties.add(field.getName());
        }
        return properties;
    }

    public static Set<Method> getLogicsMeta(Class<?> meta) {
        return MetaAccessorUtil.getLogicsMeta(meta, ReflectionAccess.PUBLIC);
    }

    public static Set<Method> getLogicsMeta(Class<?> meta, ReflectionAccess level) {
        LinkedHashSet<Method> properties = new LinkedHashSet<Method>();
        for (Method field : MethodUtil.getAllMethod(meta, level)) {
            properties.add(field);
        }
        return properties;
    }
}

