/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.reflect.InstanceUtil;

public abstract class ParamUtil {
    public static Object[] getDefaultDgruments(Constructor<?> _method) {
        Assertion.notNull(_method, "this method is required; it must not be null");
        Class<?>[] _parames = _method.getParameterTypes();
        Object[] _objects = new Object[_parames.length];
        for (int i = 0; i < _parames.length; ++i) {
            Class<?> cls = _parames[i];
            _objects[i] = InstanceUtil.getImpletationInstanse(cls);
        }
        return _objects;
    }

    public static Class<?>[] paramClasses(Object ... _objects) {
        if (_objects == null) {
            return null;
        }
        Class[] classess = new Class[_objects.length];
        for (int index = 0; index < _objects.length; ++index) {
            classess[index] = _objects[index] instanceof Class ? (Class<?>)_objects[index] : _objects[index].getClass();
        }
        return classess;
    }

    public static boolean isValidParam(Method _method, Object[] _agruments) {
        return ParamUtil.isEqualParam((Type[])_method.getParameterTypes(), _agruments);
    }

    public static boolean isEqualParam(Type[] _params, Type ... _agruments) {
        if (_agruments == null && _params.length == 0) {
            return true;
        }
        if (_params == null && _agruments == null) {
            return true;
        }
        if (_params.length != _agruments.length) {
            return false;
        }
        for (int index = 0; index < _params.length; ++index) {
            if (ParamUtil.isEqualParam((Class)_params[index], (Class)_agruments[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualParam(Type[] _params, Object ... _agruments) {
        return ParamUtil.isEqualParam(_params, ParamUtil.paramClasses(_agruments));
    }

    public static boolean isPrimitiveEq(Class<?> params, Class<?> agr) {
        if (params.isAssignableFrom(Integer.TYPE) && agr.isAssignableFrom(Integer.class)) {
            return true;
        }
        if (params.isAssignableFrom(Integer.class) && agr.isAssignableFrom(Integer.TYPE)) {
            return true;
        }
        if (params.isAssignableFrom(Long.TYPE) && agr.isAssignableFrom(Long.class)) {
            return true;
        }
        if (params.isAssignableFrom(Long.class) && agr.isAssignableFrom(Long.TYPE)) {
            return true;
        }
        if (params.isAssignableFrom(Character.TYPE) && agr.isAssignableFrom(Character.class)) {
            return true;
        }
        if (params.isAssignableFrom(Character.class) && agr.isAssignableFrom(Character.TYPE)) {
            return true;
        }
        if (params.isAssignableFrom(Double.TYPE) && agr.isAssignableFrom(Double.class)) {
            return true;
        }
        if (params.isAssignableFrom(Double.class) && agr.isAssignableFrom(Double.TYPE)) {
            return true;
        }
        if (params.isAssignableFrom(Float.TYPE) && agr.isAssignableFrom(Float.class)) {
            return true;
        }
        return params.isAssignableFrom(Float.class) && agr.isAssignableFrom(Float.TYPE);
    }

    public static boolean isEqualParam(Class<?> params, Class<?> agr) {
        if (Class.class.isAssignableFrom(params) && Class.class.isAssignableFrom(agr)) {
            return true;
        }
        if (Method.class.isAssignableFrom(params) && Method.class.isAssignableFrom(agr)) {
            return true;
        }
        if (Field.class.isAssignableFrom(params) && Field.class.isAssignableFrom(agr)) {
            return true;
        }
        if (ParamUtil.isPrimitiveEq(params, agr)) {
            return true;
        }
        return params.isAssignableFrom(agr);
    }

    public static boolean isValidParam(Constructor<?> _method, Object ... _agruments) {
        Assertion.notNull(_method, "this method is required; it must not be null");
        Type[] _parames = _method.getParameterTypes();
        return ParamUtil.isEqualParam(_parames, _agruments);
    }

    public static boolean isEqualTypes(Type[] _params, Type[] _agruments) {
        if (_params == null && _agruments == null) {
            return true;
        }
        if (_params == null && _agruments != null) {
            return false;
        }
        if (_params != null && _agruments == null) {
            return false;
        }
        if (_params.length != _agruments.length) {
            return false;
        }
        for (int index = 0; index < _params.length; ++index) {
            if (ParamUtil.isEqualParam((Class)_params[index], (Class)_agruments[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Type lhsType, Type rhsType) {
        Assertion.notNull(lhsType, "Left-hand side type must not be null");
        Assertion.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.equals(rhsType) || lhsType.equals(Object.class)) {
            return true;
        }
        if (lhsType instanceof Class) {
            Class lhsClass = (Class)lhsType;
            if (rhsType instanceof Class) {
                return ParamUtil.isAssignable(lhsClass, (Type)((Class)rhsType));
            }
            if (rhsType instanceof ParameterizedType) {
                Type rhsRaw = ((ParameterizedType)rhsType).getRawType();
                if (rhsRaw instanceof Class) {
                    return ParamUtil.isAssignable(lhsClass, (Type)((Class)rhsRaw));
                }
            } else if (lhsClass.isArray() && rhsType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)rhsType).getGenericComponentType();
                return ParamUtil.isAssignable(lhsClass.getComponentType(), rhsComponent);
            }
        }
        if (lhsType instanceof ParameterizedType) {
            if (rhsType instanceof Class) {
                Type lhsRaw = ((ParameterizedType)lhsType).getRawType();
                if (lhsRaw instanceof Class) {
                    return ParamUtil.isAssignable((Class)lhsRaw, (Type)((Class)rhsType));
                }
            } else if (rhsType instanceof ParameterizedType) {
                return ParamUtil.isAssignable((ParameterizedType)lhsType, (ParameterizedType)rhsType);
            }
        }
        if (lhsType instanceof GenericArrayType) {
            Type lhsComponent = ((GenericArrayType)lhsType).getGenericComponentType();
            if (rhsType instanceof Class) {
                Class rhsClass = (Class)rhsType;
                if (rhsClass.isArray()) {
                    return ParamUtil.isAssignable(lhsComponent, rhsClass.getComponentType());
                }
            } else if (rhsType instanceof GenericArrayType) {
                Type rhsComponent = ((GenericArrayType)rhsType).getGenericComponentType();
                return ParamUtil.isAssignable(lhsComponent, rhsComponent);
            }
        }
        if (lhsType instanceof WildcardType) {
            return ParamUtil.isAssignable((WildcardType)lhsType, rhsType);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType lhsType, ParameterizedType rhsType) {
        Type[] rhsTypeArguments;
        if (lhsType.equals(rhsType)) {
            return true;
        }
        Type[] lhsTypeArguments = lhsType.getActualTypeArguments();
        if (lhsTypeArguments.length != (rhsTypeArguments = rhsType.getActualTypeArguments()).length) {
            return false;
        }
        int size = lhsTypeArguments.length;
        for (int i = 0; i < size; ++i) {
            Type lhsArg = lhsTypeArguments[i];
            Type rhsArg = rhsTypeArguments[i];
            if (lhsArg.equals(rhsArg) || lhsArg instanceof WildcardType && ParamUtil.isAssignable((WildcardType)lhsArg, rhsArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType lhsType, Type rhsType) {
        Type[] lLowerBounds;
        Type[] lUpperBounds = lhsType.getUpperBounds();
        if (lUpperBounds.length == 0) {
            lUpperBounds = new Type[]{Object.class};
        }
        if ((lLowerBounds = lhsType.getLowerBounds()).length == 0) {
            lLowerBounds = new Type[]{null};
        }
        if (rhsType instanceof WildcardType) {
            Type[] rLowerBounds;
            WildcardType rhsWcType = (WildcardType)rhsType;
            Type[] rUpperBounds = rhsWcType.getUpperBounds();
            if (rUpperBounds.length == 0) {
                rUpperBounds = new Type[]{Object.class};
            }
            if ((rLowerBounds = rhsWcType.getLowerBounds()).length == 0) {
                rLowerBounds = new Type[]{null};
            }
            for (Type lBound : lUpperBounds) {
                for (Type rBound : rUpperBounds) {
                    if (ParamUtil.isAssignableBound(lBound, rBound)) continue;
                    return false;
                }
                for (Type rBound : rLowerBounds) {
                    if (ParamUtil.isAssignableBound(lBound, rBound)) continue;
                    return false;
                }
            }
            for (Type lBound : lLowerBounds) {
                for (Type rBound : rUpperBounds) {
                    if (ParamUtil.isAssignableBound(rBound, lBound)) continue;
                    return false;
                }
                for (Type rBound : rLowerBounds) {
                    if (ParamUtil.isAssignableBound(rBound, lBound)) continue;
                    return false;
                }
            }
        } else {
            for (Type lBound : lUpperBounds) {
                if (ParamUtil.isAssignableBound(lBound, rhsType)) continue;
                return false;
            }
            for (Type lBound : lLowerBounds) {
                if (ParamUtil.isAssignableBound(rhsType, lBound)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAssignableBound(Type lhsType, Type rhsType) {
        if (rhsType == null) {
            return true;
        }
        if (lhsType == null) {
            return false;
        }
        return ParamUtil.isAssignable(lhsType, rhsType);
    }
}

