/*
 * Decompiled with CFR 0.152.
 */
package api.log.outer;

import api.log.base.ContextUtil;
import api.log.base.MonitorInfo;
import api.log.base.OutContent;
import api.log.cache.Cache;
import api.log.outer.Outer;
import api.log.socket.SessionContext;
import api.log.socket.SessionManager;
import api.log.socket.SocketHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public class WebSocketOuter
implements Outer {
    ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void out(Method method, OutContent outContent) {
        Map<String, MonitorInfo> monitorOfUser = Cache.getUsersByMethod(method);
        monitorOfUser.forEach((userId, monitorInfo) -> {
            try {
                SessionContext session = ContextUtil.getBean(SessionManager.class).getSession((String)userId);
                if (!session.getSession().isOpen()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                if (monitorInfo.isParam()) {
                    this.appendValue(sb, this.objectMapper, outContent.getParam());
                    sb.append("@@");
                }
                if (monitorInfo.isResult()) {
                    this.appendValue(sb, this.objectMapper, outContent.getResult());
                    sb.append("@@");
                }
                if (monitorInfo.isTime()) {
                    this.appendValue(sb, this.objectMapper, outContent.getTime());
                }
                ContextUtil.getBean(SocketHandler.class).sendToClient(session.getSession(), sb.toString().replaceAll("@@", "\n"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void appendValue(StringBuilder sb, ObjectMapper mapper, Object value) throws JsonProcessingException {
        if (value == null) {
            sb.append("null");
            return;
        }
        if (value.getClass().isPrimitive() || value instanceof Number || value instanceof Boolean || value instanceof Character || value instanceof String) {
            sb.append(value);
        } else if (value.getClass().isArray()) {
            sb.append(Arrays.toString((Object[])value));
        } else {
            sb.append(mapper.writeValueAsString(value));
        }
    }
}

