/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers.fieldBuilders.method;

import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLPrettify;
import graphql.annotations.processor.retrievers.fieldBuilders.Builder;
import graphql.annotations.processor.util.NamingKit;
import java.lang.reflect.Method;

public class MethodNameBuilder
implements Builder<String> {
    private Method method;

    public MethodNameBuilder(Method method) {
        this.method = method;
    }

    @Override
    public String build() {
        if (this.method.isAnnotationPresent(GraphQLPrettify.class) && !this.method.isAnnotationPresent(GraphQLName.class)) {
            return NamingKit.toGraphqlName(this.prettifyName(this.method.getName()));
        }
        GraphQLName name = this.method.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName(name == null ? this.method.getName() : name.value());
    }

    private String prettifyName(String originalName) {
        String name = originalName.replaceFirst("^(is|get|set)(.+)", "$2");
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }
}

