/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers.fieldBuilders;

import graphql.annotations.annotationTypes.GraphQLDirectives;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.fieldBuilders.Builder;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLScalarType;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DirectivesBuilder
implements Builder<GraphQLDirective[]> {
    private AnnotatedElement object;
    private ProcessingElementsContainer container;

    public DirectivesBuilder(AnnotatedElement object, ProcessingElementsContainer container) {
        this.object = object;
        this.container = container;
    }

    private GraphQLDirective transformArgs(GraphQLDirective graphQLDirective, String[] argumentValues) {
        int i;
        GraphQLDirective.Builder directiveBuilder = GraphQLDirective.newDirective((GraphQLDirective)graphQLDirective);
        directiveBuilder.clearArguments();
        List arguments = graphQLDirective.getArguments();
        if (argumentValues.length > arguments.size()) {
            throw new GraphQLAnnotationsException(String.format("Directive '%s' is supplied with more argument values than it supports", graphQLDirective.getName()), null);
        }
        for (i = 0; i < argumentValues.length; ++i) {
            this.transformArgument(argumentValues, directiveBuilder, arguments, i);
        }
        for (i = argumentValues.length; i < arguments.size(); ++i) {
            int finalI = i;
            directiveBuilder.argument(((GraphQLArgument)arguments.get(i)).transform(builder -> builder.value(((GraphQLArgument)arguments.get(finalI)).getDefaultValue())));
        }
        return directiveBuilder.build();
    }

    private void transformArgument(String[] argumentValues, GraphQLDirective.Builder directiveBuilder, List<GraphQLArgument> arguments, int i) {
        int finalI = i;
        GraphQLArgument graphQLArgument = arguments.get(i);
        directiveBuilder.argument(graphQLArgument.transform(builder -> {
            String argumentValue = argumentValues[finalI];
            if (graphQLArgument.getType() instanceof GraphQLScalarType) {
                try {
                    Object value = ((GraphQLScalarType)graphQLArgument.getType()).getCoercing().parseValue((Object)argumentValue);
                    builder.value(value);
                }
                catch (Exception e) {
                    throw new GraphQLAnnotationsException("Could not parse argument value to argument type", e);
                }
            } else {
                throw new GraphQLAnnotationsException("Directive argument type must be a scalar!", null);
            }
        }));
    }

    @Override
    public GraphQLDirective[] build() {
        GraphQLDirectives directives = this.object.getAnnotation(GraphQLDirectives.class);
        if (directives == null) {
            return new GraphQLDirective[0];
        }
        List<GraphQLDirective> graphQLDirectives = Arrays.stream(directives.value()).map(x -> {
            if (this.container.getDirectiveRegistry().containsKey(x.name())) {
                return this.transformArgs(this.container.getDirectiveRegistry().get(x.name()), x.argumentsValues());
            }
            throw new GraphQLAnnotationsException(String.format("No directive named %s is found in the directive registry", x.name()), null);
        }).collect(Collectors.toList());
        return graphQLDirectives.toArray(new GraphQLDirective[graphQLDirectives.size()]);
    }
}

