/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.handler;

import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.AbstractResponseGenerator;
import io.github.ibuildthecloud.model.impl.VersionImpl;
import io.github.ibuildthecloud.url.UrlBuilder;
import java.io.IOException;
import java.net.URL;
import java.util.TreeMap;

public class VersionHandler
extends AbstractResponseGenerator {
    @Override
    protected void generate(ApiRequest request) throws IOException {
        if (request.getType() == null && request.getApiVersion() != null) {
            UrlBuilder urlBuilder = ApiContext.getUrlBuilder();
            SchemaFactory schemaFactory = ApiContext.getSchemaFactory();
            VersionImpl version = new VersionImpl(request.getApiVersion());
            TreeMap<String, URL> links = new TreeMap<String, URL>();
            version.setLinks(links);
            links.put("self", urlBuilder.current());
            for (Schema schema : schemaFactory.listSchemas()) {
                URL link;
                if (!schema.getCollectionMethods().contains(Schema.Method.GET.toString()) || (link = urlBuilder.resourceCollection(schema.getId())) == null) continue;
                links.put(schema.getPluralName(), link);
            }
            request.setResponseObject(version);
        }
    }
}

