/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.response;

import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.response.HtmlTemplate;
import io.github.ibuildthecloud.gdapi.response.JsonResponseWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;

public class HtmlResponseWriter
extends JsonResponseWriter {
    HtmlTemplate htmlTemplate;

    @Override
    protected String getContentType() {
        return "text/html; charset=utf-8";
    }

    @Override
    protected String getResponseFormat() {
        return "html";
    }

    @Override
    protected void writeJson(OutputStream os, Object responseObject, ApiRequest request) throws IOException {
        os.write(this.htmlTemplate.getHeader(request, responseObject));
        super.writeJson(os, responseObject, request);
        os.write(this.htmlTemplate.getFooter(request, responseObject));
    }

    public HtmlTemplate getHtmlTemplate() {
        return this.htmlTemplate;
    }

    @Inject
    public void setHtmlTemplate(HtmlTemplate htmlTemplate) {
        this.htmlTemplate = htmlTemplate;
    }
}

