/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request;

import io.github.ibuildthecloud.gdapi.condition.Condition;
import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.model.Include;
import io.github.ibuildthecloud.gdapi.model.Pagination;
import io.github.ibuildthecloud.gdapi.model.Sort;
import io.github.ibuildthecloud.gdapi.server.model.ApiServletContext;
import io.github.ibuildthecloud.gdapi.url.UrlBuilder;
import io.github.ibuildthecloud.gdapi.util.ProxyUtils;
import io.github.ibuildthecloud.gdapi.util.RequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ApiRequest {
    Locale locale;
    String type;
    String id;
    String link;
    String action;
    String method;
    String clientIp;
    String queryString;
    String staticResourceBase = "static";
    boolean committed = false;
    int responseCode = 200;
    ApiServletContext apiServletContext;
    Object responseObject;
    Object requestObject;
    Object requestBodyObject;
    Map<String, Object> requestParams;
    String requestUrl;
    String requestVersion;
    String apiVersion;
    String responseUrlBase;
    String responseFormat;
    String responseContentType;
    long startTime = System.currentTimeMillis();
    UrlBuilder urlBuilder;
    Map<String, List<Condition>> conditions = new LinkedHashMap<String, List<Condition>>();
    Sort sort;
    Pagination pagination;
    Include include;
    Map<Object, Object> attributes = new HashMap<Object, Object>();
    Map<String, String> options = new HashMap<String, String>();
    SchemaFactory schemaFactory;
    Map<String, Object> createDefaults = new HashMap<String, Object>();
    List<Throwable> exceptions = new ArrayList<Throwable>();

    public ApiRequest(ApiRequest request) {
        this.locale = request.getLocale();
        this.type = request.getType();
        this.id = request.getId();
        this.link = request.getLink();
        this.action = request.getAction();
        this.method = request.getMethod();
        this.clientIp = request.getClientIp();
        this.queryString = request.getQueryString();
        this.committed = request.isCommitted();
        this.responseCode = request.getResponseCode();
        this.requestObject = request.getRequestObject();
        this.requestBodyObject = request.getRequestBodyObject();
        this.requestParams = request.getRequestParams();
        this.requestUrl = request.getRequestUrl();
        this.requestVersion = request.getRequestVersion();
        this.apiVersion = request.getApiVersion();
        this.responseUrlBase = request.getResponseUrlBase();
        this.responseFormat = request.getResponseFormat();
        this.responseContentType = request.getResponseContentType();
        this.startTime = request.getStartTime();
        this.urlBuilder = request.getUrlBuilder();
        this.conditions = request.getConditions();
        this.sort = request.getSort();
        this.pagination = request.getPagination();
        this.include = request.getInclude();
        this.schemaFactory = request.getSchemaFactory();
        this.createDefaults = request.getCreateDefaults();
        this.exceptions = request.getExceptions();
        this.options = request.getOptions();
        this.staticResourceBase = request.getStaticResourceBase();
    }

    public ApiRequest(String apiVersion, ApiServletContext requestServletContext, SchemaFactory schemaFactory) {
        this.apiVersion = apiVersion;
        this.apiServletContext = requestServletContext;
        this.locale = requestServletContext.getRequest().getLocale();
        this.schemaFactory = schemaFactory;
    }

    public InputStream getInputStream() throws IOException {
        if (this.apiServletContext == null) {
            return null;
        }
        return this.apiServletContext.getRequest().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Response is commited");
        }
        this.commit();
        this.committed = true;
        return this.apiServletContext.getResponse().getOutputStream();
    }

    public <T> T proxyRequestObject(Class<T> type) {
        Map<String, Object> map = RequestUtils.toMap(this.requestObject);
        return ProxyUtils.proxy(map, type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public Object getResponseObject() {
        return this.responseObject;
    }

    public void setResponseObject(Object responseObject) {
        this.responseObject = responseObject;
    }

    public Object getRequestObject() {
        return this.requestObject;
    }

    public void setRequestObject(Object requestObject) {
        this.requestObject = requestObject;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Map<String, Object> getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(Map<String, Object> requestParams) {
        this.requestParams = requestParams;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getResponseUrlBase() {
        return this.responseUrlBase;
    }

    public void setResponseUrlBase(String responseUrlBase) {
        this.responseUrlBase = responseUrlBase;
    }

    public String getRequestVersion() {
        return this.requestVersion;
    }

    public void setRequestVersion(String requestVersion) {
        this.requestVersion = requestVersion;
    }

    public String getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(String responseType) {
        this.responseFormat = responseType;
    }

    public void setResponseContentType(String contentType) {
        this.responseContentType = contentType;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public ApiServletContext getServletContext() {
        return this.apiServletContext;
    }

    public void setRequestServletContext(ApiServletContext requestServletContext) {
        this.apiServletContext = requestServletContext;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Object getRequestBodyObject() {
        return this.requestBodyObject;
    }

    public void setRequestBodyObject(Object requestBodyObject) {
        this.requestBodyObject = requestBodyObject;
    }

    public void commit() {
        if (!this.committed) {
            if (this.responseContentType != null) {
                this.apiServletContext.getResponse().setHeader("Content-Type", this.responseContentType);
            }
            this.apiServletContext.getResponse().setStatus(this.responseCode);
            this.committed = true;
        }
    }

    public UrlBuilder getUrlBuilder() {
        return this.urlBuilder;
    }

    public void setUrlBuilder(UrlBuilder urlWriter) {
        this.urlBuilder = urlWriter;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Map<String, List<Condition>> getConditions() {
        return this.conditions;
    }

    public void setConditions(Map<String, List<Condition>> conditions) {
        this.conditions = conditions;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Include getInclude() {
        return this.include;
    }

    public void setInclude(Include include) {
        this.include = include;
    }

    public Object getAttribute(Object object) {
        return this.attributes.get(object);
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public Map<String, Object> getCreateDefaults() {
        return this.createDefaults;
    }

    public void setCreateDefaults(Map<String, Object> createDefaults) {
        this.createDefaults = createDefaults;
    }

    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getStaticResourceBase() {
        return this.staticResourceBase;
    }

    public void setStaticResourceBase(String staticResourceBase) {
        this.staticResourceBase = staticResourceBase;
    }
}

