/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.beecomb.client;

import io.github.icodegarden.beecomb.client.BeeCombClient;
import io.github.icodegarden.beecomb.client.ClientProperties;
import io.github.icodegarden.beecomb.client.pojo.query.JobQuery;
import io.github.icodegarden.beecomb.client.pojo.transfer.CreateJobDTO;
import io.github.icodegarden.beecomb.client.pojo.transfer.UpdateJobDTO;
import io.github.icodegarden.beecomb.client.pojo.view.CreateJobVO;
import io.github.icodegarden.beecomb.client.pojo.view.DeleteJobVO;
import io.github.icodegarden.beecomb.client.pojo.view.JobVO;
import io.github.icodegarden.beecomb.client.pojo.view.PageVO;
import io.github.icodegarden.beecomb.client.pojo.view.UpdateJobVO;
import io.github.icodegarden.commons.exchange.Exchanger;
import io.github.icodegarden.commons.exchange.Protocol;
import io.github.icodegarden.commons.exchange.ShardExchangeResult;
import io.github.icodegarden.commons.exchange.exception.ExchangeException;
import io.github.icodegarden.commons.exchange.http.HttpEntity;
import io.github.icodegarden.commons.exchange.http.HttpHeaders;
import io.github.icodegarden.commons.exchange.http.HttpMethod;
import io.github.icodegarden.commons.exchange.http.SimpleRestHttpProtocol;
import io.github.icodegarden.commons.lang.tuple.Tuple2;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;

public abstract class AbstractBeeCombClient
implements BeeCombClient {
    protected static final List<String> EXTRACT_HEADERS = Arrays.asList("X-Message");
    protected final ClientProperties clientProperties;

    public AbstractBeeCombClient(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    protected Protocol buildProtocol(String path, HttpMethod method, Object responseType) {
        Tuple2<String, String> httpToken = this.clientProperties.getAuthentication().httpToken();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set((String)httpToken.getT1(), (String)httpToken.getT2());
        SimpleRestHttpProtocol httpProtocol = null;
        if (responseType instanceof Class) {
            httpProtocol = new SimpleRestHttpProtocol(path, method, httpHeaders, (Class)responseType);
        } else if (responseType instanceof ParameterizedTypeReference) {
            httpProtocol = new SimpleRestHttpProtocol(path, method, httpHeaders, (ParameterizedTypeReference)responseType);
        } else {
            throw new IllegalArgumentException("responseType must be Class or ParameterizedTypeReference");
        }
        httpProtocol.setConnectTimeout(this.clientProperties.getExchange().getConnectTimeout());
        httpProtocol.setReadTimeout(this.clientProperties.getExchange().getReadTimeout());
        httpProtocol.setExtractHeadersOn4xx(EXTRACT_HEADERS);
        httpProtocol.setExtractHeadersOn5xx(EXTRACT_HEADERS);
        return httpProtocol;
    }

    protected abstract String pathPrefix();

    protected abstract Exchanger<ShardExchangeResult> buildExchanger(Protocol var1);

    @Override
    public CreateJobVO createJob(CreateJobDTO job) throws ExchangeException {
        return this.doCreateJob(false, job);
    }

    @Override
    public CreateJobVO createJobAsync(CreateJobDTO job) throws ExchangeException {
        return this.doCreateJob(true, job);
    }

    private CreateJobVO doCreateJob(boolean async, CreateJobDTO job) throws ExchangeException {
        Protocol protocol = this.buildProtocol(this.pathPrefix() + "/openapi/v1/jobs?async=" + async, HttpMethod.POST, CreateJobVO.class);
        Exchanger<ShardExchangeResult> exchanger = this.buildExchanger(protocol);
        ShardExchangeResult shardExchangeResult = (ShardExchangeResult)exchanger.exchange((Object)job, Integer.MAX_VALUE);
        HttpEntity httpEntity = (HttpEntity)shardExchangeResult.response();
        return (CreateJobVO)httpEntity.getBody();
    }

    @Override
    public PageVO<JobVO> pageJobs(JobQuery query) throws ExchangeException {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.pathPrefix()).append("/openapi/v1/jobs?page=").append(query.getPage()).append("&size=" + query.getSize());
        if (query.getEnd() != null) {
            sb.append("&end=").append(query.getEnd());
        }
        if (query.getNameLike() != null) {
            sb.append("&nameLike=").append(query.getNameLike());
        }
        if (query.getType() != null) {
            sb.append("&type=").append(query.getType().name());
        }
        if (query.getUuid() != null) {
            sb.append("&uuid=").append(query.getUuid());
        }
        if (query.getExtParams() != null) {
            query.getExtParams().entrySet().forEach(entry -> sb.append("&").append((String)entry.getKey()).append("=").append((String)entry.getValue()));
        }
        if (query.getWith() != null) {
            JobQuery.JobWith with = query.getWith();
            if (with.isWithCreatedAt()) {
                sb.append("&withCreatedAt=").append(with.isWithCreatedAt());
            }
            if (with.isWithCreatedBy()) {
                sb.append("&withCreatedBy=").append(with.isWithCreatedBy());
            }
            if (with.isWithDelay()) {
                sb.append("&withDelay=").append(with.isWithDelay());
            }
            if (with.isWithDesc()) {
                sb.append("&withDesc=").append(with.isWithDesc());
            }
            if (with.isWithLastExecuteExecutor()) {
                sb.append("&withLastExecuteExecutor=").append(with.isWithLastExecuteExecutor());
            }
            if (with.isWithLastExecuteReturns()) {
                sb.append("&withLastExecuteReturns=").append(with.isWithLastExecuteReturns());
            }
            if (with.isWithLastExecuteSuccess()) {
                sb.append("&withLastExecuteSuccess=").append(with.isWithLastExecuteSuccess());
            }
            if (with.isWithLastTrigResult()) {
                sb.append("&withLastTrigResult=").append(with.isWithLastTrigResult());
            }
            if (with.isWithParams()) {
                sb.append("&withParams=").append(with.isWithParams());
            }
            if (with.isWithQueuedAt()) {
                sb.append("&withQueuedAt=").append(with.isWithQueuedAt());
            }
            if (with.isWithQueuedAtInstance()) {
                sb.append("&withQueuedAtInstance=").append(with.isWithQueuedAtInstance());
            }
            if (with.isWithSchedule()) {
                sb.append("&withSchedule=").append(with.isWithSchedule());
            }
        }
        Protocol protocol = this.buildProtocol(sb.toString(), HttpMethod.GET, new ParameterizedTypeReference<List<JobVO>>(){});
        Exchanger<ShardExchangeResult> exchanger = this.buildExchanger(protocol);
        ShardExchangeResult shardExchangeResult = (ShardExchangeResult)exchanger.exchange(null, Integer.MAX_VALUE);
        HttpEntity httpEntity = (HttpEntity)shardExchangeResult.response();
        HttpHeaders headers = httpEntity.getHeaders();
        List list = (List)httpEntity.getBody();
        String totalPageStr = headers.getFirst("X-Total-Pages");
        String totalCountStr = headers.getFirst("X-Total-Count");
        return new PageVO<JobVO>(query.getPage(), query.getSize(), totalPageStr != null ? Integer.parseInt(totalPageStr) : 0, totalCountStr != null ? Long.parseLong(totalCountStr) : 0L, list);
    }

    @Override
    public JobVO getJob(Long jobId) throws ExchangeException {
        Protocol protocol = this.buildProtocol(this.pathPrefix() + "/openapi/v1/jobs/" + jobId, HttpMethod.GET, JobVO.class);
        Exchanger<ShardExchangeResult> exchanger = this.buildExchanger(protocol);
        ShardExchangeResult shardExchangeResult = (ShardExchangeResult)exchanger.exchange(null, Integer.MAX_VALUE);
        HttpEntity httpEntity = (HttpEntity)shardExchangeResult.response();
        return (JobVO)httpEntity.getBody();
    }

    @Override
    public JobVO getJobByUUID(String uuid) throws ExchangeException {
        Protocol protocol = this.buildProtocol(this.pathPrefix() + "/openapi/v1/jobs/uuid/" + uuid, HttpMethod.GET, JobVO.class);
        Exchanger<ShardExchangeResult> exchanger = this.buildExchanger(protocol);
        ShardExchangeResult shardExchangeResult = (ShardExchangeResult)exchanger.exchange(null, Integer.MAX_VALUE);
        HttpEntity httpEntity = (HttpEntity)shardExchangeResult.response();
        return (JobVO)httpEntity.getBody();
    }

    @Override
    public UpdateJobVO updateJob(UpdateJobDTO update) throws ExchangeException {
        Protocol protocol = this.buildProtocol(this.pathPrefix() + "/openapi/v1/jobs", HttpMethod.PUT, UpdateJobVO.class);
        Exchanger<ShardExchangeResult> exchanger = this.buildExchanger(protocol);
        ShardExchangeResult shardExchangeResult = (ShardExchangeResult)exchanger.exchange((Object)update, Integer.MAX_VALUE);
        HttpEntity httpEntity = (HttpEntity)shardExchangeResult.response();
        return (UpdateJobVO)httpEntity.getBody();
    }

    @Override
    public DeleteJobVO deleteJob(Long jobId) throws ExchangeException {
        Protocol protocol = this.buildProtocol(this.pathPrefix() + "/openapi/v1/jobs/" + jobId, HttpMethod.DELETE, DeleteJobVO.class);
        Exchanger<ShardExchangeResult> exchanger = this.buildExchanger(protocol);
        ShardExchangeResult shardExchangeResult = (ShardExchangeResult)exchanger.exchange(null, Integer.MAX_VALUE);
        HttpEntity httpEntity = (HttpEntity)shardExchangeResult.response();
        return (DeleteJobVO)httpEntity.getBody();
    }
}

