/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.beecomb.client;

import io.github.icodegarden.beecomb.client.AbstractBeeCombClient;
import io.github.icodegarden.beecomb.client.UrlsClientProperties;
import io.github.icodegarden.beecomb.common.enums.NodeRole;
import io.github.icodegarden.commons.exchange.CandidatesSwitchableExchanger;
import io.github.icodegarden.commons.exchange.Exchanger;
import io.github.icodegarden.commons.exchange.Protocol;
import io.github.icodegarden.commons.exchange.ShardExchangeResult;
import io.github.icodegarden.commons.exchange.loadbalance.DefaultMetricsInstance;
import io.github.icodegarden.commons.exchange.loadbalance.MetricsInstance;
import io.github.icodegarden.commons.lang.registry.DefaultRegisteredInstance;
import io.github.icodegarden.commons.lang.registry.RegisteredInstance;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;

public class UrlsBeeCombClient
extends AbstractBeeCombClient {
    private String pathPrefix = "";
    private List<MetricsInstance> candidates;

    public UrlsBeeCombClient(UrlsClientProperties clientProperties) {
        super(clientProperties);
        this.candidates = clientProperties.getUrls().stream().map(address -> {
            try {
                URL url = new URL((String)address);
                String protocol = url.getProtocol();
                String host = url.getHost();
                int port = url.getPort();
                String path = url.getPath();
                DefaultRegisteredInstance registeredInstance = new DefaultRegisteredInstance(NodeRole.Master.getRoleName(), "unknown", protocol, host, port);
                DefaultMetricsInstance metricsInstance = new DefaultMetricsInstance((RegisteredInstance)registeredInstance, null);
                String string = this.pathPrefix = path != null ? path : this.pathPrefix;
                if (this.pathPrefix.endsWith("/")) {
                    this.pathPrefix.substring(0, this.pathPrefix.length() - 1);
                }
                return metricsInstance;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("ex on init client", e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    protected String pathPrefix() {
        return this.pathPrefix;
    }

    @Override
    protected Exchanger<ShardExchangeResult> buildExchanger(Protocol protocol) {
        return new CandidatesSwitchableExchanger(protocol, this.candidates, false);
    }

    @Override
    public void close() throws IOException {
    }
}

