/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.beecomb.client.nacos;

import io.github.icodegarden.beecomb.client.AbstractBeeCombClient;
import io.github.icodegarden.beecomb.client.nacos.NacosClientProperties;
import io.github.icodegarden.beecomb.common.enums.NodeRole;
import io.github.icodegarden.nutrient.exchange.CandidatesSwitchableLoadBalanceExchanger;
import io.github.icodegarden.nutrient.exchange.Exchanger;
import io.github.icodegarden.nutrient.exchange.Protocol;
import io.github.icodegarden.nutrient.exchange.ShardExchangeResult;
import io.github.icodegarden.nutrient.exchange.loadbalance.InstanceLoadBalance;
import io.github.icodegarden.nutrient.exchange.loadbalance.RoundRobinInstanceLoadBalance;
import io.github.icodegarden.nutrient.lang.metricsregistry.InstanceDiscovery;
import io.github.icodegarden.nutrient.lang.metricsregistry.RegisteredInstance;
import io.github.icodegarden.nutrient.nacos.metricsregistry.DirectSearchNacosInstanceDiscovery;
import java.io.IOException;

public class NacosBeeCombClient
extends AbstractBeeCombClient {
    private final NacosClientProperties clientProperties;
    private final InstanceDiscovery<? extends RegisteredInstance> instanceDiscovery;
    private final InstanceLoadBalance instanceLoadBalance;

    public NacosBeeCombClient(NacosClientProperties clientProperties) {
        super(clientProperties);
        this.clientProperties = clientProperties;
        this.instanceDiscovery = new DirectSearchNacosInstanceDiscovery(clientProperties.getNacos());
        this.instanceLoadBalance = new RoundRobinInstanceLoadBalance(this.instanceDiscovery);
    }

    @Override
    protected String pathPrefix() {
        return "";
    }

    @Override
    protected Exchanger<ShardExchangeResult> buildExchanger(Protocol protocol) {
        return new CandidatesSwitchableLoadBalanceExchanger(protocol, this.instanceLoadBalance, NodeRole.Master.getRoleName(), this.clientProperties.getLoadBalance().getMaxCandidates());
    }

    @Override
    public void close() throws IOException {
        this.instanceDiscovery.close();
    }
}

