/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.core;

import net.infobank.client.core.Util;

public class HttpConfig {
    private static final String DEFAULT_BASE_URL = "https://omni.ibapi.kr";
    private static final String SDK_VERSION = "1.0.0";
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String USER_AGENT = String.format("OmniApi Sdk Java %s java/%s", "1.0.0", JAVA_VERSION);
    private final String baseUrl;

    private HttpConfig(Builder builder) {
        this.baseUrl = builder.baseUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUserAgent() {
        return USER_AGENT;
    }

    public boolean isDefaultBaseUrl() {
        return DEFAULT_BASE_URL.equals(this.baseUrl);
    }

    public String getVersionedApiBaseUrl(String version) {
        return this.appendVersionToUrl(this.baseUrl, version);
    }

    private String appendVersionToUrl(String url, String version) {
        return url + "/" + version;
    }

    public static HttpConfig defaultConfig() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String baseUrl = "https://omni.ibapi.kr";

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = Util.sanitizeUri(baseUrl);
            return this;
        }

        public HttpConfig build() {
            return new HttpConfig(this);
        }
    }
}

