/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnsupportedMessageException;
import net.infobank.client.data.code.MessageType;
import net.infobank.client.data.code.ServiceType;
import net.infobank.client.data.request.kakao.attachment.Attachment;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class AlimtalkMessage {
    final AlimtalkData alimtalk;

    @JsonProperty(value="alimtalk")
    public AlimtalkData getAlimtalk() {
        return this.alimtalk;
    }

    AlimtalkMessage(Builder builder) {
        this.alimtalk = new AlimtalkData(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String senderKey;
        MessageType msgType;
        String templateCode;
        String text;
        String title;
        Attachment attachment;
        Object supplement;
        String price;
        String currencyType;

        public Builder senderKey(String senderKey) {
            this.senderKey = senderKey;
            return this;
        }

        public Builder msgType(MessageType msgType) {
            this.msgType = msgType;
            return this;
        }

        public Builder templateCode(String templateCode) {
            this.templateCode = templateCode;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public Builder supplement(Object supplement) {
            this.supplement = supplement;
            return this;
        }

        public Builder price(String price) {
            this.price = price;
            return this;
        }

        public Builder currencyType(String currencyType) {
            this.currencyType = currencyType;
            return this;
        }

        public AlimtalkMessage build() {
            if (this.senderKey == null) {
                throw new MissingFieldException("senderKey field must not be null");
            }
            if (this.msgType == null) {
                throw new MissingFieldException("msgType field must not be null");
            }
            if (this.templateCode == null) {
                throw new MissingFieldException("templateCode field must not be null");
            }
            if (this.text == null) {
                throw new MissingFieldException("text field must not be null");
            }
            if (!ServiceType.ALIMTALK.supports(this.msgType)) {
                throw new UnsupportedMessageException("This msgType is not supported by the ALIMTALK");
            }
            return new AlimtalkMessage(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private class AlimtalkData {
        String senderKey;
        String msgType;
        String templateCode;
        String text;
        String title;
        Attachment attachment;
        Object supplement;
        String price;
        String currencyType;

        AlimtalkData(Builder builder) {
            this.senderKey = builder.senderKey;
            this.msgType = builder.msgType.toString();
            this.templateCode = builder.templateCode;
            this.text = builder.text;
            this.title = builder.title;
            this.attachment = builder.attachment;
            this.supplement = builder.supplement;
            this.price = builder.price;
            this.currencyType = builder.currencyType;
        }

        @JsonProperty(value="senderKey")
        public String getSenderKey() {
            return this.senderKey;
        }

        @JsonProperty(value="msgType")
        public String getMsgType() {
            return this.msgType;
        }

        @JsonProperty(value="templateCode")
        public String getTemplateCode() {
            return this.templateCode;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="title")
        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="attachment")
        public Attachment getAttachment() {
            return this.attachment;
        }

        @JsonProperty(value="supplement")
        public Object getSupplement() {
            return this.supplement;
        }

        @JsonProperty(value="price")
        public String getPrice() {
            return this.price;
        }

        @JsonProperty(value="currencyType")
        public String getCurrencyType() {
            return this.currencyType;
        }
    }
}

