/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.core;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import net.infobank.client.core.HttpConfig;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class Util {
    public static HttpClient createHttpClient(HttpConfig httpConfig) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(100);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultConnectionConfig(ConnectionConfig.custom().setCharset(StandardCharsets.UTF_8).build());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
        RequestConfig requestConfig = RequestConfig.custom().build();
        return HttpClientBuilder.create().setConnectionManager(connectionManager).setUserAgent(httpConfig.getUserAgent()).setDefaultRequestConfig(requestConfig).useSystemProperties().build();
    }

    public static String sanitizeUri(String url) {
        if (url != null && url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String logResponse(HttpResponse response) throws IOException {
        Objects.requireNonNull(response, "Response shouldn't be null");
        StringBuilder log = new StringBuilder();
        String responseBody = response.getEntity() != null ? EntityUtils.toString(response.getEntity()) : "";
        int statusCode = response.getStatusLine().getStatusCode();
        String statusLine = response.getStatusLine().getReasonPhrase();
        log.append("status_code: ").append(statusCode).append(", ").append("status_line: ").append(statusLine).append(", ").append(" body: ").append(responseBody);
        response.setEntity(new StringEntity(responseBody, ContentType.get(response.getEntity())));
        return log.toString();
    }
}

