/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.core.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import java.util.Objects;
import net.infobank.client.core.exception.ClientException;
import net.infobank.client.core.exception.UnexpectedException;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class ApiResponseException
extends ClientException {
    protected String code;
    protected String result;
    @JsonIgnore
    protected int statusCode;
    @JsonIgnore
    protected String reasonPhrase;

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="result")
    public String getResult() {
        return this.result;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    @Override
    @JsonIgnore
    public String getMessage() {
        if (this.statusCode > 0) {
            String message = "HTTP Code:" + this.statusCode;
            if (this.reasonPhrase != null) {
                message = message + "(" + this.reasonPhrase + ")";
            }
            if (this.code != null) {
                message = message + ", API Code: " + this.code;
            }
            if (this.result != null) {
                message = message + "(" + this.result + ")";
            }
            return message;
        }
        return super.getMessage();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiResponseException response = (ApiResponseException)o;
        return this.statusCode == response.statusCode && Objects.equals(this.code, response.code) && Objects.equals(this.result, response.result);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.result, this.statusCode);
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setAnnotationIntrospector(new IgnoreInheritedIntrospector());
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new UnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName(), e);
        }
    }

    protected static <E extends ApiResponseException> E fromJson(Class<E> clazz, String json) {
        if (json == null || json.length() < 2) {
            try {
                return (E)((ApiResponseException)clazz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new UnexpectedException(ex);
            }
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (E)((ApiResponseException)mapper.readValue(json, clazz));
        }
        catch (IOException ex) {
            throw new UnexpectedException("response:" + json + " Failed to produce " + clazz.getSimpleName() + " from json.", ex);
        }
    }

    protected static <E extends ApiResponseException> E fromHttpResponse(Class<E> clazz, HttpResponse response) throws IOException {
        String json = "";
        if (response.getEntity().getContentType().getValue().startsWith("application/json")) {
            json = EntityUtils.toString(response.getEntity());
        }
        E crx = ApiResponseException.fromJson(clazz, json);
        ((ApiResponseException)crx).statusCode = response.getStatusLine().getStatusCode();
        ((ApiResponseException)crx).reasonPhrase = response.getStatusLine().getReasonPhrase();
        return crx;
    }

    private static class IgnoreInheritedIntrospector
    extends JacksonAnnotationIntrospector {
        private IgnoreInheritedIntrospector() {
        }

        @Override
        public boolean hasIgnoreMarker(AnnotatedMember m) {
            return m.getDeclaringClass().equals(Throwable.class) || super.hasIgnoreMarker(m);
        }
    }
}

