/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnsupportedMessageException;
import net.infobank.client.data.code.MessageType;
import net.infobank.client.data.code.SendType;
import net.infobank.client.data.code.ServiceType;
import net.infobank.client.data.request.kakao.Carousel;
import net.infobank.client.data.request.kakao.attachment.Attachment;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class BrandMessage {
    final BrandMessageData brandMessage;

    @JsonProperty(value="brandmessage")
    public BrandMessageData getBrandMessage() {
        return this.brandMessage;
    }

    BrandMessage(Builder builder) {
        this.brandMessage = new BrandMessageData(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String senderKey;
        SendType sendType;
        MessageType msgType;
        String text;
        Carousel carousel;
        Attachment attachment;
        String header;
        String targeting;
        String templateCode;
        String addtionalContent;
        String groupTagKey;
        String adult;
        String pushAlarm;
        String adFlag;
        JsonNode messageVariable;
        JsonNode buttonVariable;
        JsonNode couponVariable;
        JsonNode imageVariable;
        JsonNode videoVariable;
        JsonNode commerceVariable;
        JsonNode carouselVariable;
        String originCID;
        String unsubscribePhoneNumber;
        String unsubscribeAuthNumber;

        public Builder senderKey(String senderKey) {
            this.senderKey = senderKey;
            return this;
        }

        public Builder sendType(SendType sendType) {
            this.sendType = sendType;
            return this;
        }

        public Builder msgType(MessageType msgType) {
            this.msgType = msgType;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder carousel(Carousel carousel) {
            this.carousel = carousel;
            return this;
        }

        public Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder targeting(String targeting) {
            this.targeting = targeting;
            return this;
        }

        public Builder templateCode(String templateCode) {
            this.templateCode = templateCode;
            return this;
        }

        public Builder addtionalContent(String addtionalContent) {
            this.addtionalContent = addtionalContent;
            return this;
        }

        public Builder groupTagKey(String groupTagKey) {
            this.groupTagKey = groupTagKey;
            return this;
        }

        public Builder adult(String adult) {
            this.adult = adult;
            return this;
        }

        public Builder pushAlarm(String pushAlarm) {
            this.pushAlarm = pushAlarm;
            return this;
        }

        public Builder adFlag(String adFlag) {
            this.adFlag = adFlag;
            return this;
        }

        public Builder messageVariable(JsonNode messageVariable) {
            this.messageVariable = messageVariable;
            return this;
        }

        public Builder buttonVariable(JsonNode buttonVariable) {
            this.buttonVariable = buttonVariable;
            return this;
        }

        public Builder couponVariable(JsonNode couponVariable) {
            this.couponVariable = couponVariable;
            return this;
        }

        public Builder imageVariable(JsonNode imageVariable) {
            this.imageVariable = imageVariable;
            return this;
        }

        public Builder videoVariable(JsonNode videoVariable) {
            this.videoVariable = videoVariable;
            return this;
        }

        public Builder commerceVariable(JsonNode commerceVariable) {
            this.commerceVariable = commerceVariable;
            return this;
        }

        public Builder carouselVariable(JsonNode carouselVariable) {
            this.carouselVariable = carouselVariable;
            return this;
        }

        public Builder originCID(String originCID) {
            this.originCID = originCID;
            return this;
        }

        public Builder unsubscribePhoneNumber(String unsubscribePhoneNumber) {
            this.unsubscribePhoneNumber = unsubscribePhoneNumber;
            return this;
        }

        public Builder unsubscribeAuthNumber(String unsubscribeAuthNumber) {
            this.unsubscribeAuthNumber = unsubscribeAuthNumber;
            return this;
        }

        public BrandMessage build() {
            if (this.senderKey == null) {
                throw new MissingFieldException("senderKey field must not be null");
            }
            if (this.sendType == null) {
                throw new MissingFieldException("sendType field must not be null");
            }
            if (this.msgType == null) {
                throw new MissingFieldException("msgType field must not be null");
            }
            if (!ServiceType.FRIENDTALK.supports(this.msgType)) {
                throw new UnsupportedMessageException("This msgType is not supported by the FRIENDTALK");
            }
            return new BrandMessage(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private class BrandMessageData {
        String senderKey;
        SendType sendType;
        MessageType msgType;
        String text;
        Carousel carousel;
        Attachment attachment;
        String header;
        String targeting;
        String templateCode;
        String addtionalContent;
        String groupTagKey;
        String adult;
        String pushAlarm;
        String adFlag;
        JsonNode messageVariable;
        JsonNode buttonVariable;
        JsonNode couponVariable;
        JsonNode imageVariable;
        JsonNode videoVariable;
        JsonNode commerceVariable;
        JsonNode carouselVariable;
        String originCID;
        String unsubscribePhoneNumber;
        String unsubscribeAuthNumber;

        BrandMessageData(Builder builder) {
            this.senderKey = builder.senderKey;
            this.sendType = builder.sendType;
            this.msgType = builder.msgType;
            this.text = builder.text;
            this.carousel = builder.carousel;
            this.attachment = builder.attachment;
            this.header = builder.header;
            this.targeting = builder.targeting;
            this.templateCode = builder.templateCode;
            this.addtionalContent = builder.addtionalContent;
            this.groupTagKey = builder.groupTagKey;
            this.adult = builder.adult;
            this.pushAlarm = builder.pushAlarm;
            this.adFlag = builder.adFlag;
            this.messageVariable = builder.messageVariable;
            this.buttonVariable = builder.buttonVariable;
            this.couponVariable = builder.couponVariable;
            this.imageVariable = builder.imageVariable;
            this.videoVariable = builder.videoVariable;
            this.commerceVariable = builder.commerceVariable;
            this.carouselVariable = builder.carouselVariable;
            this.originCID = builder.originCID;
            this.unsubscribePhoneNumber = builder.unsubscribePhoneNumber;
            this.unsubscribeAuthNumber = builder.unsubscribeAuthNumber;
        }

        @JsonProperty(value="senderKey")
        public String getSenderKey() {
            return this.senderKey;
        }

        @JsonProperty(value="sendType")
        public SendType getSendType() {
            return this.sendType;
        }

        @JsonProperty(value="msgType")
        public MessageType getMsgType() {
            return this.msgType;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="carousel")
        public Carousel getCarousel() {
            return this.carousel;
        }

        @JsonProperty(value="attachment")
        public Attachment getAttachment() {
            return this.attachment;
        }

        @JsonProperty(value="header")
        public String getHeader() {
            return this.header;
        }

        @JsonProperty(value="targeting")
        public String getTargeting() {
            return this.targeting;
        }

        @JsonProperty(value="templateCode")
        public String getTemplateCode() {
            return this.templateCode;
        }

        @JsonProperty(value="addtionalContent")
        public String getAddtionalContent() {
            return this.addtionalContent;
        }

        @JsonProperty(value="groupTagKey")
        public String getGroupTagKey() {
            return this.groupTagKey;
        }

        @JsonProperty(value="adult")
        public String getAdult() {
            return this.adult;
        }

        @JsonProperty(value="pushAlarm")
        public String getPushAlarm() {
            return this.pushAlarm;
        }

        @JsonProperty(value="adFlag")
        public String getAdFlag() {
            return this.adFlag;
        }

        @JsonProperty(value="messageVariable")
        public JsonNode getMessageVariable() {
            return this.messageVariable;
        }

        @JsonProperty(value="buttonVariable")
        public JsonNode getButtonVariable() {
            return this.buttonVariable;
        }

        @JsonProperty(value="couponVariable")
        public JsonNode getCouponVariable() {
            return this.couponVariable;
        }

        @JsonProperty(value="imageVariable")
        public JsonNode getImageVariable() {
            return this.imageVariable;
        }

        @JsonProperty(value="videoVariable")
        public JsonNode getVideoVariable() {
            return this.videoVariable;
        }

        @JsonProperty(value="commerceVariable")
        public JsonNode getCommerceVariable() {
            return this.commerceVariable;
        }

        @JsonProperty(value="carouselVariable")
        public JsonNode getCarouselVariable() {
            return this.carouselVariable;
        }

        @JsonProperty(value="originCID")
        public String getOriginCID() {
            return this.originCID;
        }

        @JsonProperty(value="unsubscribePhoneNumber")
        public String getUnsubscribePhoneNumber() {
            return this.unsubscribePhoneNumber;
        }

        @JsonProperty(value="unsubscribeAuthNumber")
        public String getUnsubscribeAuthNumber() {
            return this.unsubscribeAuthNumber;
        }
    }
}

