/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.rcs.content;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.infobank.client.data.request.rcs.button.Button;
import net.infobank.client.data.request.rcs.content.Standalone;
import net.infobank.client.data.request.rcs.content.SubContent;
import net.infobank.client.data.request.rcs.content.Template;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Card {
    private String text;
    private String title;
    private String media;
    private String mediaUrl;
    private String description;
    private HashMap<String, String> userJson;
    private List<Button> button;
    private List<SubContent> subContent;

    Card(Standalone.Builder builder) {
        this.text = builder.text;
        this.title = builder.title;
        this.media = builder.media;
        this.button = builder.button;
        this.subContent = builder.subContent;
    }

    Card(Builder builder) {
        this.text = builder.text;
        this.title = builder.title;
        this.media = builder.media;
        this.mediaUrl = builder.mediaUrl;
        this.button = builder.button;
    }

    Card(Template.Builder builder) {
        this.description = builder.description;
        this.userJson = builder.userJson;
        this.subContent = builder.subContent;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="media")
    public String getMedia() {
        return this.media;
    }

    @JsonProperty(value="mediaUrl")
    public String getMediaUrl() {
        return this.mediaUrl;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="button")
    public List<Button> getButton() {
        return this.button;
    }

    @JsonAnyGetter
    public HashMap<String, String> getUserJson() {
        return this.userJson;
    }

    @JsonProperty(value="subContent")
    public List<SubContent> getSubContent() {
        return this.subContent;
    }

    public static class Builder {
        String text;
        String title;
        String media;
        String mediaUrl;
        List<Button> button = new ArrayList<Button>();

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder media(String media) {
            this.media = media;
            return this;
        }

        public Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public Builder addButton(Button button) {
            this.button.add(button);
            return this;
        }

        public Card build() {
            return new Card(this);
        }
    }
}

