/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.service.auth;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import net.infobank.client.core.HttpConfig;
import net.infobank.client.core.Util;
import net.infobank.client.core.exception.ErrorResponseException;
import net.infobank.client.data.response.AuthResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public class AuthService {
    private final String PATH = "/v1/auth/token";
    private final BasicResponseHandler basicResponseHandler = new BasicResponseHandler();
    private HttpConfig httpConfig;
    private HttpClient httpClient;
    private String clientId;
    private String password;
    private static String token;
    private static LocalDateTime expireTime;

    public AuthService(HttpConfig httpConfig, HttpClient httpClient, String clientId, String password) {
        this.httpConfig = httpConfig;
        this.httpClient = httpClient;
        this.clientId = clientId;
        this.password = password;
    }

    public RequestBuilder init(RequestBuilder request) throws IOException {
        if (token == null || expireTime != null && expireTime.isBefore(LocalDateTime.now())) {
            this.getToken();
        }
        return request.addHeader("Authorization", "Bearer " + token);
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = Util.createHttpClient(this.httpConfig);
        }
        return this.httpClient;
    }

    public AuthResponse getToken() throws IOException {
        HttpUriRequest httpRequest = RequestBuilder.post(this.httpConfig.getBaseUrl() + "/v1/auth/token").setHeader("X-IB-Client-Id", this.clientId).setHeader("X-IB-Client-Passwd", this.password).setHeader("Accept", "application/json").setHeader("User-Agent", this.httpConfig.getUserAgent()).setCharset(StandardCharsets.UTF_8).build();
        AuthResponse authRes = new AuthResponse();
        HttpResponse response = this.getHttpClient().execute(httpRequest);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw ErrorResponseException.fromHttpResponse(response);
        }
        authRes = AuthResponse.fromJson(this.basicResponseHandler.handleResponse(response));
        token = authRes.getData().getToken();
        expireTime = LocalDateTime.now().plus(23L, ChronoUnit.HOURS);
        return authRes;
    }
}

