/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.fsm;

import io.github.interacto.fsm.CancelFSMException;
import io.github.interacto.fsm.FSMHandler;
import io.github.interacto.fsm.InitState;
import io.github.interacto.fsm.InputState;
import io.github.interacto.fsm.OutputState;
import io.github.interacto.fsm.State;
import io.github.interacto.fsm.StdState;
import io.github.interacto.fsm.TimeoutTransition;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FSM<E> {
    protected Logger logger;
    protected boolean inner;
    protected State<E> startingState;
    protected boolean started = false;
    protected final InitState<E> initState;
    protected OutputState<E> currentState;
    protected final PublishSubject<Map.Entry<OutputState<E>, OutputState<E>>> currentStatePublisher;
    protected final Set<State<E>> states;
    protected final Set<FSMHandler> handlers;
    protected final List<E> eventsToProcess = new ArrayList();
    protected TimeoutTransition<E> currentTimeout;
    protected FSM<E> currentSubFSM;

    public FSM() {
        this.initState = new InitState(this, "init");
        this.states = new HashSet<State<E>>();
        this.states.add(this.initState);
        this.startingState = this.initState;
        this.currentState = this.initState;
        this.currentStatePublisher = PublishSubject.create();
        this.inner = false;
        this.handlers = new HashSet<FSMHandler>(2);
    }

    public OutputState<E> getCurrentState() {
        return this.currentState;
    }

    public Observable<Map.Entry<OutputState<E>, OutputState<E>>> currentState() {
        return this.currentStatePublisher;
    }

    public void setInner(boolean inner) {
        this.inner = inner;
    }

    public boolean isInner() {
        return this.inner;
    }

    public boolean process(E event) {
        if (event == null) {
            return false;
        }
        if (this.currentSubFSM != null) {
            return this.currentSubFSM.process(event);
        }
        return this.currentState.process(event);
    }

    protected void enterStdState(StdState<E> state) throws CancelFSMException {
        this.setCurrentState(state);
        this.checkTimeoutTransition();
        if (this.started) {
            this.onUpdating();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    protected void setCurrentState(OutputState<E> state) {
        OutputState<E> old = this.currentState;
        this.currentState = state;
        this.currentStatePublisher.onNext(Map.entry(old, this.currentState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRemainingEvents() {
        List<E> list = this.eventsToProcess;
        synchronized (list) {
            ArrayList<E> list2 = new ArrayList<E>(this.eventsToProcess);
            while (!list2.isEmpty()) {
                Object event = list2.remove(0);
                this.eventsToProcess.remove(0);
                if (this.logger != null) {
                    this.logger.log(Level.INFO, "Recycling event: " + event + " in : " + this.getClass().getSimpleName());
                }
                this.process(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRemaningEventsToProcess(E event) {
        if (event != null) {
            List<E> list = this.eventsToProcess;
            synchronized (list) {
                this.eventsToProcess.add(event);
            }
        }
    }

    protected void onTerminating() throws CancelFSMException {
        if (this.logger != null) {
            this.logger.log(Level.INFO, "FSM ended: {0}", this.getClass().getSimpleName());
        }
        if (this.started) {
            this.notifyHandlerOnStop();
        }
        this.reinit();
        this.processRemainingEvents();
    }

    protected void onCancelling() {
        if (this.logger != null) {
            this.logger.log(Level.INFO, "FSM cancelled: {0}", this.getClass().getSimpleName());
        }
        if (this.started) {
            this.notifyHandlerOnCancel();
        }
        this.fullReinit();
    }

    public void onStarting() throws CancelFSMException {
        if (this.logger != null) {
            this.logger.log(Level.INFO, "FSM started: {0}", this.getClass().getSimpleName());
        }
        this.started = true;
        this.notifyHandlerOnStart();
    }

    public void onUpdating() throws CancelFSMException {
        if (this.started) {
            if (this.logger != null) {
                this.logger.log(Level.INFO, "FSM updated: {0}", this.getClass().getSimpleName());
            }
            this.notifyHandlerOnUpdate();
        }
    }

    protected void addState(InputState<E> state) {
        if (state != null) {
            this.states.add(state);
        }
    }

    public void log(boolean log) {
        if (log) {
            if (this.logger == null) {
                this.logger = Logger.getLogger(FSM.class.getName());
            }
        } else {
            this.logger = null;
        }
    }

    public void reinit() {
        if (this.logger != null) {
            this.logger.log(Level.INFO, "FSM reinitialised: {0}", this.getClass().getSimpleName());
        }
        if (this.currentTimeout != null) {
            this.currentTimeout.stopTimeout();
        }
        this.started = false;
        this.setCurrentState(this.initState);
        this.currentTimeout = null;
        if (this.currentSubFSM != null) {
            this.currentSubFSM.reinit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullReinit() {
        List<E> list = this.eventsToProcess;
        synchronized (list) {
            this.eventsToProcess.clear();
        }
        this.reinit();
        if (this.currentSubFSM != null) {
            this.currentSubFSM.fullReinit();
        }
    }

    protected void onTimeout() {
        if (this.currentTimeout != null) {
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Timeout in: {0}", this.getClass().getSimpleName());
            }
            try {
                this.currentTimeout.execute((Object)null).filter(state -> state instanceof OutputState).ifPresent(nextState -> {
                    this.setCurrentState((OutputState)((Object)nextState));
                    this.checkTimeoutTransition();
                });
            }
            catch (CancelFSMException cancelFSMException) {
                // empty catch block
            }
        }
    }

    protected void stopCurrentTimeout() {
        if (this.currentTimeout != null) {
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Timeout stopped in: {0}", this.getClass().getSimpleName());
            }
            this.currentTimeout.stopTimeout();
            this.currentTimeout = null;
        }
    }

    protected void checkTimeoutTransition() {
        this.currentState.getTransitions().stream().filter(tr -> tr instanceof TimeoutTransition).findFirst().map(tr -> (TimeoutTransition)tr).ifPresent(tr -> {
            if (this.logger != null) {
                this.logger.log(Level.INFO, "Timeout starting in: {0}", this.getClass().getSimpleName());
            }
            this.currentTimeout = tr;
            this.currentTimeout.startTimeout();
        });
    }

    public void addHandler(FSMHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    public void removeHandler(FSMHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    protected void notifyHandlerOnStart() throws CancelFSMException {
        try {
            for (FSMHandler handler : this.handlers) {
                handler.fsmStarts();
            }
        }
        catch (CancelFSMException ex) {
            this.onCancelling();
            throw ex;
        }
    }

    protected void notifyHandlerOnUpdate() throws CancelFSMException {
        try {
            for (FSMHandler handler : this.handlers) {
                handler.fsmUpdates();
            }
        }
        catch (CancelFSMException ex) {
            this.onCancelling();
            throw ex;
        }
    }

    protected void notifyHandlerOnStop() throws CancelFSMException {
        try {
            for (FSMHandler handler : new ArrayList<FSMHandler>(this.handlers)) {
                handler.fsmStops();
            }
        }
        catch (CancelFSMException ex) {
            this.onCancelling();
            throw ex;
        }
    }

    protected void notifyHandlerOnCancel() {
        new ArrayList<FSMHandler>(this.handlers).forEach(handler -> handler.fsmCancels());
    }

    public Set<State<E>> getStates() {
        return Collections.unmodifiableSet(this.states);
    }

    public void uninstall() {
        this.fullReinit();
        this.logger = null;
        this.currentStatePublisher.onComplete();
        this.startingState = null;
        this.currentSubFSM = null;
        this.states.forEach(state -> state.uninstall());
        this.states.clear();
    }
}

