/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.fsm;

import io.github.interacto.fsm.CancelFSMException;
import io.github.interacto.fsm.InputState;
import io.github.interacto.fsm.OutputState;
import java.util.Optional;
import java.util.Set;

public abstract class Transition<E extends E0, E0> {
    protected final OutputState<E0> src;
    protected final InputState<E0> tgt;

    protected Transition(OutputState<E0> srcState, InputState<E0> tgtState) {
        if (srcState == null || tgtState == null) {
            throw new IllegalArgumentException("States cannot be null");
        }
        this.src = srcState;
        this.tgt = tgtState;
        this.src.addTransition(this);
    }

    public Optional<InputState<E0>> execute(E0 event) throws CancelFSMException {
        E typedEvent = this.accept(event);
        if (typedEvent != null && this.isGuardOK(typedEvent)) {
            this.src.getFSM().stopCurrentTimeout();
            this.action(typedEvent);
            this.src.exit();
            this.tgt.enter();
            return Optional.of(this.tgt);
        }
        return Optional.empty();
    }

    protected void action(E event) {
    }

    protected abstract E accept(E0 var1);

    protected abstract boolean isGuardOK(E var1);

    public abstract Set<Object> getAcceptedEvents();

    public void uninstall() {
    }
}

