/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor;

import com.google.auto.service.AutoService;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.javahelpers.simple.builders.core.annotations.SimpleBuilder;
import org.javahelpers.simple.builders.processor.dtos.BuilderDefinitionDto;
import org.javahelpers.simple.builders.processor.exceptions.BuilderException;
import org.javahelpers.simple.builders.processor.util.BuilderDefinitionCreator;
import org.javahelpers.simple.builders.processor.util.JavaCodeGenerator;
import org.javahelpers.simple.builders.processor.util.ProcessingContext;
import org.javahelpers.simple.builders.processor.util.ProcessingLogger;

@SupportedAnnotationTypes(value={"org.javahelpers.simple.builders.core.annotations.SimpleBuilder"})
@SupportedOptions(value={"verbose"})
@AutoService(value={Processor.class})
public class BuilderProcessor
extends AbstractProcessor {
    private ProcessingContext context;
    private JavaCodeGenerator codeGenerator;
    private boolean supportedJdk = true;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ProcessingLogger logger = new ProcessingLogger(processingEnv);
        this.context = new ProcessingContext(processingEnv.getElementUtils(), processingEnv.getTypeUtils(), logger);
        this.codeGenerator = new JavaCodeGenerator(processingEnv.getFiler(), logger);
        SourceVersion current = processingEnv.getSourceVersion();
        this.supportedJdk = BuilderProcessor.isAtLeastJava17(current);
        if (!this.supportedJdk) {
            this.context.error("simple-builders requires Java 17 or higher for annotation processing. Detected: '%s'. Please upgrade to JDK 17+ or disable the processor.", new Object[]{current});
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!this.supportedJdk) {
            return false;
        }
        TypeElement simpleBuilderAnnotation = this.context.getTypeElement(SimpleBuilder.class.getCanonicalName());
        if (simpleBuilderAnnotation == null) {
            this.context.error("Annotation org.javahelpers.simple.builders.core.annotations.SimpleBuilder is not on classpath. So nothing to do here.", new Object[0]);
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(simpleBuilderAnnotation);
        this.context.debug("===============================");
        this.context.info("simple-builders: PROCESSING ROUND START");
        this.context.debug("===============================");
        this.context.debug("simple-builders: Processing round started. Found %d annotated elements.", annotatedElements.size());
        for (Element element : annotatedElements) {
            try {
                this.context.debug("------------------------------------");
                this.context.debug("simple-builders: Processing element: %s", element.getSimpleName());
                this.context.debug("------------------------------------");
                this.process(element);
                this.context.info("simple-builders: Successfully generated builder for: %s", element.getSimpleName());
            }
            catch (BuilderException ex) {
                this.context.warning(element, "simple-builders: Failed to generate builder - %s", ex.getMessage());
            }
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void process(Element annotatedElement) throws BuilderException {
        BuilderDefinitionDto builderDef = BuilderDefinitionCreator.extractFromElement(annotatedElement, this.context);
        this.codeGenerator.generateBuilder(builderDef);
    }

    private static boolean isAtLeastJava17(SourceVersion current) {
        try {
            SourceVersion seventeen = SourceVersion.valueOf("RELEASE_17");
            return current.ordinal() >= seventeen.ordinal();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }
}

