/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.javahelpers.simple.builders.core.annotations.IgnoreInBuilder;
import org.javahelpers.simple.builders.core.annotations.SimpleBuilder;
import org.javahelpers.simple.builders.core.builders.ArrayListBuilder;
import org.javahelpers.simple.builders.core.builders.HashMapBuilder;
import org.javahelpers.simple.builders.core.builders.HashSetBuilder;
import org.javahelpers.simple.builders.core.util.TrackedValue;
import org.javahelpers.simple.builders.processor.dtos.BuilderDefinitionDto;
import org.javahelpers.simple.builders.processor.dtos.FieldDto;
import org.javahelpers.simple.builders.processor.dtos.MethodDto;
import org.javahelpers.simple.builders.processor.dtos.MethodParameterDto;
import org.javahelpers.simple.builders.processor.dtos.MethodTypes;
import org.javahelpers.simple.builders.processor.dtos.TypeName;
import org.javahelpers.simple.builders.processor.dtos.TypeNameArray;
import org.javahelpers.simple.builders.processor.dtos.TypeNameGeneric;
import org.javahelpers.simple.builders.processor.dtos.TypeNameVariable;
import org.javahelpers.simple.builders.processor.exceptions.BuilderException;
import org.javahelpers.simple.builders.processor.util.AnnotationValidator;
import org.javahelpers.simple.builders.processor.util.JavaLangAnalyser;
import org.javahelpers.simple.builders.processor.util.JavaLangMapper;
import org.javahelpers.simple.builders.processor.util.ProcessingContext;
import org.javahelpers.simple.builders.processor.util.TypeNameAnalyser;

public class BuilderDefinitionCreator {
    private static final String BUILDER_SUFFIX = "Builder";
    private static final String ARG_FIELD_NAME = "fieldName";
    private static final String ARG_DTO_METHOD_PARAM = "dtoMethodParam";
    private static final String ARG_DTO_METHOD_PARAMS = "dtoMethodParams";
    private static final String ARG_BUILDER_FIELD_WRAPPER = "builderFieldWrapper";
    private static final String ARG_HELPER_TYPE = "helperType";
    private static final String SUFFIX_CONSUMER = "Consumer";
    private static final String SUFFIX_SUPPLIER = "Supplier";

    private BuilderDefinitionCreator() {
    }

    public static BuilderDefinitionDto extractFromElement(Element annotatedElement, ProcessingContext context) throws BuilderException {
        AnnotationValidator.validateAnnotatedElement(annotatedElement);
        TypeElement annotatedType = (TypeElement)annotatedElement;
        context.debug("Extracting builder definition from: %s", annotatedType.getQualifiedName());
        BuilderDefinitionDto result = BuilderDefinitionCreator.initializeBuilderDefinition(annotatedType, context);
        List<FieldDto> constructorFields = BuilderDefinitionCreator.extractConstructorFields(annotatedType, context);
        result.addAllFieldsInConstructor(constructorFields);
        List<FieldDto> setterFields = BuilderDefinitionCreator.extractSetterFields(annotatedType, result, context);
        result.addAllFields(setterFields);
        return result;
    }

    private static BuilderDefinitionDto initializeBuilderDefinition(TypeElement annotatedType, ProcessingContext context) {
        BuilderDefinitionDto result = new BuilderDefinitionDto();
        String packageName = context.getPackageName(annotatedType);
        String simpleClassName = annotatedType.getSimpleName().toString();
        result.setBuilderTypeName(new TypeName(packageName, simpleClassName + BUILDER_SUFFIX));
        result.setBuildingTargetTypeName(new TypeName(packageName, simpleClassName));
        context.debug("Builder will be generated as: %s.%s", packageName, simpleClassName + BUILDER_SUFFIX);
        JavaLangMapper.map2GenericParameterDtos(annotatedType, context).forEach(result::addGeneric);
        return result;
    }

    private static List<FieldDto> extractConstructorFields(TypeElement annotatedType, ProcessingContext context) {
        LinkedList<FieldDto> constructorFields = new LinkedList<FieldDto>();
        Optional<ExecutableElement> constructorOpt = JavaLangAnalyser.findConstructorForBuilder(annotatedType, context);
        if (constructorOpt.isPresent()) {
            ExecutableElement ctor = constructorOpt.get();
            context.debug("Analyzing constructor: %s with %d parameter(s)", ctor.getSimpleName(), ctor.getParameters().size());
            for (VariableElement variableElement : ctor.getParameters()) {
                Optional<FieldDto> fieldFromCtor = BuilderDefinitionCreator.createFieldFromConstructor(annotatedType, variableElement, context);
                if (!fieldFromCtor.isPresent()) continue;
                FieldDto field = fieldFromCtor.get();
                BuilderDefinitionCreator.logFieldAddition(field, context);
                constructorFields.add(field);
            }
        }
        return constructorFields;
    }

    private static List<FieldDto> extractSetterFields(TypeElement annotatedType, BuilderDefinitionDto result, ProcessingContext context) {
        LinkedList<FieldDto> setterFields = new LinkedList<FieldDto>();
        Set ctorFieldNames = result.getConstructorFieldsForBuilder().stream().map(FieldDto::getFieldName).collect(Collectors.toSet());
        List<ExecutableElement> methods = JavaLangAnalyser.findAllPossibleSettersOfClass(annotatedType, context);
        int processedCount = 0;
        int addedCount = 0;
        int skippedCount = 0;
        for (ExecutableElement mth : methods) {
            context.debug("Analyzing method: %s with %d parameter(s)", mth.getSimpleName(), mth.getParameters().size());
            if (BuilderDefinitionCreator.isMethodRelevantForBuilder(mth, context)) {
                Optional<FieldDto> maybeField = BuilderDefinitionCreator.createFieldFromSetter(mth, context);
                if (maybeField.isPresent()) {
                    ++processedCount;
                    FieldDto field = maybeField.get();
                    if (!ctorFieldNames.contains(field.getFieldName())) {
                        ++addedCount;
                        BuilderDefinitionCreator.logFieldAddition(field, context);
                        setterFields.add(field);
                        continue;
                    }
                } else {
                    context.debug("  -> Skipping method (already in constructor): %s", mth.getSimpleName());
                }
            }
            ++skippedCount;
        }
        context.debug("Processed %d possible setters: added %d fields, skipped %d", processedCount, addedCount, skippedCount);
        return setterFields;
    }

    private static void logFieldAddition(FieldDto field, ProcessingContext context) {
        Object fieldTypeName = field.getFieldType().getClassName();
        if (field.getFieldType().getPackageName() != null && !field.getFieldType().getPackageName().isEmpty()) {
            fieldTypeName = field.getFieldType().getPackageName() + "." + (String)fieldTypeName;
        }
        context.debug("  -> Adding field: %s (type: %s)", field.getFieldName(), fieldTypeName);
    }

    private static boolean isMethodRelevantForBuilder(ExecutableElement mth, ProcessingContext context) {
        if (!JavaLangAnalyser.hasNoThrowablesDeclared(mth)) {
            context.debug("  -> Skipping: declares throwables");
            return false;
        }
        if (!JavaLangAnalyser.hasNoReturnValue(mth)) {
            context.debug("  -> Skipping: has return value");
            return false;
        }
        if (!JavaLangAnalyser.hasNotAnnotation(IgnoreInBuilder.class, mth)) {
            context.debug("  -> Skipping: has @IgnoreInBuilder annotation");
            return false;
        }
        if (!JavaLangAnalyser.isNotPrivate(mth)) {
            context.debug("  -> Skipping: is private");
            return false;
        }
        if (!JavaLangAnalyser.isNotStatic(mth)) {
            context.debug("  -> Skipping: is static");
            return false;
        }
        return true;
    }

    private static void addAdditionalHelperMethodsForField(FieldDto result, String fieldName, TypeName fieldType) {
        if (!(fieldType instanceof TypeNameGeneric)) {
            return;
        }
        TypeNameGeneric fieldTypeGeneric = (TypeNameGeneric)fieldType;
        List<TypeName> innerTypes = fieldTypeGeneric.getInnerTypeArguments();
        int innerTypesCnt = innerTypes.size();
        if (TypeNameAnalyser.isList(fieldType) && innerTypesCnt == 1) {
            result.addMethod(BuilderDefinitionCreator.createFieldSetterWithTransform(fieldName, "List.of(%s)", new TypeNameArray(innerTypes.get(0), false)));
        } else if (TypeNameAnalyser.isSet(fieldType) && innerTypesCnt == 1) {
            result.addMethod(BuilderDefinitionCreator.createFieldSetterWithTransform(fieldName, "Set.of(%s)", new TypeNameArray(innerTypes.get(0), true)));
        } else if (TypeNameAnalyser.isMap(fieldType) && innerTypesCnt == 2) {
            TypeNameArray mapEntryType = new TypeNameArray(new TypeNameGeneric("java.util", "Map.Entry", innerTypes.get(0), innerTypes.get(1)), false);
            result.addMethod(BuilderDefinitionCreator.createFieldSetterWithTransform(fieldName, "Map.ofEntries(%s)", mapEntryType));
        }
    }

    private static void addConsumerMethodsForField(FieldDto result, String fieldName, TypeName fieldType, VariableElement fieldParameter, TypeElement fieldTypeElement, ProcessingContext context) {
        TypeNameGeneric fieldTypeGeneric;
        TypeNameGeneric fieldTypeGeneric2;
        TypeNameGeneric fieldTypeGeneric3;
        if (fieldType instanceof TypeNameVariable) {
            return;
        }
        if (JavaLangAnalyser.isFunctionalInterface(fieldTypeElement)) {
            return;
        }
        Optional<TypeName> builderTypeOpt = BuilderDefinitionCreator.findBuilderType(fieldParameter, context);
        if (builderTypeOpt.isPresent()) {
            TypeName builderType = builderTypeOpt.get();
            result.addMethod(BuilderDefinitionCreator.createFieldConsumerWithBuilder(fieldName, builderType));
        } else if (!TypeNameAnalyser.isJavaClass(fieldType) && fieldTypeElement != null && fieldTypeElement.getKind() == ElementKind.CLASS && !fieldTypeElement.getModifiers().contains((Object)Modifier.ABSTRACT) && JavaLangAnalyser.hasEmptyConstructor(fieldTypeElement, context)) {
            result.addMethod(BuilderDefinitionCreator.createFieldConsumer(fieldName, fieldType));
        } else if (TypeNameAnalyser.isList(fieldType) && fieldType instanceof TypeNameGeneric && (fieldTypeGeneric3 = (TypeNameGeneric)fieldType).getInnerTypeArguments().size() == 1) {
            result.addMethod(BuilderDefinitionCreator.createFieldConsumerWithBuilder(fieldName, JavaLangMapper.map2TypeName(ArrayListBuilder.class), fieldTypeGeneric3.getInnerTypeArguments().get(0)));
        } else if (TypeNameAnalyser.isMap(fieldType) && fieldType instanceof TypeNameGeneric && (fieldTypeGeneric2 = (TypeNameGeneric)fieldType).getInnerTypeArguments().size() == 2) {
            TypeNameGeneric builderTargetTypeName = new TypeNameGeneric(JavaLangMapper.map2TypeName(HashMapBuilder.class), fieldTypeGeneric2.getInnerTypeArguments().get(0), fieldTypeGeneric2.getInnerTypeArguments().get(1));
            MethodDto mapConsumerWithBuilder = BuilderDefinitionCreator.createFieldConsumerWithBuilder(fieldName, builderTargetTypeName);
            result.addMethod(mapConsumerWithBuilder);
        } else if (TypeNameAnalyser.isSet(fieldType) && fieldType instanceof TypeNameGeneric && (fieldTypeGeneric = (TypeNameGeneric)fieldType).getInnerTypeArguments().size() == 1) {
            result.addMethod(BuilderDefinitionCreator.createFieldConsumerWithBuilder(fieldName, JavaLangMapper.map2TypeName(HashSetBuilder.class), fieldTypeGeneric.getInnerTypeArguments().get(0)));
        }
    }

    private static void addSupplierMethodsForField(FieldDto result, String fieldName, TypeName fieldType, TypeElement fieldTypeElement) {
        if (JavaLangAnalyser.isFunctionalInterface(fieldTypeElement)) {
            return;
        }
        result.addMethod(BuilderDefinitionCreator.createFieldSupplier(fieldName, fieldType));
    }

    private static Optional<FieldDto> createFieldFromSetter(ExecutableElement mth, ProcessingContext context) {
        String methodName = mth.getSimpleName().toString();
        String fieldName = StringUtils.uncapitalize((String)Strings.CI.removeStart(methodName, (CharSequence)"set"));
        List<? extends VariableElement> parameters = mth.getParameters();
        if (parameters.size() != 1) {
            context.warning(mth, "Unexpected state of method.", new Object[0]);
            return Optional.empty();
        }
        if (CollectionUtils.isNotEmpty(mth.getTypeParameters())) {
            context.warning(mth.getEnclosingElement(), "Field '%s' has field-specific generics, so it will be ignored", fieldName);
            return Optional.empty();
        }
        VariableElement fieldParameter = parameters.get(0);
        TypeElement dtoType = (TypeElement)mth.getEnclosingElement();
        String fullJavaDoc = context.getDocComment(mth);
        String javaDoc = JavaLangAnalyser.extractParamJavaDoc(fullJavaDoc, fieldParameter);
        if (javaDoc == null) {
            javaDoc = fieldName;
        }
        return BuilderDefinitionCreator.createFieldDto(fieldName, javaDoc, fieldParameter, dtoType, context);
    }

    private static Optional<FieldDto> createFieldFromConstructor(TypeElement dtoType, VariableElement param, ProcessingContext context) {
        String fieldName = param.getSimpleName().toString();
        String javaDoc = JavaLangAnalyser.extractParamJavaDoc(context.getDocComment(dtoType), param);
        if (javaDoc == null) {
            javaDoc = fieldName;
        }
        return BuilderDefinitionCreator.createFieldDto(fieldName, javaDoc, param, dtoType, context);
    }

    private static Optional<FieldDto> createFieldDto(String fieldName, String javaDoc, VariableElement param, TypeElement dtoType, ProcessingContext context) {
        TypeElement te;
        MethodParameterDto paramDto = JavaLangMapper.map2MethodParameter(param, context);
        if (paramDto == null) {
            return Optional.empty();
        }
        TypeName fieldType = paramDto.getParameterType();
        TypeMirror fieldTypeMirror = param.asType();
        Element rawElement = context.asElement(fieldTypeMirror);
        TypeElement fieldTypeElement = rawElement instanceof TypeElement ? (te = (TypeElement)rawElement) : null;
        FieldDto field = new FieldDto();
        field.setFieldName(fieldName);
        field.setFieldType(fieldType);
        field.setJavaDoc(javaDoc);
        JavaLangAnalyser.findGetterForField(dtoType, fieldName, fieldTypeMirror, context).ifPresent(getter -> field.setGetterName(getter.getSimpleName().toString()));
        field.addMethod(BuilderDefinitionCreator.createFieldSetterWithTransform(fieldName, null, fieldType));
        BuilderDefinitionCreator.addConsumerMethodsForField(field, fieldName, fieldType, param, fieldTypeElement, context);
        BuilderDefinitionCreator.addSupplierMethodsForField(field, fieldName, fieldType, fieldTypeElement);
        BuilderDefinitionCreator.addAdditionalHelperMethodsForField(field, fieldName, fieldType);
        return Optional.of(field);
    }

    private static MethodDto createFieldSetterWithTransform(String fieldName, String transform, TypeName fieldType) {
        MethodParameterDto parameter = new MethodParameterDto();
        parameter.setParameterName(fieldName);
        parameter.setParameterTypeName(fieldType);
        MethodDto methodDto = new MethodDto();
        methodDto.setMethodName(fieldName);
        methodDto.addParameter(parameter);
        methodDto.setModifier(Modifier.PUBLIC);
        methodDto.setMethodType(MethodTypes.PROXY);
        String params = StringUtils.isBlank((CharSequence)transform) ? parameter.getParameterName() : String.format(transform, parameter.getParameterName());
        methodDto.setCode("this.$fieldName:N = $builderFieldWrapper:T.changedValue($dtoMethodParams:N);\nreturn this;\n");
        methodDto.addArgument(ARG_FIELD_NAME, fieldName);
        methodDto.addArgument(ARG_DTO_METHOD_PARAMS, params);
        methodDto.addArgument(ARG_BUILDER_FIELD_WRAPPER, TypeName.of(TrackedValue.class));
        return methodDto;
    }

    private static MethodDto createFieldConsumer(String fieldName, TypeName fieldType) {
        TypeNameGeneric consumerType = new TypeNameGeneric(JavaLangMapper.map2TypeName(Consumer.class), fieldType);
        MethodParameterDto parameter = new MethodParameterDto();
        parameter.setParameterName(fieldName + SUFFIX_CONSUMER);
        parameter.setParameterTypeName(consumerType);
        MethodDto methodDto = new MethodDto();
        methodDto.setMethodName(fieldName);
        methodDto.addParameter(parameter);
        methodDto.setModifier(Modifier.PUBLIC);
        methodDto.setMethodType(MethodTypes.CONSUMER);
        methodDto.setCode("$helperType:T consumer = new $helperType:T();\n$dtoMethodParam:N.accept(consumer);\nthis.$fieldName:N = $builderFieldWrapper:T.changedValue(consumer);\nreturn this;\n");
        methodDto.addArgument(ARG_FIELD_NAME, fieldName);
        methodDto.addArgument(ARG_DTO_METHOD_PARAM, parameter.getParameterName());
        methodDto.addArgument(ARG_HELPER_TYPE, fieldType);
        methodDto.addArgument(ARG_BUILDER_FIELD_WRAPPER, TypeName.of(TrackedValue.class));
        return methodDto;
    }

    private static MethodDto createFieldConsumerWithBuilder(String fieldName, TypeName builderType, TypeName builderTargetType) {
        TypeNameGeneric builderTypeGeneric = new TypeNameGeneric(builderType, builderTargetType);
        return BuilderDefinitionCreator.createFieldConsumerWithBuilder(fieldName, builderTypeGeneric);
    }

    private static MethodDto createFieldConsumerWithBuilder(String fieldName, TypeName builderType) {
        TypeNameGeneric consumerType = new TypeNameGeneric(JavaLangMapper.map2TypeName(Consumer.class), builderType);
        MethodParameterDto parameter = new MethodParameterDto();
        parameter.setParameterName(fieldName + "BuilderConsumer");
        parameter.setParameterTypeName(consumerType);
        MethodDto methodDto = new MethodDto();
        methodDto.setMethodName(fieldName);
        methodDto.addParameter(parameter);
        methodDto.setModifier(Modifier.PUBLIC);
        methodDto.setMethodType(MethodTypes.CONSUMER_BY_BUILDER);
        methodDto.setCode("$helperType:T builder = new $helperType:T();\n$dtoMethodParam:N.accept(builder);\nthis.$fieldName:N = $builderFieldWrapper:T.changedValue(builder.build());\nreturn this;\n");
        methodDto.addArgument(ARG_FIELD_NAME, fieldName);
        methodDto.addArgument(ARG_DTO_METHOD_PARAM, parameter.getParameterName());
        methodDto.addArgument(ARG_HELPER_TYPE, builderType);
        methodDto.addArgument(ARG_BUILDER_FIELD_WRAPPER, TypeName.of(TrackedValue.class));
        return methodDto;
    }

    private static MethodDto createFieldSupplier(String fieldName, TypeName fieldType) {
        TypeNameGeneric supplierType = new TypeNameGeneric(JavaLangMapper.map2TypeName(Supplier.class), fieldType);
        MethodParameterDto parameter = new MethodParameterDto();
        parameter.setParameterName(fieldName + SUFFIX_SUPPLIER);
        parameter.setParameterTypeName(supplierType);
        MethodDto methodDto = new MethodDto();
        methodDto.setMethodName(fieldName);
        methodDto.addParameter(parameter);
        methodDto.setModifier(Modifier.PUBLIC);
        methodDto.setMethodType(MethodTypes.SUPPLIER);
        methodDto.setCode("this.$fieldName:N = $builderFieldWrapper:T.changedValue($dtoMethodParam:N.get());\nreturn this;\n");
        methodDto.addArgument(ARG_FIELD_NAME, fieldName);
        methodDto.addArgument(ARG_DTO_METHOD_PARAM, parameter.getParameterName());
        methodDto.addArgument(ARG_BUILDER_FIELD_WRAPPER, TypeName.of(TrackedValue.class));
        return methodDto;
    }

    private static Optional<TypeName> findBuilderType(VariableElement param, ProcessingContext context) {
        TypeMirror typeOfParameter = param.asType();
        if (typeOfParameter.getKind() == TypeKind.ARRAY || typeOfParameter.getKind().isPrimitive()) {
            return Optional.empty();
        }
        Element elementOfParameter = context.asElement(typeOfParameter);
        if (elementOfParameter == null) {
            return Optional.empty();
        }
        String simpleClassName = elementOfParameter.getSimpleName().toString();
        String packageName = context.getPackageName(elementOfParameter);
        Optional<AnnotationMirror> foundBuilderAnnotation = JavaLangAnalyser.findAnnotation(elementOfParameter, SimpleBuilder.class);
        boolean isClassWithoutGenerics = StringUtils.containsNone((CharSequence)simpleClassName, (String)"<");
        if (foundBuilderAnnotation.isPresent() && isClassWithoutGenerics) {
            return Optional.of(new TypeName(packageName, simpleClassName + BUILDER_SUFFIX));
        }
        return Optional.empty();
    }
}

