/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.javahelpers.simple.builders.core.annotations.SimpleBuilderConstructor;
import org.javahelpers.simple.builders.processor.util.ProcessingContext;

public final class JavaLangAnalyser {
    private static final String PARAM_TAG = "@param ";

    private JavaLangAnalyser() {
    }

    public static boolean isNoMethodOfObjectClass(ExecutableElement mth) {
        String simpleNameOfParent = mth.getEnclosingElement().getSimpleName().toString();
        return !Strings.CS.equals("java.lang.Object", simpleNameOfParent) && !Strings.CS.equals("Object", simpleNameOfParent);
    }

    public static List<ExecutableElement> findAllPossibleSettersOfClass(TypeElement typeElement, ProcessingContext context) {
        return ElementFilter.methodsIn(context.getAllMembers(typeElement)).stream().filter(JavaLangAnalyser::isNoMethodOfObjectClass).filter(JavaLangAnalyser::isSetterForField).toList();
    }

    public static <A extends Annotation> boolean hasNotAnnotation(Class<A> annotationClass, ExecutableElement mth) {
        return mth.getAnnotation(annotationClass) == null;
    }

    public static boolean hasNoThrowablesDeclared(ExecutableElement mth) {
        return mth.getThrownTypes().isEmpty();
    }

    public static boolean hasNoReturnValue(ExecutableElement mth) {
        return mth.getReturnType().getKind() == TypeKind.VOID;
    }

    public static boolean isNotPrivate(ExecutableElement mth) {
        return !mth.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public static boolean isNotStatic(ExecutableElement mth) {
        return !mth.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isSetterForField(ExecutableElement mth) {
        String name = mth.getSimpleName().toString();
        return name.startsWith("set") && StringUtils.length((CharSequence)name) > 3 && StringUtils.isAllUpperCase((CharSequence)StringUtils.substring((String)name, (int)3, (int)4)) && mth.getParameters().size() == 1;
    }

    public static boolean hasEmptyConstructor(TypeElement typeElement, ProcessingContext context) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(context.getAllMembers(typeElement));
        return constructors.stream().anyMatch(c -> c.getParameters().isEmpty());
    }

    public static Optional<AnnotationMirror> findAnnotation(Element methodElement, Class<? extends Annotation> annotationClass) {
        if (methodElement == null) {
            return Optional.empty();
        }
        for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationClass.getCanonicalName())) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    public static boolean isFunctionalInterface(TypeElement typeElement) {
        if (typeElement == null) {
            return false;
        }
        if (JavaLangAnalyser.findAnnotation(typeElement, FunctionalInterface.class).isPresent()) {
            return true;
        }
        if (typeElement.getKind() != ElementKind.INTERFACE) {
            return false;
        }
        long abstractDeclared = ElementFilter.methodsIn(typeElement.getEnclosedElements()).stream().filter(m -> !m.getModifiers().contains((Object)Modifier.STATIC)).filter(m -> !m.getModifiers().contains((Object)Modifier.DEFAULT)).count();
        return abstractDeclared == 1L;
    }

    public static String extractParamJavaDoc(String javaDoc, VariableElement parameter) {
        if (javaDoc == null || parameter == null) {
            return null;
        }
        String parameterName = parameter.getSimpleName().toString();
        String[] lines = javaDoc.split("\r?\n");
        int indexOfParamTag = JavaLangAnalyser.findParamTagLine(lines, parameterName);
        if (indexOfParamTag < 0) {
            return null;
        }
        return JavaLangAnalyser.extractParamText(lines, indexOfParamTag);
    }

    private static int findParamTagLine(String[] lines, String parameterName) {
        for (int i = 0; i < lines.length; ++i) {
            String name;
            String cleanedLine = JavaLangAnalyser.cleanJavadocLine(lines[i]);
            if (!cleanedLine.startsWith(PARAM_TAG)) continue;
            String rest = cleanedLine.substring(PARAM_TAG.length()).trim();
            int spaceIndex = rest.indexOf(32);
            String string = name = spaceIndex >= 0 ? rest.substring(0, spaceIndex) : rest;
            if (!Strings.CI.equals(parameterName, name)) continue;
            return i;
        }
        return -1;
    }

    private static String cleanJavadocLine(String rawLine) {
        String line = rawLine.trim();
        if (line.startsWith("*")) {
            return line.substring(1).trim();
        }
        return line;
    }

    private static String extractParamText(String[] lines, int startIndex) {
        String cleanedLine;
        String initialText;
        StringBuilder sb = new StringBuilder();
        String firstLine = JavaLangAnalyser.cleanJavadocLine(lines[startIndex]);
        String rest = firstLine.substring(PARAM_TAG.length()).trim();
        int spaceIndex = rest.indexOf(32);
        if (spaceIndex >= 0 && !(initialText = rest.substring(spaceIndex + 1).trim()).isEmpty()) {
            sb.append(initialText);
        }
        for (int i = startIndex + 1; i < lines.length && !(cleanedLine = JavaLangAnalyser.cleanJavadocLine(lines[i])).isEmpty() && !cleanedLine.startsWith("@"); ++i) {
            if (!sb.isEmpty()) {
                sb.append(' ');
            }
            sb.append(cleanedLine);
        }
        String result = sb.toString().trim();
        return result.isEmpty() ? null : result;
    }

    public static Optional<ExecutableElement> findGetterForField(TypeElement dtoType, String fieldName, TypeMirror fieldTypeMirror, ProcessingContext context) {
        if (dtoType == null || fieldName == null || fieldTypeMirror == null) {
            return Optional.empty();
        }
        String cap = StringUtils.capitalize((String)fieldName);
        String getterCandidate = "get" + cap;
        String booleanGetterCandidate = "is" + cap;
        List<ExecutableElement> classMethods = ElementFilter.methodsIn(context.getAllMembers(dtoType));
        for (ExecutableElement candidate : classMethods) {
            String name = candidate.getSimpleName().toString();
            if (!name.equals(booleanGetterCandidate) && !name.equals(getterCandidate) || !candidate.getParameters().isEmpty() || !context.isSameType(candidate.getReturnType(), fieldTypeMirror)) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    public static Optional<ExecutableElement> findConstructorForBuilder(TypeElement annotatedType, ProcessingContext context) {
        List<ExecutableElement> ctors = ElementFilter.constructorsIn(context.getAllMembers(annotatedType));
        for (ExecutableElement ctor : ctors) {
            if (ctor.getAnnotation(SimpleBuilderConstructor.class) == null) continue;
            return Optional.of(ctor);
        }
        ExecutableElement selected = null;
        int maxParams = -1;
        for (ExecutableElement ctor : ctors) {
            int p = ctor.getParameters().size();
            if (p <= maxParams) continue;
            maxParams = p;
            selected = ctor;
        }
        return selected != null && maxParams > 0 ? Optional.of(selected) : Optional.empty();
    }
}

