/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.dtos;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.javahelpers.simple.builders.processor.dtos.TypeName;

public class TypeNameGeneric
extends TypeName {
    private final List<TypeName> innerTypeArguments;

    public TypeNameGeneric(TypeName outerType, List<TypeName> innerTypeArguments) {
        super(outerType.getPackageName(), outerType.getClassName());
        this.innerTypeArguments = List.copyOf(innerTypeArguments);
    }

    public TypeNameGeneric(String packageName, String className, List<TypeName> innerTypeArguments) {
        super(packageName, className);
        this.innerTypeArguments = List.copyOf(innerTypeArguments);
    }

    public TypeNameGeneric(TypeName outerType, TypeName ... innerTypeArguments) {
        super(outerType.getPackageName(), outerType.getClassName());
        this.innerTypeArguments = List.of(innerTypeArguments);
    }

    public TypeNameGeneric(String packageName, String className, TypeName ... innerTypeArguments) {
        super(packageName, className);
        this.innerTypeArguments = List.of(innerTypeArguments);
    }

    public List<TypeName> getInnerTypeArguments() {
        return Collections.unmodifiableList(this.innerTypeArguments);
    }

    public boolean hasMultipleInnerTypes() {
        return this.innerTypeArguments.size() > 1;
    }

    @Override
    public Optional<TypeName> getInnerType() {
        return this.innerTypeArguments.size() == 1 ? Optional.of(this.innerTypeArguments.get(0)) : Optional.empty();
    }
}

