/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.javahelpers.simple.builders.core.annotations.SimpleBuilder;
import org.javahelpers.simple.builders.processor.exceptions.BuilderException;

public class AnnotationValidator {
    private AnnotationValidator() {
    }

    public static void validateAnnotatedElement(Element annotatedElement) throws BuilderException {
        TypeElement typeElement;
        if (annotatedElement.getKind() != ElementKind.CLASS && annotatedElement.getKind() != ElementKind.RECORD) {
            throw new BuilderException(annotatedElement, "The " + SimpleBuilder.class.getSimpleName() + " should be annotated on a class or record.", new Object[0]);
        }
        if (annotatedElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new BuilderException(annotatedElement, "The " + SimpleBuilder.class.getSimpleName() + " should not be abstract", new Object[0]);
        }
        if (annotatedElement instanceof TypeElement && (typeElement = (TypeElement)annotatedElement).getNestingKind() != NestingKind.TOP_LEVEL) {
            throw new BuilderException(annotatedElement, "The " + SimpleBuilder.class.getSimpleName() + " should be declared on a top-level class only", new Object[0]);
        }
    }
}

