/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Generated;
import javax.lang.model.element.Modifier;
import org.javahelpers.simple.builders.core.annotations.BuilderImplementation;
import org.javahelpers.simple.builders.core.interfaces.IBuilderBase;
import org.javahelpers.simple.builders.core.util.TrackedValue;
import org.javahelpers.simple.builders.processor.dtos.BuilderDefinitionDto;
import org.javahelpers.simple.builders.processor.dtos.FieldDto;
import org.javahelpers.simple.builders.processor.dtos.GenericParameterDto;
import org.javahelpers.simple.builders.processor.dtos.MethodDto;
import org.javahelpers.simple.builders.processor.dtos.MethodParameterDto;
import org.javahelpers.simple.builders.processor.dtos.TypeNameArray;
import org.javahelpers.simple.builders.processor.exceptions.BuilderException;
import org.javahelpers.simple.builders.processor.util.JavapoetMapper;
import org.javahelpers.simple.builders.processor.util.ProcessingLogger;

public class JavaCodeGenerator {
    private final Filer filer;
    private final ProcessingLogger logger;

    public JavaCodeGenerator(Filer filer, ProcessingLogger logger) {
        this.filer = filer;
        this.logger = logger;
    }

    public void generateBuilder(BuilderDefinitionDto builderDef) throws BuilderException {
        List<MethodSpec> methodSpecs;
        FieldSpec fieldSpec;
        ClassName dtoTypeName;
        ClassName builderTypeName;
        this.logger.debug("Starting code generation for builder: %s", builderDef.getBuilderTypeName().getClassName());
        ClassName builderBaseClass = JavapoetMapper.map2ClassName(builderDef.getBuilderTypeName());
        ClassName dtoBaseClass = JavapoetMapper.map2ClassName(builderDef.getBuildingTargetTypeName());
        if (builderDef.getGenerics().isEmpty()) {
            builderTypeName = builderBaseClass;
            dtoTypeName = dtoBaseClass;
        } else {
            builderTypeName = JavapoetMapper.map2ParameterizedTypeName(builderDef.getBuilderTypeName(), builderDef.getGenerics());
            dtoTypeName = JavapoetMapper.map2ParameterizedTypeName(builderDef.getBuildingTargetTypeName(), builderDef.getGenerics());
            this.logger.debug("Builder has %d generic type parameter(s)", builderDef.getGenerics().size());
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)builderBaseClass).addTypeVariables(JavapoetMapper.map2TypeVariables(builderDef.getGenerics())).addJavadoc(this.createJavadocForClass(dtoBaseClass)).addSuperinterface((TypeName)this.createInterfaceBuilderBase((TypeName)dtoTypeName));
        classBuilder.addMethod(this.createConstructorWithInstance(dtoBaseClass, (TypeName)dtoTypeName, builderDef.getAllFieldsForBuilder()));
        classBuilder.addMethod(this.createEmptyConstructor(dtoBaseClass));
        this.logger.debug("Generating %d constructor fields and %d setter fields", builderDef.getConstructorFieldsForBuilder().size(), builderDef.getSetterFieldsForBuilder().size());
        for (FieldDto fieldDto : builderDef.getConstructorFieldsForBuilder()) {
            fieldSpec = this.createFieldMember(fieldDto);
            classBuilder.addField(fieldSpec);
        }
        for (FieldDto fieldDto : builderDef.getSetterFieldsForBuilder()) {
            fieldSpec = this.createFieldMember(fieldDto);
            classBuilder.addField(fieldSpec);
        }
        for (FieldDto fieldDto : builderDef.getConstructorFieldsForBuilder()) {
            methodSpecs = this.createFieldMethods(fieldDto, (TypeName)builderTypeName);
            this.logger.debug("  Generated %d methods for field: %s", methodSpecs.size(), fieldDto.getFieldName());
            classBuilder.addMethods(methodSpecs);
        }
        for (FieldDto fieldDto : builderDef.getSetterFieldsForBuilder()) {
            methodSpecs = this.createFieldMethods(fieldDto, (TypeName)builderTypeName);
            this.logger.debug("  Generated %d methods for field: %s", methodSpecs.size(), fieldDto.getFieldName());
            classBuilder.addMethods(methodSpecs);
        }
        classBuilder.addMethod(this.createMethodBuild(dtoBaseClass, (TypeName)dtoTypeName, builderDef.getConstructorFieldsForBuilder(), builderDef.getSetterFieldsForBuilder(), builderDef.getGenerics()));
        classBuilder.addMethod(this.createMethodStaticCreate(builderBaseClass, (TypeName)builderTypeName, dtoBaseClass, builderDef.getGenerics()));
        classBuilder.addAnnotation(this.createAnnotationGenerated());
        classBuilder.addAnnotation(this.createAnnotationBuilderImplementation(dtoBaseClass));
        this.logger.debug("Writing builder class to file: %s.%s", builderDef.getBuilderTypeName().getPackageName(), builderDef.getBuilderTypeName().getClassName());
        this.writeClassToFile(builderDef.getBuilderTypeName().getPackageName(), classBuilder.build());
        this.logger.debug("Successfully generated builder: %s", builderDef.getBuilderTypeName().getClassName());
    }

    private void writeClassToFile(String packageName, TypeSpec typeSpec) throws BuilderException {
        try {
            JavaFile.builder((String)packageName, (TypeSpec)typeSpec).skipJavaLangImports(true).addStaticImport(TrackedValue.class, new String[]{"initialValue"}).addStaticImport(TrackedValue.class, new String[]{"changedValue"}).addStaticImport(TrackedValue.class, new String[]{"unsetValue"}).build().writeTo(this.filer);
        }
        catch (IOException ex) {
            throw new BuilderException(null, (Throwable)ex);
        }
    }

    private CodeBlock createJavadocForClass(ClassName dtoClass) {
        return CodeBlock.of((String)"Builder for {@code $1N.$2T}.", (Object[])new Object[]{dtoClass.packageName(), dtoClass});
    }

    private ParameterizedTypeName createInterfaceBuilderBase(TypeName dtoType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(IBuilderBase.class), (TypeName[])new TypeName[]{dtoType});
    }

    private AnnotationSpec createAnnotationGenerated() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$1S", new Object[]{"Generated by org.javahelpers.simple.builders.processor.BuilderProcessor"}).build();
    }

    private AnnotationSpec createAnnotationBuilderImplementation(ClassName dtoClass) {
        return AnnotationSpec.builder(BuilderImplementation.class).addMember("forClass", "$1T.class", new Object[]{dtoClass}).build();
    }

    private MethodSpec createEmptyConstructor(ClassName dtoClass) {
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Empty constructor of builder for {@code $1N.$2T}.\n", new Object[]{dtoClass.packageName(), dtoClass});
        return constructorBuilder.build();
    }

    private MethodSpec createConstructorWithInstance(ClassName dtoBaseClass, TypeName dtoType, List<FieldDto> fields) {
        MethodSpec.Builder cb = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(dtoType, "instance", new Modifier[0]).addJavadoc("Initialisation of builder for {@code $1N.$2T} by a instance.\n\n@param instance object instance for initialisiation\n", new Object[]{dtoBaseClass.packageName(), dtoBaseClass});
        for (FieldDto f : fields) {
            f.getGetterName().ifPresent(getter -> cb.addStatement("this.$N = $T.initialValue(instance.$N())", new Object[]{f.getFieldName(), ClassName.get(TrackedValue.class), getter}));
        }
        return cb.build();
    }

    private FieldSpec createFieldMember(FieldDto fieldDto) {
        TypeName fieldType = JavapoetMapper.map2ParameterType(fieldDto.getFieldType());
        if (fieldType.isPrimitive()) {
            fieldType = fieldType.box();
        }
        ClassName builderFieldWrapper = ClassName.get(TrackedValue.class);
        ParameterizedTypeName wrappedFieldType = ParameterizedTypeName.get((ClassName)builderFieldWrapper, (TypeName[])new TypeName[]{fieldType});
        return FieldSpec.builder((TypeName)wrappedFieldType, (String)fieldDto.getFieldName(), (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc("Tracked value for <code>$L</code>: $L.\n", new Object[]{fieldDto.getFieldName(), fieldDto.getJavaDoc()}).initializer("$T.unsetValue()", new Object[]{builderFieldWrapper}).build();
    }

    private MethodSpec createMethodBuild(ClassName dtoBaseClass, TypeName returnType, List<FieldDto> constructorFields, List<FieldDto> setterFields, List<GenericParameterDto> generics) {
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(returnType).addAnnotation(Override.class);
        String ctorArgs = constructorFields.stream().map(FieldDto::getFieldName).map(n -> String.format("this.%s.value()", n)).reduce((a, b) -> a + ", " + b).orElse("");
        if (generics.isEmpty()) {
            mb.addStatement("$1T result = new $1T($2L)", new Object[]{dtoBaseClass, ctorArgs});
        } else {
            mb.addStatement("$1T result = new $2T<>($3L)", new Object[]{returnType, dtoBaseClass, ctorArgs});
        }
        for (FieldDto f : setterFields) {
            mb.addStatement("this.$N.ifChanged(result::$N)", new Object[]{f.getFieldName(), f.getSetterName()});
        }
        mb.addStatement("return result", new Object[0]);
        return mb.build();
    }

    private MethodSpec createMethodStaticCreate(ClassName builderBaseClass, TypeName builderType, ClassName dtoBaseClass, List<GenericParameterDto> generics) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addJavadoc("Creating a new builder for {@code $1N.$2T}.\n\n@return builder for {@code $1N.$2T}\n", new Object[]{dtoBaseClass.packageName(), dtoBaseClass});
        if (generics.isEmpty()) {
            methodBuilder.returns((TypeName)builderBaseClass).addCode("return new $1T();\n", new Object[]{builderBaseClass});
        } else {
            methodBuilder.returns(builderType).addTypeVariables(JavapoetMapper.map2TypeVariables(generics)).addCode("return new $1T<>();\n", new Object[]{builderBaseClass});
        }
        return methodBuilder.build();
    }

    private List<MethodSpec> createFieldMethods(FieldDto fieldDto, TypeName builderTypeName) {
        return fieldDto.getMethods().stream().map(m -> this.createMethod((MethodDto)m, builderTypeName, fieldDto.getJavaDoc())).toList();
    }

    private MethodSpec createMethod(MethodDto methodDto, TypeName returnType, String optionalFieldParamJavaDoc) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodDto.getMethodName()).returns(returnType);
        methodDto.getModifier().ifPresent(xva$0 -> methodBuilder.addModifiers(new Modifier[]{xva$0}));
        int maxIndexParameters = methodDto.getParameters().size() - 1;
        switch (methodDto.getMethodType()) {
            case PROXY: {
                methodBuilder.addJavadoc("Sets the value for <code>$1N</code>.\n", new Object[]{methodDto.getMethodName()});
                break;
            }
            case CONSUMER: {
                methodBuilder.addJavadoc("Sets the value for <code>$1N</code> by executing the provided consumer.\n", new Object[]{methodDto.createFieldSetterMethodName()});
                break;
            }
            case CONSUMER_BY_BUILDER: {
                methodBuilder.addJavadoc("Sets the value for <code>$1N</code> using a builder consumer that produces the value.\n", new Object[]{methodDto.createFieldSetterMethodName()});
                break;
            }
            case SUPPLIER: {
                methodBuilder.addJavadoc("Sets the value for <code>$1N</code> by invoking the provided supplier.\n", new Object[]{methodDto.createFieldSetterMethodName()});
            }
        }
        block12: for (int i = 0; i <= maxIndexParameters; ++i) {
            MethodParameterDto paramDto = methodDto.getParameters().get(i);
            TypeName parameterType = JavapoetMapper.map2ParameterType(paramDto.getParameterType());
            methodBuilder.addParameter(parameterType, paramDto.getParameterName(), new Modifier[0]);
            if (i == maxIndexParameters && paramDto.getParameterType() instanceof TypeNameArray) {
                methodBuilder.varargs();
            }
            switch (methodDto.getMethodType()) {
                case PROXY: {
                    methodBuilder.addJavadoc("\n@param $1N $2L", new Object[]{paramDto.getParameterName(), optionalFieldParamJavaDoc});
                    continue block12;
                }
                case CONSUMER: {
                    methodBuilder.addJavadoc("\n@param $1N consumer providing an instance of $2L", new Object[]{paramDto.getParameterName(), optionalFieldParamJavaDoc});
                    continue block12;
                }
                case CONSUMER_BY_BUILDER: {
                    methodBuilder.addJavadoc("\n@param $1N consumer providing an instance of a builder for $2L", new Object[]{paramDto.getParameterName(), optionalFieldParamJavaDoc});
                    continue block12;
                }
                case SUPPLIER: {
                    methodBuilder.addJavadoc("\n@param $1N supplier for $2L", new Object[]{paramDto.getParameterName(), optionalFieldParamJavaDoc});
                }
            }
        }
        CodeBlock codeBlock = JavapoetMapper.map2CodeBlock(methodDto.getMethodCodeDto());
        methodBuilder.addCode(codeBlock).addJavadoc("\n@return current instance of builder", new Object[0]);
        return methodBuilder.build();
    }
}

