/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor14;
import org.javahelpers.simple.builders.processor.dtos.GenericParameterDto;
import org.javahelpers.simple.builders.processor.dtos.MethodParameterDto;
import org.javahelpers.simple.builders.processor.dtos.TypeName;
import org.javahelpers.simple.builders.processor.dtos.TypeNameArray;
import org.javahelpers.simple.builders.processor.dtos.TypeNameGeneric;
import org.javahelpers.simple.builders.processor.dtos.TypeNamePrimitive;
import org.javahelpers.simple.builders.processor.dtos.TypeNameVariable;
import org.javahelpers.simple.builders.processor.util.ProcessingContext;

public final class JavaLangMapper {
    private JavaLangMapper() {
    }

    public static Modifier mapRelevantModifier(Set<Modifier> modifier) {
        if (modifier.contains((Object)Modifier.PUBLIC)) {
            return Modifier.PUBLIC;
        }
        if (modifier.contains((Object)Modifier.PROTECTED)) {
            return Modifier.PROTECTED;
        }
        return Modifier.DEFAULT;
    }

    public static TypeName map2TypeName(Class<?> clazz) {
        return new TypeName(clazz.getPackageName(), clazz.getSimpleName());
    }

    public static List<GenericParameterDto> map2GenericParameterDtos(TypeElement type, ProcessingContext context) {
        return type.getTypeParameters().stream().map(tp -> JavaLangMapper.map2GenericParameterDto(tp, context)).toList();
    }

    public static GenericParameterDto map2GenericParameterDto(TypeParameterElement tp, ProcessingContext context) {
        GenericParameterDto g = new GenericParameterDto();
        g.setName(tp.getSimpleName().toString());
        tp.getBounds().stream().filter(b -> !"java.lang.Object".equals(b.toString())).map(b -> JavaLangMapper.extractType(b, context)).forEach(g::addUpperBound);
        return g;
    }

    public static MethodParameterDto map2MethodParameter(VariableElement param, ProcessingContext context) {
        MethodParameterDto result = new MethodParameterDto();
        result.setParameterName(param.getSimpleName().toString());
        TypeMirror typeMirror = param.asType();
        TypeName typeName = JavaLangMapper.extractType(typeMirror, context);
        if (typeName == null) {
            return null;
        }
        result.setParameterTypeName(typeName);
        return result;
    }

    private static List<TypeName> extractTypeForList(List<TypeMirror> typeMirrors, ProcessingContext context) {
        ArrayList<TypeName> result = new ArrayList<TypeName>(typeMirrors.size());
        for (TypeMirror tm : typeMirrors) {
            result.add(JavaLangMapper.extractType(tm, context));
        }
        return result;
    }

    private static TypeName extractType(final TypeMirror typeOfParameter, final ProcessingContext context) {
        return typeOfParameter.accept(new SimpleTypeVisitor14<TypeName, Void>(){

            @Override
            public TypeName visitPrimitive(PrimitiveType t, Void p) {
                return switch (t.getKind()) {
                    case TypeKind.BOOLEAN -> TypeNamePrimitive.BOOLEAN;
                    case TypeKind.BYTE -> TypeNamePrimitive.BYTE;
                    case TypeKind.SHORT -> TypeNamePrimitive.SHORT;
                    case TypeKind.INT -> TypeNamePrimitive.INT;
                    case TypeKind.LONG -> TypeNamePrimitive.LONG;
                    case TypeKind.CHAR -> TypeNamePrimitive.CHAR;
                    case TypeKind.FLOAT -> TypeNamePrimitive.FLOAT;
                    case TypeKind.DOUBLE -> TypeNamePrimitive.DOUBLE;
                    default -> throw new IllegalStateException("Unsupported Primitive type");
                };
            }

            @Override
            public TypeName visitDeclared(DeclaredType t, Void p) {
                TypeName enclosing;
                TypeElement elementOfParameter = (TypeElement)context.asElement(typeOfParameter);
                String simpleClassName = elementOfParameter.getSimpleName().toString();
                String packageName = context.getPackageName(elementOfParameter);
                TypeName rawType = new TypeName(packageName, simpleClassName);
                TypeMirror enclosingType = t.getEnclosingType();
                TypeName typeName = enclosing = enclosingType.getKind() != TypeKind.NONE && !t.asElement().getModifiers().contains((Object)Modifier.STATIC) ? enclosingType.accept(this, null) : null;
                if (t.getTypeArguments().isEmpty() && !(enclosing instanceof TypeNameGeneric)) {
                    return rawType;
                }
                ArrayList<TypeMirror> typesExtracted = new ArrayList<TypeMirror>(t.getTypeArguments());
                if (typesExtracted.isEmpty()) {
                    return rawType;
                }
                List<TypeName> argTypes = JavaLangMapper.extractTypeForList(typesExtracted, context);
                return new TypeNameGeneric(rawType, argTypes);
            }

            @Override
            public TypeNameArray visitArray(ArrayType t, Void p) {
                return new TypeNameArray(JavaLangMapper.extractType(t.getComponentType(), context), false);
            }

            @Override
            public TypeName visitTypeVariable(TypeVariable t, Void p) {
                String name = t.asElement().getSimpleName().toString();
                return new TypeNameVariable(name);
            }

            @Override
            protected TypeName defaultAction(TypeMirror e, Void p) {
                throw new IllegalArgumentException("Unexpected type mirror: " + String.valueOf(e));
            }
        }, null);
    }
}

