/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import com.palantir.javapoet.ArrayTypeName;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javahelpers.simple.builders.processor.dtos.GenericParameterDto;
import org.javahelpers.simple.builders.processor.dtos.MethodCodeDto;
import org.javahelpers.simple.builders.processor.dtos.MethodCodePlaceholder;
import org.javahelpers.simple.builders.processor.dtos.MethodCodeStringPlaceholder;
import org.javahelpers.simple.builders.processor.dtos.MethodCodeTypePlaceholder;
import org.javahelpers.simple.builders.processor.dtos.TypeName;
import org.javahelpers.simple.builders.processor.dtos.TypeNameArray;
import org.javahelpers.simple.builders.processor.dtos.TypeNameGeneric;
import org.javahelpers.simple.builders.processor.dtos.TypeNamePrimitive;
import org.javahelpers.simple.builders.processor.dtos.TypeNameVariable;

public final class JavapoetMapper {
    private JavapoetMapper() {
    }

    public static com.palantir.javapoet.TypeName[] map2TypeArgumentsArray(List<TypeName> typeArguments) {
        ArrayList<com.palantir.javapoet.TypeName> args = new ArrayList<com.palantir.javapoet.TypeName>(typeArguments.size());
        for (TypeName tn : typeArguments) {
            com.palantir.javapoet.TypeName mapped = JavapoetMapper.map2ParameterType(tn);
            if (mapped.isPrimitive()) {
                mapped = mapped.box();
            }
            args.add(mapped);
        }
        return args.toArray(new com.palantir.javapoet.TypeName[0]);
    }

    public static com.palantir.javapoet.TypeName map2ParameterType(TypeName parameterType) {
        if (parameterType instanceof TypeNameVariable) {
            TypeNameVariable typeVariable = (TypeNameVariable)parameterType;
            return TypeVariableName.get((String)typeVariable.getClassName());
        }
        ClassName classNameParameter = ClassName.get((String)parameterType.getPackageName(), (String)parameterType.getClassName(), (String[])new String[0]);
        if (parameterType instanceof TypeNameArray) {
            TypeNameArray parameterTypeArray = (TypeNameArray)parameterType;
            return ArrayTypeName.of((com.palantir.javapoet.TypeName)JavapoetMapper.map2ParameterType(parameterTypeArray.getTypeOfArray()));
        }
        if (parameterType instanceof TypeNamePrimitive) {
            TypeNamePrimitive parameterTypePrim = (TypeNamePrimitive)parameterType;
            return switch (parameterTypePrim.getType()) {
                case TypeNamePrimitive.PrimitiveTypeEnum.BOOLEAN -> com.palantir.javapoet.TypeName.BOOLEAN;
                case TypeNamePrimitive.PrimitiveTypeEnum.BYTE -> com.palantir.javapoet.TypeName.BYTE;
                case TypeNamePrimitive.PrimitiveTypeEnum.CHAR -> com.palantir.javapoet.TypeName.CHAR;
                case TypeNamePrimitive.PrimitiveTypeEnum.DOUBLE -> com.palantir.javapoet.TypeName.DOUBLE;
                case TypeNamePrimitive.PrimitiveTypeEnum.FLOAT -> com.palantir.javapoet.TypeName.FLOAT;
                case TypeNamePrimitive.PrimitiveTypeEnum.INT -> com.palantir.javapoet.TypeName.INT;
                case TypeNamePrimitive.PrimitiveTypeEnum.LONG -> com.palantir.javapoet.TypeName.LONG;
                case TypeNamePrimitive.PrimitiveTypeEnum.SHORT -> com.palantir.javapoet.TypeName.SHORT;
                default -> null;
            };
        }
        if (parameterType instanceof TypeNameGeneric) {
            TypeNameGeneric param = (TypeNameGeneric)parameterType;
            com.palantir.javapoet.TypeName[] typeArgs = JavapoetMapper.map2TypeArgumentsArray(param.getInnerTypeArguments());
            return ParameterizedTypeName.get((ClassName)classNameParameter, (com.palantir.javapoet.TypeName[])typeArgs);
        }
        return classNameParameter;
    }

    public static ClassName map2ClassName(TypeName typeName) {
        return ClassName.get((String)typeName.getPackageName(), (String)typeName.getClassName(), (String[])new String[0]);
    }

    public static ParameterizedTypeName map2ParameterizedTypeName(TypeName baseType, List<GenericParameterDto> builderGenerics) {
        ClassName baseTypeClassName = JavapoetMapper.map2ClassName(baseType);
        return ParameterizedTypeName.get((ClassName)baseTypeClassName, (com.palantir.javapoet.TypeName[])((com.palantir.javapoet.TypeName[])JavapoetMapper.map2TypeVariables(builderGenerics).toArray(new TypeVariableName[0])));
    }

    public static List<TypeVariableName> map2TypeVariables(List<GenericParameterDto> builderGenerics) {
        ArrayList<TypeVariableName> javapoetGenerics = new ArrayList<TypeVariableName>();
        for (GenericParameterDto g : builderGenerics) {
            ArrayList<com.palantir.javapoet.TypeName> bounds = new ArrayList<com.palantir.javapoet.TypeName>();
            for (TypeName b : g.getUpperBounds()) {
                bounds.add(JavapoetMapper.map2ParameterType(b));
            }
            TypeVariableName tv = bounds.isEmpty() ? TypeVariableName.get((String)g.getName()) : TypeVariableName.get((String)g.getName(), (com.palantir.javapoet.TypeName[])bounds.toArray(new com.palantir.javapoet.TypeName[0]));
            javapoetGenerics.add(tv);
        }
        return javapoetGenerics;
    }

    public static CodeBlock map2CodeBlock(MethodCodeDto codeDto) {
        Map<String, Object> arguments = codeDto.getCodeArguments().stream().collect(Collectors.toMap(MethodCodePlaceholder::getLabel, JavapoetMapper::toCodeblockValue));
        return CodeBlock.builder().addNamed(codeDto.getCodeFormat(), arguments).build();
    }

    private static Object toCodeblockValue(MethodCodePlaceholder<?> placeHolderValue) {
        if (placeHolderValue instanceof MethodCodeStringPlaceholder) {
            MethodCodeStringPlaceholder stringPlaceholder = (MethodCodeStringPlaceholder)placeHolderValue;
            return stringPlaceholder.getValue();
        }
        if (placeHolderValue instanceof MethodCodeTypePlaceholder) {
            MethodCodeTypePlaceholder typePlaceholder = (MethodCodeTypePlaceholder)placeHolderValue;
            return JavapoetMapper.map2ParameterType((TypeName)typePlaceholder.getValue());
        }
        throw new UnsupportedOperationException("");
    }
}

