/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.javahelpers.simple.builders.processor.util.ProcessingLogger;

public final class ProcessingContext {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final ProcessingLogger logger;

    public ProcessingContext(Elements elementUtils, Types typeUtils, ProcessingLogger logger) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.logger = logger;
    }

    public TypeElement getTypeElement(String qualifiedName) {
        return this.elementUtils.getTypeElement(qualifiedName);
    }

    public PackageElement getPackageOf(Element element) {
        return this.elementUtils.getPackageOf(element);
    }

    public String getPackageName(Element element) {
        return this.elementUtils.getPackageOf(element).getQualifiedName().toString();
    }

    public List<? extends Element> getAllMembers(TypeElement typeElement) {
        return this.elementUtils.getAllMembers(typeElement);
    }

    public String getDocComment(Element element) {
        return this.elementUtils.getDocComment(element);
    }

    public Element asElement(TypeMirror typeMirror) {
        return this.typeUtils.asElement(typeMirror);
    }

    public boolean isSameType(TypeMirror type1, TypeMirror type2) {
        return this.typeUtils.isSameType(type1, type2);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String format, Object ... args) {
        this.logger.info(format, args);
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void debug(String format, Object ... args) {
        this.logger.debug(format, args);
    }

    public void warning(Element element, String format, Object ... args) {
        this.logger.warning(element, format, args);
    }

    public void error(String format, Object ... args) {
        this.logger.error(format, args);
    }
}

