/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class ProcessingLogger {
    private final Messager messager;
    private final boolean debugEnabled;

    public ProcessingLogger(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.debugEnabled = "true".equalsIgnoreCase(processingEnv.getOptions().get("verbose"));
    }

    public void error(String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(format, args));
    }

    public void info(String message) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    public void info(String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(format, args));
    }

    public void debug(String message) {
        if (this.debugEnabled) {
            String formatWithDebug = "[DEBUG] " + message;
            this.messager.printMessage(Diagnostic.Kind.OTHER, formatWithDebug);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.debugEnabled) {
            String formatWithDebug = "[DEBUG] " + format;
            this.messager.printMessage(Diagnostic.Kind.OTHER, String.format(formatWithDebug, args));
        }
    }

    public void warning(Element e, String format, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(format, args), e);
    }
}

