/*
 * Decompiled with CFR 0.152.
 */
package org.javahelpers.simple.builders.processor.util;

import org.apache.commons.lang3.Strings;
import org.javahelpers.simple.builders.processor.dtos.TypeName;

public class TypeNameAnalyser {
    private static final String JAVA_UTIL_PACKAGE = "java.util";

    private TypeNameAnalyser() {
    }

    public static boolean isMap(TypeName typeName) {
        return Strings.CI.equals(typeName.getPackageName(), JAVA_UTIL_PACKAGE) && Strings.CI.equals(typeName.getClassName(), "Map");
    }

    public static boolean isJavaClass(TypeName typeName) {
        return Strings.CI.equalsAny((CharSequence)typeName.getPackageName(), new CharSequence[]{"java.lang", "java.time", JAVA_UTIL_PACKAGE});
    }

    public static boolean isSet(TypeName typeName) {
        return Strings.CI.equals(typeName.getPackageName(), JAVA_UTIL_PACKAGE) && Strings.CI.equals(typeName.getClassName(), "Set");
    }

    public static boolean isList(TypeName typeName) {
        return Strings.CI.equals(typeName.getPackageName(), JAVA_UTIL_PACKAGE) && Strings.CI.equals(typeName.getClassName(), "List");
    }
}

