/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gorules.zen.ZenEngineConfig;
import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen_engine.JsonBuffer;
import io.gorules.zen_engine.ZenDecision;
import io.gorules.zen_engine.ZenDecisionLoaderCallback;
import io.gorules.zen_engine.ZenEngine;
import io.gorules.zen_engine.ZenEngineResponse;
import io.gorules.zen_engine.ZenEvaluateOptions;
import io.gorules.zen_engine.ZenException;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class ZenEngineWrapper
implements AutoCloseable {
    private final ZenEngine engine;
    private final ZenEngineConfig config;
    private final ObjectMapper objectMapper;

    public ZenEngineWrapper(ZenEngineConfig config) {
        this.config = config;
        this.objectMapper = new ObjectMapper();
        DecisionLoader loader = config.getLoader();
        ZenDecisionLoaderCallback loaderCallback = loader::load;
        this.engine = new ZenEngine(loaderCallback, null);
    }

    public CompletableFuture<JsonNode> evaluate(String key, JsonNode input) {
        return this.evaluate(key, input, null);
    }

    public CompletableFuture<JsonNode> evaluate(String key, JsonNode input, ZenEvaluateOptions options) {
        try {
            byte[] inputBytes = this.objectMapper.writeValueAsBytes((Object)input);
            JsonBuffer inputBuffer = new JsonBuffer(inputBytes);
            if (options == null) {
                options = new ZenEvaluateOptions(Byte.valueOf((byte)this.config.getMaxDepth()), Boolean.valueOf(this.config.isEnableTrace()));
            }
            return this.engine.evaluate(key, inputBuffer, options).thenApply(response -> {
                try {
                    String resultJson = response.result().toString();
                    return this.objectMapper.readTree(resultJson);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse result", e);
                }
            });
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new RuntimeException("Failed to serialize input", e));
        }
    }

    public CompletableFuture<ZenEngineResponse> evaluateWithTrace(String key, JsonNode input, ZenEvaluateOptions options) {
        try {
            byte[] inputBytes = this.objectMapper.writeValueAsBytes((Object)input);
            JsonBuffer inputBuffer = new JsonBuffer(inputBytes);
            if (options == null) {
                options = new ZenEvaluateOptions(Byte.valueOf((byte)this.config.getMaxDepth()), Boolean.valueOf(true));
            }
            return this.engine.evaluate(key, inputBuffer, options);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new RuntimeException("Failed to serialize input", e));
        }
    }

    public CompletableFuture<ZenDecision> getDecision(String key) {
        return this.engine.getDecision(key);
    }

    public ZenDecision createDecision(JsonNode content) throws ZenException {
        try {
            byte[] contentBytes = this.objectMapper.writeValueAsBytes((Object)content);
            JsonBuffer contentBuffer = new JsonBuffer(contentBytes);
            return this.engine.createDecision(contentBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize decision content", e);
        }
    }

    public ZenDecision createDecision(String jsonContent) throws ZenException {
        byte[] contentBytes = jsonContent.getBytes();
        JsonBuffer contentBuffer = new JsonBuffer(contentBytes);
        return this.engine.createDecision(contentBuffer);
    }

    @Override
    public void close() {
        this.engine.close();
    }

    public ZenEngine getEngine() {
        return this.engine;
    }

    public ZenEngineConfig getConfig() {
        return this.config;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

