/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.javapoet;

import io.jbock.simple.javapoet.AnnotationSpec;
import io.jbock.simple.javapoet.CodeWriter;
import io.jbock.simple.javapoet.TypeName;
import io.jbock.simple.javapoet.TypeVariableName;
import io.jbock.simple.javapoet.Util;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;

public final class ArrayTypeName
extends TypeName {
    public final TypeName componentType;

    private ArrayTypeName(TypeName componentType) {
        this(componentType, new ArrayList<AnnotationSpec>());
    }

    private ArrayTypeName(TypeName componentType, List<AnnotationSpec> annotations) {
        super(annotations);
        this.componentType = Util.checkNotNull(componentType, "rawType == null", new Object[0]);
    }

    @Override
    public ArrayTypeName annotated(List<AnnotationSpec> annotations) {
        return new ArrayTypeName(this.componentType, this.concatAnnotations(annotations));
    }

    @Override
    public TypeName withoutAnnotations() {
        return new ArrayTypeName(this.componentType);
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        return this.emit(out, false);
    }

    CodeWriter emit(CodeWriter out, boolean varargs) throws IOException {
        this.emitLeafType(out);
        return this.emitBrackets(out, varargs);
    }

    private CodeWriter emitLeafType(CodeWriter out) throws IOException {
        if (TypeName.asArray(this.componentType) != null) {
            return TypeName.asArray(this.componentType).emitLeafType(out);
        }
        return this.componentType.emit(out);
    }

    private CodeWriter emitBrackets(CodeWriter out, boolean varargs) throws IOException {
        if (this.isAnnotated()) {
            out.emit(" ");
            this.emitAnnotations(out);
        }
        if (TypeName.asArray(this.componentType) == null) {
            return out.emit(varargs ? "..." : "[]");
        }
        out.emit("[]");
        return TypeName.asArray(this.componentType).emitBrackets(out, varargs);
    }

    public static ArrayTypeName of(TypeName componentType) {
        return new ArrayTypeName(componentType);
    }

    public static ArrayTypeName of(Type componentType) {
        return ArrayTypeName.of(TypeName.get(componentType));
    }

    public static ArrayTypeName get(ArrayType mirror) {
        return ArrayTypeName.get(mirror, new LinkedHashMap<TypeParameterElement, TypeVariableName>());
    }

    static ArrayTypeName get(ArrayType mirror, Map<TypeParameterElement, TypeVariableName> typeVariables) {
        return new ArrayTypeName(ArrayTypeName.get(mirror.getComponentType(), typeVariables));
    }

    public static ArrayTypeName get(GenericArrayType type) {
        return ArrayTypeName.get(type, new LinkedHashMap<Type, TypeVariableName>());
    }

    static ArrayTypeName get(GenericArrayType type, Map<Type, TypeVariableName> map) {
        return ArrayTypeName.of(ArrayTypeName.get(type.getGenericComponentType(), map));
    }
}

