/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor;

import io.jbock.simple.Inject;
import io.jbock.simple.processor.ContextComponent_Impl;
import io.jbock.simple.processor.binding.Binding;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.Key;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.graph.TopologicalSorter;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.writing.ComponentImpl;
import io.jbock.simple.processor.writing.Context;
import io.jbock.simple.processor.writing.ContextModule;
import io.jbock.simple.processor.writing.NamedBinding;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;

public interface ContextComponent {
    public KeyFactory keyFactory();

    public ComponentElement componentElement();

    public ComponentImpl componentImpl();

    public static Context createContext(TopologicalSorter topologicalSorter, KeyFactory keyFactory) {
        List<Binding> bindings = topologicalSorter.sortedBindings();
        Map<Key, NamedBinding> sorted = ContextModule.addNames(keyFactory, bindings);
        return new Context(sorted, ContextModule.createNames(sorted));
    }

    public static final class Factory {
        private final TypeTool tool;

        @Inject
        public Factory(TypeTool tool) {
            this.tool = tool;
        }

        public ContextComponent create(TypeElement typeElement) {
            return ContextComponent_Impl.builder().typeElement(typeElement).tool(this.tool).build();
        }
    }

    public static interface Builder {
        public Builder typeElement(TypeElement var1);

        public Builder tool(TypeTool var1);

        public ContextComponent build();
    }
}

