/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.simple.processor;

import io.jbock.simple.processor.ContextComponent;
import io.jbock.simple.processor.binding.ComponentElement;
import io.jbock.simple.processor.binding.InjectBindingCache;
import io.jbock.simple.processor.binding.InjectBindingFactory;
import io.jbock.simple.processor.binding.InjectBindingScanner;
import io.jbock.simple.processor.binding.KeyCache;
import io.jbock.simple.processor.binding.KeyFactory;
import io.jbock.simple.processor.graph.GraphFactory;
import io.jbock.simple.processor.graph.MissingBindingPrinter;
import io.jbock.simple.processor.graph.TopologicalSorter;
import io.jbock.simple.processor.util.TypeTool;
import io.jbock.simple.processor.writing.BuilderImpl;
import io.jbock.simple.processor.writing.ComponentImpl;
import io.jbock.simple.processor.writing.Context;
import io.jbock.simple.processor.writing.FactoryImpl;
import io.jbock.simple.processor.writing.MockBuilder;
import javax.lang.model.element.TypeElement;

public final class ContextComponent_Impl
implements ContextComponent {
    private final ComponentElement componentElement;
    private final KeyFactory keyFactory;
    private final ComponentImpl componentImpl;

    private ContextComponent_Impl(ComponentElement componentElement, KeyFactory keyFactory, ComponentImpl componentImpl) {
        this.componentElement = componentElement;
        this.keyFactory = keyFactory;
        this.componentImpl = componentImpl;
    }

    @Override
    public KeyFactory keyFactory() {
        return this.keyFactory;
    }

    @Override
    public ComponentElement componentElement() {
        return this.componentElement;
    }

    @Override
    public ComponentImpl componentImpl() {
        return this.componentImpl;
    }

    public static Builder_Impl builder() {
        return new Builder_Impl();
    }

    public static final class Builder_Impl
    implements ContextComponent.Builder {
        TypeElement typeElement;
        TypeTool tool;

        @Override
        public Builder_Impl typeElement(TypeElement typeElement) {
            this.typeElement = typeElement;
            return this;
        }

        @Override
        public Builder_Impl tool(TypeTool tool) {
            this.tool = tool;
            return this;
        }

        @Override
        public ContextComponent build() {
            ComponentElement componentElement = new ComponentElement(this.typeElement);
            MissingBindingPrinter missingBindingPrinter = new MissingBindingPrinter(componentElement);
            InjectBindingScanner injectBindingScanner = new InjectBindingScanner(this.tool);
            KeyCache keyCache = new KeyCache(this.tool);
            KeyFactory keyFactory = new KeyFactory(this.tool, componentElement, keyCache);
            InjectBindingCache injectBindingCache = new InjectBindingCache();
            InjectBindingFactory injectBindingFactory = new InjectBindingFactory(this.tool, injectBindingCache, keyFactory, injectBindingScanner);
            GraphFactory graphFactory = new GraphFactory(this.tool, keyFactory, injectBindingFactory, missingBindingPrinter);
            TopologicalSorter topologicalSorter = new TopologicalSorter(graphFactory, componentElement, keyFactory);
            Context context = ContextComponent.createContext(topologicalSorter, keyFactory);
            FactoryImpl factoryImpl = new FactoryImpl(componentElement, context);
            BuilderImpl builderImpl = new BuilderImpl(componentElement, context);
            MockBuilder mockBuilder2 = new MockBuilder(componentElement, context);
            ComponentImpl componentImpl = new ComponentImpl(keyFactory, componentElement, context, mockBuilder2, builderImpl, factoryImpl);
            return new ContextComponent_Impl(componentElement, keyFactory, componentImpl);
        }
    }
}

